$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    })
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova operação.",
          position: "right",
        },
      },
      {
        element: "#tabelaItens",
        popover: {
          title: "Tabela de Etapas",
          description: "Aqui está a lista de etapas cadastradas.",
          position: "top",
        },
      },
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const columns = [
    {
      data: 'etapa',
      title: 'Etapa',
      render: (data) => retornarBotaoOpcoes(data)
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: (data) => data.toLocaleString('pt-BR')
    },
    {
      data: 'mediaDiasEtapa',
      title: 'Média',
      className: 'text-right',
      visible: false,
    },
    {
      data: 'tipo',
      title: 'Tipo',
      visible: false,
    },
  ]

  const retornarDados = async () => {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('GET', `/sisplan/centralcompras/v1/dadosacesso?`, '', '', 3600000)

      const data = await response.json()

      if (data) {
        const { resultado, mensagem } = data
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (resultado) {
          const { itensSolicitacao, itensCompra, itensCotacao } = resultado
          ItensSolicitacaoAcesso.criarTabelaEtapas({ data: itensSolicitacao ?? [], columns, })
          ItensSolicitacaoAcesso.carregarGrafico({ data: itensSolicitacao ?? [] })
          ItensCotacaoAcesso.criarTabelaEtapas({ data: itensCotacao ?? [], columns, })
          ItensCotacaoAcesso.carregarGrafico({ data: itensCotacao ?? [] })
          ItensCompraAcesso.criarTabelaEtapas({ data: itensCompra ?? [], columns, })
          ItensCompraAcesso.carregarGrafico({ data: itensCompra ?? [] })
          return
        }
      }
    } catch (error) {
      msgErro(error ?? 'Ocorreu um erro ao buscar os dados.')
    } finally {
      $('#modal-filtros').modal('hide')
      $.LoadingOverlay('hide')
    }
  }

  const retornarBotaoOpcoes = (data) => {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes flex justify-content-between align-items-center" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="min-width: 215px"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '</div>'
    return retorno
  }

  retornarDados()
})