window.GraficosCentralCompras = window.GraficosCentralCompras || {}
GraficosCentralCompras.criarGraficoBarra = ({ container, data, categories }) => {
  Highcharts.chart(container, {
    credits: {
      enabled: false,
    },
    chart: {
      height: 275,
      options3d: {
        enabled: true,
        alpha: 15,
        beta: 0,
        depth: 50,
        viewDistance: 25
      }
    },
    title: {
      text: null,
    },
    xAxis: {
      categories,
      labels: {
        style: {
          color: 'var(--font-color)',
          fontSize: '14px',
          fontWeight: 'bold',
          textOutline: 'none',
        },
      },
    },
    yAxis: {
      title: {
        text: null,
      },
      labels: {
        skew3d: true,
        formatter: function () {
          return this.value.toLocaleString('pt-BR')
        },
        style: {
          color: 'var(--font-color)',
        },
      },
    },
    tooltip: {
      formatter: function () {
        let total = this.series.data.reduce((acc, point) => acc + point.y, 0)
        let percentage = ((this.y / total) * 100).toFixed(0)
        return `Percentual: <b>${percentage}%</b>`
      },
    },
    plotOptions: {
      series: {
        depth: 50,
        pointWidth: 50,
        colorByPoint: true,
        cursor: 'pointer',
        borderRadius: 8,
        borderWidth: 1,
        dataLabels: {
          enabled: true,
          formatter: function () {
            return this.y.toLocaleString('pt-BR')
          },
          align: 'left',
          verticalAlign: 'middle',
          x: 30,
          y: -15,
          style: {
            fontSize: '12px',
            color: 'var(--font-color)',
            textOutline: 'none',
          },
          connectorColor: 'black',
          connectorWidth: 1,
        },
      },
    },
    series: [
      {
        type: 'column',
        data,
        name: 'Quantidade',
        showInLegend: false,
      },
    ],
  })
}

GraficosCentralCompras.criarGraficoDonut = ({ container, data, grafico3d }) => {
  Highcharts.chart(container, {
    credits: {
      enabled: false,
    },
    chart: {
      type: 'pie',
      height: 275,
      custom: {},
      options3d: grafico3d && {
        enabled: true,
        alpha: 45,
      },
      events: {
        render() {
          const chart = this,
            series = chart.series[0]
          let customLabel = chart.options.chart.custom.label

          if (!customLabel) {
            const total = series.data.reduce((sum, point) => sum + point.y, 0)
            customLabel = chart.options.chart.custom.label =
              chart.renderer.label(
                `<strong style="color: var(--font-color); font-size: 1.5rem">${total.toLocaleString('pt-BR')}</strong>`
              )
                .css({
                  color: '#000',
                  textAnchor: 'middle'
                })
                .add()
          }

          const x = series.center[0] + chart.plotLeft,
            y = series.center[1] + chart.plotTop -
              (customLabel.attr('height') / 2) + 12

          customLabel.attr({
            x,
            y,
          })
          customLabel.css({
            fontSize: `${series.center[2] / 12}px`,
          })
        }
      }
    },
    accessibility: {
      point: {
        valueSuffix: '%',
      },
    },
    title: {
      text: null,
    },
    tooltip: {
      pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>',
      formatter: function () {
        return this.series.name + ': <b>' + this.percentage.toFixed(0) + '%</b>'
      }
    },
    legend: {
      enabled: false,
      useHTML: true,
      labelFormatter: function () {
        return `<span style="color:${this.color}">\u25A0</span> ${this.name}`
      },
    },
    plotOptions: {
      pie: {
        allowPointSelect: true,
        cursor: 'pointer',
        dataLabels: {
          enabled: false,
        },
        showInLegend: true,
        depth: grafico3d ? 45 : null,
      },
      series: {
        allowPointSelect: true,
        cursor: 'pointer',
        borderRadius: 8,
        borderWidth: 2,
        borderColor: 'var(--borda-grafico)',
        dataLabels: [
          {
            enabled: true,
            distance: 20,
            formatter: function () {
              return `${this.name} - ${this.y.toLocaleString('pt-BR')}`
            },
            style: {
              color: 'var(--font-color)',
              fontSize: '14px',
              fontWeight: 'bold',
              textOutline: 'none',
            },
          },
          {
            enabled: false,
            distance: -17.5,
            format: '{point.percentage:.0f}%',
            style: {
              fontSize: '0.8rem',
            },
            filter: {
              operator: '>',
              property: 'percentage',
              value: 5,
            },
          },
        ],
      },
    },
    series: [
      {
        name: 'Percentual',
        colorByPoint: true,
        innerSize: '70%',
        data,
      },
    ],
  })
}

GraficosCentralCompras.criarGraficoPizza = ({ container, data, grafico3d }) => {
  Highcharts.chart(container, {
    credits: {
      enabled: false,
    },
    chart: {
      type: 'pie',
      height: 275,
      custom: {},
      options3d: grafico3d && {
        enabled: true,
        alpha: 45,
      },
    },
    accessibility: {
      point: {
        valueSuffix: '%',
      },
    },
    title: {
      // text: '<span style="color: var(--font-color)">Itens de Solicitação</span>'
      text: null,
    },
    tooltip: {
      pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>',
      formatter: function () {
        return this.series.name + ': <b>' + this.percentage.toFixed(0) + '%</b>'
      },
    },
    legend: {
      enabled: false,
      useHTML: true,
      labelFormatter: function () {
        return `<span style="color:${this.color}">\u25A0</span> ${this.name}`
      },
    },
    plotOptions: {
      pie: {
        allowPointSelect: true,
        cursor: 'pointer',
        dataLabels: {
          enabled: false,
        },
        showInLegend: true,
        depth: grafico3d ? 45 : null,
      },
      series: {
        allowPointSelect: true,
        cursor: 'pointer',
        borderWidth: 2,
        borderColor: 'var(--borda-grafico)',
        dataLabels: [
          {
            enabled: true,
            distance: 20,
            formatter: function () {
              return `${this.name} - ${this.y.toLocaleString('pt-BR')}`
            },
            style: {
              color: 'var(--font-color)',
              fontSize: '14px',
              fontWeight: 'bold',
              textOutline: 'none',
            },
          },
          {
            enabled: false,
            distance: -17.5,
            format: '{point.percentage:.0f}%',
            style: {
              fontSize: '0.8rem',
            },
            filter: {
              operator: '>',
              property: 'percentage',
              value: 5,
            },
          },
        ],
      },
    },
    series: [
      {
        name: 'Percentual',
        colorByPoint: true,
        data,
      },
    ],
  })
}