$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma ordem de compra.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as ordens de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaOrdemCompra',
        popover: {
          title: 'Tabela Ordem Compra',
          description: 'Aqui estão os dados das ordens de compra cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

const columnsGridPrincipal = [
  { "data": "id", "title": "ID" },
  { "data": "codcli", "title": "Cliente" },
  { "data": "nome", "title": "Nome Cliente" },
  { "data": "data", "title": "Data" },
  { "data": "dataAcerto", "title": "Data de Acerto" },
  { "data": "situacao", "title": "Situação" },
  { "data": "descricaoSituacao", "title": "Desc. Situação" },
  { "data": "status", "title": "Status" },
  { "data": "descricaoStatus", "title": "Desc. Status" },
  { "data": "deposito", "title": "Depósito" },
  { "data": "depositoEnt", "title": "Deposito Entrada" },
  { "data": "codrep", "title": "Vendedor" },
  { "data": "nomeRepresentante", "title": "Nome Vendedor" },
  { "data": "tabelaPreco", "title": "Tabela de Preço" },
  { "data": "valorMinimo", "title": "Valor Mínimo" },
  { "data": "tipo", "title": "Tipo" },
  { "data": "descricaoTipo", "title": "Desc. Tipo" },
  { "data": "dias", "title": "Dias" },
  { "data": "quantidade", "title": "Quantidade" },
  { "data": "valor", "title": "Valor" },
  { "data": "codven", "title": "CodVen" },
  { "data": "dataEmissao", "title": "Data de Emissão" },
  { "data": "quantidadeExp", "title": "Quantidade Expedida" },
  { "data": "quanitdadeFat", "title": "Quantidade Faturada" },
  { "data": "quantidadeDev", "title": "Quantidade Devolvida" },
  { "data": "quantidadeFatDev", "title": "Quantidade FatDev" },
]

const columnsGridItens = [
  { "data": "codigo", "title": "Código" },
  { "data": "descricao", "title": "Descrição" },
  { "data": "cor", "title": "Cor" },
  { "data": "descricaoCor", "title": "Desc. Cor" },
  { "data": "tamanho", "title": "Tamanho" },
  { "data": "quantidade", "title": "Quantidade" },
  { "data": "preco", "title": "Desc. Preço" },
  { "data": "precoTotal", "title": "Preço Total" },
  { "data": "quantidadeExp", "title": "Quantidade Expedida" },
  { "data": "quantidadeFat", "title": "Quantidade Faturada" },
  { "data": "quantidadeDev", "title": "Quantidade Devolvida" },
  { "data": "quantidadeFatDev", "title": "Quantidade FatDev" },
  { "data": "data", "title": "Data" },
  { "data": "dataAcerto", "title": "Data de Acerto" },
  { "data": "situacao", "title": "Situação" },
  { "data": "descricaoSituacao", "title": "Desc. Situação" },
  { "data": "status", "title": "Status" },
  { "data": "descricaoStatus", "title": "Desc. Status" },
  { "data": "tipo", "title": "Tipo" },
  { "data": "descricaoTipo", "title": "Desc. Tipo" },
  { "data": "deposito", "title": "Depósito" },
  { "data": "tabelaPreco", "title": "Tabela de Preço" },
  { "data": "codrep", "title": "Vendedor" },
  { "data": "precoLiquido", "title": "Preço Líquido" },
]

const columnsGridAcerto = [
  { "data": "codigo", "title": "Código" },
  { "data": "descricao", "title": "Descrição" },
  { "data": "cor", "title": "Cor" },
  { "data": "descricaoCor", "title": "Desc. Cor" },
  { "data": "tamanho", "title": "Tamanho" },
  { "data": "preco", "title": "Preço" },
  { "data": "tabelaPreco", "title": "Tabela de Preço" },
  { "data": "quantidade", "title": "Quantidade" },
  { "data": "barra28", "title": "Barra28" },
]

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORDEM_COMPRA");

  addFuncoesBotoes();
  await buscaGridPrincipal();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await buscaGridPrincipal();
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "consignado/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaConsignado').on('click', '#btnEditar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaConsignado').DataTable().row($(this).parents('tr')).data();
      window.location.href = `consignado/${data.id}`;
      // else {
      //   msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      // }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  async function retornaJsonVenda(row) {
    const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;

    const consignado = $('#tabelaConsignado').DataTable().rows($(row).closest('tr')).data()[0];

    const capa = {
      DEBITADUPLICATAS: false,
      VALOR_FRETE: '0',
      VENDACUPOM: false,
      VENDA_TIPO: '2',
      ACRES: '0',
      CODCLI: consignado.codcli,
      CODREP: consignado.codrep,
      CODREP2: '',
      CODVEN: '',
      CONDICAO: [],
      DATA: dtAtual,
      DESCONTO: 0,
      DEVOLUCAO: false,
      DT_ORIG: dtAtual,
      FECHADA: true,
      HR_VENDA: dtAtual,
      LANCAMENTO: '',
      NOME_CONSUMIDOR: consignado.nome,
      NRCAIXA: '001',
      OBSERVACAO: '',
      PRAZO: 0,
      PREVENDA: '',
      REGRA: '',
      STATUS: consignado.status,
      TABELA: consignado.tabelaPreco,
      USUARIO: getCookie('usuario'),
      VALOR_PROMO: 0,
      BASE_DESC: 0,
      VALOR: 0,
      VALOR_BRUTO: 0,
      ITENS: [],
      LISTABARRALOG: [],
      TIPO: 'P',
      CONSIGNADO: consignado.id
    };

    const itens = $('#tabelaItens').DataTable().data().map(item => {
      const { barra, barra28, codigo, cor, descricaoCor, descricao, preco, quantidade, tipo, tamanho, ID, deposito } = item;
      const itemVenda = {
        BASEDESC_REGRAPROMO: 0,
        PERCDESC_REGRAPROMO: 0,
        VALORDESC_REGRAPROMO: 0,
        BARRA: barra || barra28,
        CAIXA: '',
        CODREP: consignado.codrep,
        CODVENDEV: 0,
        CODIGO: codigo,
        CONCATENACAO: `${codigo} - ${cor}${tipo === 'P' ? ` - ${tam}` : ''}`,
        COR: cor,
        DEPOSITO: deposito,
        DESC_COR: descricaoCor,
        DESCONTO: 0,
        DESCRICAO: descricao,
        DT_INCLUSAO: dtAtual,
        ID_ESTOQUE: ID,
        LOTE: '000000',
        ORDEM_PED: 0,
        PEDIDO: 0,
        PERC_DESC: 0,
        PERC_ICMS: 0,
        PRECO_CUSTO: 0,
        PRECO_LIQ: preco,
        PRESENTE: false,
        PROMOCAO: false,
        QUALIDADE: '1',
        QUANTIDADE: quantidade,
        TAM: tamanho,
        TIPO: tipo,
        TOTAL: TruncaDecimaisNova(2, preco * quantidade),
        TOTAL_LIQ: TruncaDecimaisNova(2, preco * quantidade), // aqui deve considerar o desconto quando eu ajustar a rotian
        VALOR: preco,
        VALOR_DESC: 0,
      };

      if (itemVenda.QUANTIDADE > 0) {
        capa.BASE_DESC += itemVenda.TOTAL;
        capa.VALOR += itemVenda.TOTAL;
        capa.VALOR_BRUTO += itemVenda.TOTAL;
        capa.ITENS.push(itemVenda);
      }

      return itemVenda;
    });

    capa.CODVEN = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);;
    return capa;
  }

  $('#tabelaConsignado').on('click', '#btnGerarVenda', async function () {
    try {
      const consignado = await retornaJsonVenda(this);

      await geraVenda(consignado)

    } catch (error) {
      return msgAlerta(error)
    }
  });

  $('#tabelaConsignado').on('click', '#btnGerarNotaFiscal', async function (event) {
    event.preventDefault();

    var data = $('#tabelaConsignado').DataTable().row($(this).parents('tr')).data();

    insereValor('#txtClienteNFE', data.codcli, data.nome)
    $('#txtConsignadoID').val(data.id);

    $('#btnNaturezaNFE').unbind();
    if (data.STATUS == 'DEVOLUCAO/TROCA') {
      $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '2'"] }`);
      $('#btnNaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '2'"]}`, 'Pesquisa Natureza', 'natureza');
    } else {
      $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
      $('#btnNaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
    }

    // if ((data.TIPO_VENDA == 'CONSIGNADO') || (data.FECHADA == 1) || (data.STATUS == 'DEVOLUCAO/TROCA')) {
    // const parametroOperacaoPadrao = await CopiaParametro('VENDA', 47);
    // var sCodCli = data.CLIENTE.substr(0, data.CLIENTE.indexOf('-') - 1);
    // let clienteNfe = data.CLIENTE.split(' - ');
    // $('#txtCodVen').val(data.VENDA);
    // insereValor('#txtClienteNFE', clienteNfe[0], clienteNfe[1]);
    // if (parametroOperacaoPadrao != '') {
    //   $('#txtOperacaoNota').val(parametroOperacaoPadrao);
    //   if (data.STATUS == 'DEVOLUCAO/TROCA') {
    //     $('#txtOperacaoNota').val(await CopiaParametro('VENDA', 53));
    //   }
    // }
    $('#modalNFE').modal('show');
    // } else {
    //   msgAlerta('Venda deve estar fechada para gerar NF-e.');
    //   return;
    // }
    // if (bNaoUsaNRCupom == true) {
    //   data.NRCUPOM = '';
    // }
    // if (bUsaNFCE == 0) {
    //   data.FATURA_NFCE = '';
    // }
    // if (bUsaCFE == 0) {
    //   data.FATURA_CFE = '';
    // }
    // if (bUsaNFE == 0) {
    //   data.FATURA_NFE = '';
    // }
    // if (data.FATURA_NFE != '' || data.FATURA_NFCE != '' || data.FATURA_CFE != '' || data.NRCUPOM != '') {
    //   await msgAlerta('Já existe documento fiscal para essa venda, deseja continuar?', () => { }, () => {
    //     $('#modalNFE').modal('hide')
    //   }, () => { });
    // }
  });

  $('#modalNFE').on('hidden.bs.modal', function () {
    $('#txtOperacaoNota').val('');
  });

  $('#btn_confirmar_nfe').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      const operacao = pegaChave('#txtOperacaoNota');
      let validacao = ''
      if (operacao != '') {
        validacao = $('#txtClienteNFE').val() != ''
      } else {
        validacao = $('#txtNaturezaNFE').val() != '' && $('#txtClienteNFE').val() != ''
      }
      // if (validacao) {
      // await contemNFeNFCe('NFE', $('#txtCodVen').val(), pegaChave('#txtNaturezaNFE'), pegaChave('#txtOperacaoNFE'), rotina);

      // async function rotina() {
      const nota = {};
      nota.ID_CONSIGNADO = $('#txtConsignadoID').val();
      nota.NATUREZA = $('#txtNaturezaNFE').val();
      nota.CLIENTE = $('#txtClienteNFE').val();
      nota.OPERACAO = $('#txtOperacaoNFE').val();

      const jsonNota = JSON.stringify(nota);

      // window.location.href = `<?php echo BASE_URI; ?>/faturamento/${criptografaUrl(jsonNota)}`;

      if (parent && parent.abrirEmNovaAbaIFrame) {
        parent.abrirEmNovaAbaIFrame('Faturamento Geral', `${BASE_URI}/faturamento`, `/${criptografaUrl(jsonNota)}`);
        parent.removerTelaCheia();

        let iframe = parent.document.querySelector('#panel--sisplan_web-consignado iframe');
        let src = iframe.getAttribute("src");
        iframe.setAttribute("src", src);
      } else {
        console.error("A função do pai não está definida ou não pode ser acessada.");
      }
      // }
      // } else {
      //   msgAlerta('Favor preencher os campos para continuar.')
      // }

    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function geraVenda(consignado) {
    try {
      const response = await requisicao('POST', '/sisplan/vendas/v1/venda?', `FECHAF10=${false}&NRSERIE=${getCookie('serie_ecf')}`, `JSON=${encodeURIComponent(JSON.stringify(consignado))}`, 180000);

      if (!response) {
        return false;
      }

      const jsonStrConsig = await response.json();

      if (response.status != 200) {
        toastr.error(jsonStrConsig.mensagem, "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

        return
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          if (parent.verificaTelaAbertaVenda('Loja')) {
            msgAlerta("Tela já aberta, verifique.");
            return;
          }
          // parent.abrirEmNovaAbaIFrame('Venda', `${BASE_URI}/venda/`, consignado.CODVEN);
          parent.abrirEmNovaAbaIFrame('Loja Principal', `${BASE_URI}/loja`);
          $('#btnConsultar').trigger('click')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (error) {
      throw new Error(error.message || 'Não foi possível gravar o consignado');
    }
  }

  $('#tabelaConsignado').on('click', '#btnImprimir', async function () {
    try {
      const data = $('#tabelaConsignado').DataTable().row($(this).parents('tr')).data();
      imprimirItem({ id: data.id })

    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao validar os dados.')
    }
  });

  const imprimirItem = async ({ id }) => {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/impressao/v1/consignado_individual?`;
      const ordem = `&TELA_ORDENACAO=consignado_individual&ORDEM_ORDENACAO=1`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelConsignadoIndividual');
      let arquivo = await GeraRelatorio(`${url}${ordem}&ID=${id}`, 'GET', 1000000, false, 'RelConsignadoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  retornaHintRelatorio('btnImprimir', 'RelConsignadoIndividual')

  $('#tabelaConsignado').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaConsignado').DataTable().row($(this)).data();
      window.location.href = `consignado/${data.id}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  function retornaBotaoOpcoes(data, row) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <div class="dropdown-divider"></div>' +
      // '    <button class="dropdown-item" type="button" title="Conferência" id="btnConferencia">Conferência</button>     ' +
      // '    <button class="dropdown-item" type="button" title="Alterar Status" id="btnAlterarStatus">Alterar Status</button>     ' +
      // '    <div class="dropdown-divider"></div>' +
      `    <button class="dropdown-item" type="button" ${row.situacao != 'P' ? 'disabled' : ''} title="Gerar Venda" id="btnGerarVenda">Gerar Venda</button>     ` +
      '    <button class="dropdown-item" type="button" title="Gerar NFe" id="btnGerarNotaFiscal">Gerar NFe</button>     ' +
      '    <div class="dropdown-divider"></div>' +
      '    <button class="dropdown-item" type="button" title="Imprimir" id="btnImprimir">Imprimir</button>     ' +
      '</div>';
    return retorno;
  };

  function retornaFiltros() {
    const sDtIni = $('#dtIni').val();
    const sDtFim = $('#dtFim').val();
    const sDtAcertoIni = $('#dtAcertoIni').val();
    const sDtAcertoFim = $("#dtAcertoFim").val();
    const sCliente = pegaChave("#txtCliente");
    const sStatus = pegaChave('#txtStatus');
    const sVendedor = pegaChave('#txtVendedor');
    const sRegiao = pegaChave('#txtTabPreco');
    const sId = pegaChave('#txtConsignado');
    const sSituacao = $('input[name="rdListar"]:checked').val();

    const filtros =
      `&DT_INI=${sDtIni}` +
      `&DT_FIM=${sDtFim}` +
      `&DT_ACERTO_INI=${sDtAcertoIni}` +
      `&DT_ACERTO_FIM=${sDtAcertoFim}` +
      `&CLIENTE=${sCliente}` +
      `&STATUS=${sStatus}` +
      `&VENDEDOR=${sVendedor}` +
      `&REGIAO=${sRegiao}` +
      `&ID=${sId}` +
      `&SITUACAO=${sSituacao}`;

    return filtros;
  };

  // function calculaQuantidadeSaida(data) {
  //   // const quantidadeSaida = data.reduce((acc, item) => {
  //   // if (item.situacao === "P" && item.tipo === "S") {
  //   //     return acc + item.quantidade;
  //   //   }
  //   //   return acc;
  //   // }, 0);
  //   // $('#txtQuantidadeSaida').val(quantidadeSaida);
  //   if (data.situacao === "P" && data.tipo === "S") {
  //     $('#txtQuantidadeSaida').val(data.quantidade);
  //   }
  // }

  // function calculaValorSaida(data) {
  //   // const valorSaida = data.reduce((acc, item) => {
  //   //   if (item.situacao === "P" && item.tipo === "S") {
  //   //     return acc + item.valor;
  //   //   }
  //   //   return acc;
  //   // }, 0);
  //   // $('#txtValorSaida').val(valorSaida);
  // }

  // const calculaQuantidadeDevolucao = (data) => {

  // }

  // const calculaValorDevolucao = (data) => {

  // }

  // const calculaQuantidadePendente = (data) => {

  // }

  // const calculaValorPendente = (data) => {

  // }

  // const calculaQuantidadeAcerto = (data) => {

  // }

  // const calculaTotalAcerto = (data) => {

  // }

  // const calculaPercentualAcerto = (data) => {

  // }

  // function calcularTotalizadores() {
  //   const data = $('#tabelaConsignado').DataTable().row($('.selected')).data()
  //   calculaQuantidadeSaida(data)
  //   calculaValorSaida(data)
  //   // calculaQuantidadeDevolucao(item)
  //   // calculaValorDevolucao(item)
  //   // calculaQuantidadePendente(item)
  //   // calculaValorPendente(item)
  //   // calculaQuantidadeAcerto(item)
  //   // calculaTotalAcerto(item)
  //   // calculaPercentualAcerto(item)
  // }

  function calcularValores() {
    const item = $('#tabelaConsignado').DataTable().row($('.selected')).data()
    let edtQtdeSaida = 0;
    let edtVlSaida = 0;
    let edtQtdePendente = 0;
    let edtQtdeDevolucao = 0;
    let edtVlDevolucao = 0;
    let edtTotalAcerto = 0;
    let edtQtdeAcerto = 0;
    let edtPercAcerto = 0;
    let edtValPendente = 0;

    // $.each(data, function (index, item) {
      if (item.situacao === "P") {
        if (item.tipo === "S") {
          edtQtdeSaida += item.quantidade;
          edtVlSaida += item.valor;
          edtQtdePendente += item.quantidade;
        } else if (item.tipo === "D") {
          edtQtdeDevolucao += item.quantidade;
          edtVlDevolucao += item.valor;
          edtQtdePendente -= item.quantidade;
        }
      } else if (item.tipo === "S") {
        edtQtdeSaida += item.quantidade;
        edtVlSaida += item.valor;
        edtTotalAcerto += item.valor;
        edtQtdeAcerto += item.quantidade;
      } else if (item.tipo === "D") {
        edtQtdeDevolucao += item.quantidade;
        edtVlDevolucao += item.valor;
        edtTotalAcerto -= item.valor;
        edtQtdeAcerto -= item.quantidade;
      }
    // });

    // Garantir que o total de acerto não seja negativo
    if (edtTotalAcerto < 0) edtTotalAcerto = 0;

    // Cálculos finais
    edtPercAcerto = (edtTotalAcerto / edtVlSaida) * 100;
    edtValPendente = edtVlSaida - edtVlDevolucao;

    // Atualizando os campos com os valores calculados
    $('#txtQuantidadeSaida').val(edtQtdeSaida);
    $('#txtVlSaida').val(edtVlSaida);
    $('#txtQtdePendente').val(edtQtdePendente);
    $('#txtQtdeDevolucao').val(edtQtdeDevolucao);
    $('#txtVlDevolucao').val(edtVlDevolucao);
    $('#txtTotalAcerto').val(edtTotalAcerto);
    $('#txtQtdeAcerto').val(edtQtdeAcerto);
    $('#txtPercAcerto').val(edtPercAcerto);
    $('#txtValPendente').val(edtValPendente);
  }

  function retornaFiltrosAuxiliares() {
    const tabela = $('#tabelaConsignado').DataTable()

    const tabelaConsignado = tabela.row($('.selected')).data()

    if (!tabelaConsignado) return

    const sDtAcerto = tabelaConsignado?.dataAcerto.split('T')[0];
    const sCliente = tabelaConsignado?.codcli;
    const sId = tabelaConsignado?.id;

    const filtros =
      `&DATA_ACERTO=${sDtAcerto}` +
      `&CLIENTE=${sCliente}` +
      `&ID=${sId}`;

    return filtros;
  };

  async function buscaGridPrincipal() {
    try {
      $.LoadingOverlay("show");
      const params = retornaFiltros()

      const response = await requisicao('GET', '/sisplan/consignado/v1/buscagridprincipal?', params);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      $("#tabelaConsignado").DataTable({
        pageLength: 5,
        order: [],
        sort: true,
        paging: true,
        destroy: true,
        autoWidth: true,
        colReorder: true,
        lengthChange: true,
        lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columns: columnsGridPrincipal,
        data: jsonStr.gridPrincipalConsignado ? jsonStr.gridPrincipalConsignado : [],
        columnDefs: [
          {
            type: 'date-br',
            targets: [3, 4, 21],
            render: function (data) {
              if (data != undefined && data != '') {
                const x = data.slice(0, 10).split('-');
                const hora = data.split(' ')[1];
                if (x[2]) {
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return `${x} ${hora}`;
                }
              } else {
                return '';
              }
            }
          },
          {
            render(data, type, row) {
              return retornaBotaoOpcoes(data, row);
            },
            targets: 0,
          },
        ],
        rowCallback: function (row, data) {
          if (data.tipo === 'D') {
            $(row).css('color', 'red');
          }
        },
      });

      $('#tabelaConsignado').DataTable().columns.adjust().draw();

      setTimeout(async () => { $("#tabelaConsignado tbody tr td")[0].click() }, 50)
      setTimeout(async () => { await buscaGridAuxiliares() }, 250)

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaConsignado tbody").on("click", "tr", async function () {
    $("#tabelaConsignado tbody tr td")[0].click();
    $("#tabelaConsignado tbody tr.selected").removeClass("selected");
    $(this).addClass("selected");

    // calcularTotalizadores()
    calcularValores()
    setTimeout(async () => { await buscaGridAuxiliares() }, 50)
  });

  async function buscaGridAuxiliares() {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaAcerto')) {
      $('#tabelaAcerto').DataTable().destroy();
      $('#tabelaAcerto').empty();
    }
    try {
      const params = retornaFiltrosAuxiliares()
      if (!params) return

      const response = await requisicao('GET', '/sisplan/consignado/v1/buscagridsauxiliares?', params);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }
      const jsonStr = await response.json();

      $("#tabelaItens").DataTable({
        order: [],
        sort: true,
        paging: true,
        destroy: true,
        autoWidth: true,
        colReorder: true,
        lengthChange: false,
        searching: false,
        info: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsGridItens,
        data: jsonStr.gridItens ? jsonStr.gridItens : [],
        columnDefs: [{
          type: 'date-br',
          targets: [12, 13],
          render: function (data) {
            if (data != undefined && data != '') {
              x = data.slice(0, 10).split('-');
              hora = data.split(' ')[1]
              if (x[2]) {
                return `${x[2]}/${x[1]}/${x[0]}`
              } else {
                return `${x} ${hora} `;
              }
            } else {
              return ''
            }
          }
        },
        ],
        rowCallback: function (row, data) {
          if (data.tipo === 'D') {
            $(row).css('color', 'red');
          }
        }
      });

      $("#tabelaAcerto").DataTable({
        order: [],
        sort: true,
        paging: true,
        destroy: true,
        autoWidth: true,
        colReorder: true,
        lengthChange: false,
        searching: false,
        info: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsGridAcerto,
        data: jsonStr.gridAcerto ? jsonStr.gridAcerto : [],
      });

      // $('.dataTables_scrollBody #tabelaItens').addClass('bordinha')
      $('.dataTables_scrollBody #tabelaAcerto').addClass('bordinha')
    } catch (error) {
      console.error(error);
    }
  };

  function addFuncoesBotoes() {
    componenteFiltro('cliente', false, false)
    componenteFiltro('vendedor', false)
    componenteFiltro('status', false)
    componenteFiltro('tabPreco')
    componenteFiltro('consignado', false, false)

    componenteFiltro('cliente', false, false, 'ClienteNFE')
    componenteFiltro('operacao', false, false, 'OperacaoNFE')

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtCliente').val('');
      $('#txtVendedor').val('');
      $('#txtStatus').val('');
      $("#txtTabPreco").val('');
      $("#dtIni").val("1200-01-01");
      $("#dtFim").val("2500-12-01");
      $("#dtAcertoIni").val("1200-01-01");
      $("#dtAcertoFim").val("2500-12-01");
      $("#txtConsignado").val('');
    });
  };

});