/* eslint-disable no-shadow */
$(document).ready(async function () {
  const queryString = window.location.href;
  const parametros = queryString.split("/");
  const base64 = parametros[parametros.length - 1];
  const descriptografado = atob(base64);
  const [codigo, cor, necessidade, kgFiosRolo, kgFiosRoloComAlternativo] = descriptografado.split('###');

  const pesquisa = {
    camposSelect: ['MATERIAL.DESCRICAO', 'MATERIAL.LEADTIME', 'COD_COMPOSTO.DESCRICAO DESC_COMPOSTO', 'CADCOR.DESCRICAO DESC_COR'],
    tabela: 'MATERIAL',
    leftJoin: [{ tabela: 'COD_COMPOSTO', condicao: 'COD_COMPOSTO.CODIGO = MATERIAL.TEXTO_COM' }
      , { tabela: 'CADCOR', condicao: `CADCOR.COR = '${cor}'` }
    ],
    where: [`MATERIAL.CODIGO = '${codigo}'`]
  };

  const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
  // qry.SQL.Add('      ,MATERIAL.DESCRICAO||'' - ''||''ESTOCAGEM - ''||MATERIAL.LEADTIME||'' HORAS (''||CC.DESCRICAO||'')'' DESCRICAO ');
  const descricao = `${jsonStr[0].DESCRICAO} - ESTOCAGEM - ${jsonStr[0].LEADTIME} HORAS (${jsonStr[0].DESC_COMPOSTO})`;
  const descCor = jsonStr[0].DESC_COR;

  const tiposTecel = [{ id: '', descricao: '' }];

  async function retornaTiposTecel() {
    const pesquisa = {
      camposSelect: ['ID_TIPO', 'DESCRICAO'],
      tabela: 'TIPO',
      where: [`AREA = 'TEC'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    for (let i = 0; i < jsonStr.length; i++) {
      const id = jsonStr[i].ID_TIPO;
      const descricao = jsonStr[i].DESCRICAO;
      tiposTecel.push({ id, descricao: `${id} - ${descricao}` });
    }
  }

  await retornaTiposTecel();

  $('#check_todos').on('click', function () {
    $('.cbEtiquetaSel').prop('checked', $(this).prop('checked'));
  });

  async function buscarObsFicha(sCodigo, sCor) {
    try {
      const pesquisa = {
        "tabela": "RAPORT",
        "camposSelect": ["CODIGO", "COR", "MAX(CAST(OBS_TECEL AS VARCHAR(100))) OBS"],
        "where": [`CODIGO= '${sCodigo}' AND COR ='${sCor}'`],
        "groupBy": ["CODIGO", "COR"]
      };
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
      return jsonStr[0].OBS;
    } catch (error) {
      console.error(error);
      return '';
    }

  }

  async function preencheSemana(data) {
    const pesquisa = {
      tabela: 'TABPRZ',
      camposSelect: ['PRAZO', 'DESCRICAO'],
      where: ['LENGTH(PRAZO) = 4']
    };

    if (data == 'atual'){
      pesquisa.where.push('(CURRENT_DATE BETWEEN DT_INICIO AND DT_FIM)');
    } else {
      pesquisa.where.push(`(TO_DATE('${data}', 'YYYY-MM-DD') BETWEEN DT_INICIO AND DT_FIM)`);
    }

    const prazo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if ((!prazo) || (prazo.length == 0)) {
      return;
    };

    insereValor('.input-semana', prazo[0].PRAZO, prazo[0].DESCRICAO);
  }

  function atualizaTotaisRolo() {
    const inputsLength = $('.input-rolos').length;
    let totalRolosMultiplo = 0;
    let totalRolos = 0;
    for (let i = 0; i < inputsLength; i++) {
      const input = $($('.input-rolos')[i]);
      const inputMultiplo = $($('.input-multiplo')[i]);
      const valor = +input.val();
      const multiplo = +inputMultiplo.val();
      if ($($('.cbEtiquetaSel')[i]).prop('checked')) {
        totalRolosMultiplo += valor;
        totalRolos += (valor * multiplo);
      }
    }

    $('#txtEtqTotalRolo').html(totalRolos);
    $('#txtEtqTotalRoloMultiplo').html(totalRolosMultiplo);
    $('#txtEtqTotalRoloSemAlternativo').html(kgFiosRolo);
    $('#txtEtqTotalRoloComAlternativo').html(kgFiosRoloComAlternativo);
  }



  function setCurrentDateTime(hora) {
    const now = new Date();

    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0'); // Janeiro é 0!
    const day = String(now.getDate()).padStart(2, '0');

    const currentDateTime = `${year}-${month}-${day}T${hora}`;

    return currentDateTime;
  }



  const buscaDados = async () => {
    $('#btn-gravar-etiqueta').attr('data-codigo', codigo);
    $('#btn-gravar-etiqueta').attr('data-descricao', descricao);
    $('#btn-gravar-etiqueta').attr('data-cor', cor);
    $('#btn-gravar-etiqueta').attr('data-desc-cor', descCor);

    $('#modal-etiqueta-referencia').html(`${codigo} - ${descricao} - ${cor} - ${descCor}`);
    const url = `/sisplan/disponibilidadetecidos/v1/buscadadosetiqueta?`;
    const dataCodigo = codigo;
    const dataCor = cor;
    const response = await requisicao("GET", url, `&CODIGO=${dataCodigo}&COR=${dataCor}`, '', 1800000);

    if (!response) {
      return;
    }

    const data = await response.json();
    const dados = data.maquinas;

    if (dados.length == 0) {
      msgAlerta('Não é possível realizar a geração de etiqueta para esse tecido, verifique os cadastros.');
      return;
    }

    const obj = {
      "0": 'PARADA',
      "1": 'APÓS',
      "2": 'ATIVA',
      "3": 'TROCA DE REFERÊNCIA',
      "4": 'TRANSFORMAÇÃO',
      "5": 'MANUTENÇÃO',
      "6": 'AMOSTRAGEM'
    };
    const dadosTratados = dados.map(dt => ['', `${dt.tipo}.${dt.subgrupo}.${dt.maquina}`, dt.multiplo, dt.kg_rolo, parseFloat(dt.rolos).toFixed(0), '', '', `${dt.situacao} - ${obj[dt.situacao]}`, dt.obs]);

    $('#tabela-etiqueta-tecelagem').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: false,
      search: false,
      filter: false,
      info: false,
      autoWidth: true,
      data: dadosTratados,
      "columnDefs": [
        {
          targets: [0],
          render(data, type, row) {
            return ` <div class="form-check" style="display: flex;justify-content: center;align-items: center;"> ` +
              ` <input data-maquina="${row[1].split('.')[2]}" class="form-check-input cbEtiquetaSel" type="checkbox" />` +
              ` </div>`;
          }
        },
        {
          targets: [2],
          render(data) {
            return `<input type="number" class="input-default input-multiplo" value="${data}" data-original-value="${data}"></input>`;
          }
        },
        {
          targets: [3],
          render(data) {
            return `<input type="number" class="input-default input-kg-rolo" disabled readonly value="${data}" data-original-value="${data}"></input>`;
          }
        },
        {
          targets: [4],
          render(data) {
            return `<input type="number" class="input-default input-rolos" value="${data}" data-original-value="${data}"></input>`;
          }
        },
        {
          targets: [5],
          render() {
            return `<input type="text" class="input-default input-semana"></input>`;
          }
        },
        {
          targets: [6],
          render() {
            return `<input type="datetime-local" class="input-default input-data-hora"></input>`;
          }
        },
        {
          targets: [8],
          render(data, type, row) {
            const options = tiposTecel.map(tipo => `<option value="${tipo.id}">${tipo.descricao}</option>`);
            return `<select data-maquina="${row[1].split('.')[2]}" class="input-default SelectEtiquetaTipo">` +
              `${options}` +
              `</select>`;
            // return ` <div class="form-check" style="display: flex;justify-content: center;align-items: center;"> ` +
            //   ` <input data-maquina="${row[1].split('.')[2]}" class="form-check-input cbEtiquetaTroca" type="checkbox" />` +
            //   ` </div>`;
          }

        },
        {
          targets: [9],
          render() {
            return `<input type="text" class="input-default input-observacao"></input>`;
          }
        }
      ]
    });

    $('.SelectEtiquetaTipo').off();
    $('.SelectEtiquetaTipo').on('change', function () {
      const index = $(this).closest('tr').index();
      const html = $($(`.SelectEtiquetaTipo:eq(${index}) > option[value="${$(this).val()}"]`)).html();
      const descricao = (html).split('-')[1].trim();
      $(`.input-observacao:eq(${index})`).val(descricao);
    });


    atualizaTotaisRolo();
    $('#txtEtqNecessidade').html(Number(necessidade) < 0 ? Math.abs(Number(necessidade)) : 0);
    const obs = await buscarObsFicha(codigo, cor);
    $('#txtEtqObsFicha').html(obs);


    // $('.input-default-semana').off();
    $('.input-default-semana').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);

    $('.input-semana').off();
    $('.input-semana').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
    $('.input-multiplo').off();
    $('.input-multiplo').on('change', function () {
      const idEncontrado = $(this).closest('tr').index();
      const componenteKGRolo = $(`.input-kg-rolo:eq(${idEncontrado})`);
      const valorKGOriginal = componenteKGRolo.attr('data-original-value');
      componenteKGRolo.val(valorKGOriginal * $(this).val());
      atualizaTotaisRolo();
    });

    $('.input-rolos').off();
    $('.input-rolos').on('change', function () {
      atualizaTotaisRolo();
    });
    $('.input-default-multiplo').val('');
    $('.input-default-rolos').val('');
    $('.input-default-semana').val('');
    $('.input-default-dt-hora').val('');

    await preencheSemana('atual');

    const horaPadrao = await buscaSolucao('TECOT', 'HORA_PADRAO_ETQ') ?? '';
    if (horaPadrao != '') {
      $('.input-data-hora').val(setCurrentDateTime(horaPadrao));
      $('#input-default-dt-hora').val(setCurrentDateTime(horaPadrao));
    }


    $('.input-data-hora').off('input');
    $('.input-data-hora').on('input', async function (){
      await preencheSemana($(this).val().substring(0, 10));
    });


    $('#check_todos').prop('checked', false);

    $('.cbEtiquetaSel').off();
    $('.cbEtiquetaSel').on('change', function () {
      atualizaTotaisRolo();
    });

    function preencheValores(seletor, valor) {
      insereValor(seletor, valor);
      $(seletor).trigger('change');
    }

    $('.btn-aplicar-etiqueta').off();
    $('.btn-aplicar-etiqueta').on('click', function () {
      if ($('.input-default-multiplo').val() != '') {
        preencheValores('.input-multiplo', $('.input-default-multiplo').val());
        // aplica valor aos inputs multiplo
      }
      if ($('.input-default-rolos').val() != '') {
        preencheValores('.input-rolos', $('.input-default-rolos').val());
        // aplica valor aos inputs rolos
      }
      if ($('.input-default-semana').val() != '') {
        preencheValores('.input-semana', $('.input-default-semana').val());
        // aplica valor aos inputs multiplo
      }
      if ($('.input-default-dt-hora').val() != '') {
        preencheValores('.input-data-hora', $('.input-default-dt-hora').val());
        // aplica valor aos inputs multiplo
      }
    });

    $('#btn-gravar-etiqueta').off();
    $('#btn-gravar-etiqueta').on('click', async function () {
      const permissao = await permissaoAcessos("DISPONIBILIDADE_TECIDOS");
      if (permissao.INCLUI == 'N') {
        msgAlerta('Usuário sem permissão para gerar Etiquetas.');
        return;
      }

      const listaMaquinasSelecionadas = $('.cbEtiquetaSel:checked').toArray();
      if (listaMaquinasSelecionadas.length == 0) {
        msgErro('Nenhum registro selecionado, impossível continuar.');
        return;
      }

      const solucaoCliente = await buscaSolucao('TECOT', 'CLIENTE_PADRAO');
      const solucaoMalharia = await buscaSolucao('TECOT', 'MALHARIA_PADRAO');
      const solucaotipoMovimento = await buscaSolucao('TECOT', 'TIPO_MOVIMENTO_PADRAO');
      const solucaoDeposito = await buscaSolucao('TECOT', 'DEPOSITO_PADRAO');
      const solucaoDepositoFio = await buscaSolucao('TECOT', 'DEPOSITO_FIO_PADRAO');



      if (solucaoCliente == '') {
        msgErro('Não há nenhum cliente padrão cadastrado no SOLUCAO, verifique.');
        return;
      }

      if (solucaoMalharia == '') {
        msgErro('Não há nenhuma malharia padrão cadastrada no SOLUCAO, verifique.');
        return;
      }

      if (solucaotipoMovimento == '') {
        msgErro('Não há nenhum Tipo Movimento padrão cadastrada no SOLUCAO, verifique.');
        return;
      }

      if (solucaoDeposito == '') {
        msgErro('Não há nenhum Depósito padrão cadastrada no SOLUCAO, verifique.');
        return;
      }

      if (solucaoDepositoFio == '') {
        msgErro('Não há nenhum Depósito de Fio padrão cadastrada no SOLUCAO, verifique.');
        return;
      }

      const msgPergunta = +$('#txtEtqTotalRolo').html() > +$('#txtEtqNecessidade').html() ? `Total de rolos programados maior que a necessidade, deseja continuar?`
        : `Tem certeza que deseja gerar as ordens selecionadas?`;

      msgAlerta(msgPergunta, async () => {
        const registros = $('.cbEtiquetaSel').toArray();
        const listaTecelagem = [];
        for (let i = 0; i < registros.length; i++) {
          const registro = registros[i];
          if (!$(registro).prop('checked')) {
            // eslint-disable-next-line no-continue
            continue;
          }
          const index = $(registro).closest('tr').index();
          // const dados = $('#tabela-etiqueta-tecelagem').DataTable().row(index).data();
          const rolos = $(`.input-rolos:eq(${index})`).val();
          const kgRolo = $(`.input-kg-rolo:eq(${index})`).val();
          const data = $(`.input-data-hora:eq(${index})`).val();
          const peso = kgRolo * rolos;
          const multiplo = $(`.input-multiplo:eq(${index})`).val();
          const semana = pegaChave(`.input-semana:eq(${index})`);
          const observacao = $(`.input-observacao:eq(${index})`).val();
          const idTipo = $(`.SelectEtiquetaTipo:eq(${index})`).val();

          if (rolos <= 0) {
            msgErro('Campo Rolos inválido, verifique.');
            return;
          }

          if (kgRolo <= 0) {
            msgErro('Campo KG Rolo inválido, verifique.');
            return;
          }

          if (data == '') {
            msgErro('Campo Data/Hora inválido, verifique.');
            return;
          }

          if (multiplo == 0) {
            msgErro('Campo Múltiplo inválido, verifique.');
            return;
          }

          if (semana == '') {
            msgErro('Campo Semana inválido, verifique.');
            return;
          }


          // validar os campos acima...

          const codigo = $(this).attr('data-codigo');
          const cor = $(this).attr('data-cor');

          const tecelagem = {
            numero: '',
            codcli: solucaoCliente,
            material: codigo,
            cor,
            cor_raport: cor,
            dt_emissao: new Date(),
            dt_entrega: data,
            hr_inicio: data,
            multiplo,
            peso_orig: peso,
            qtde: peso,
            qtde_pecas: rolos,
            kgRolo,
            periodo: semana,
            malharia: solucaoMalharia,
            nr_voltas: 1,
            tipo_movimento: solucaotipoMovimento,
            deposito: solucaoDeposito,
            deposito_fio: solucaoDepositoFio,
            maquina: $(registro).attr('data-maquina'),
            obs: observacao,
            id_tipo: idTipo
          };
          listaTecelagem.push(tecelagem);
        }

        const obj = {
          lista: listaTecelagem
        };

        try {
          const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/gravatecelagem?", `JSON=${JSON.stringify(obj)}`, "", 300000);

          if (!response) {
            throw msgAlerta("Não foi possível gravar as informações.");
          }

          if (response.status != 200) {
            throw msgAlerta("Não foi possível gravar as informações.");
          }

          // criaMensagemSucesso("Desdobramento do lote gravado com sucesso", () => { window.location.reload(); });

          criaMensagemSucesso("Ordens geradas com sucesso", async () => {
            window.location.reload();
          });

        } catch (error) {
          console.error(error);
        }
      });
    });

  };

  buscaDados();

});