$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de um pedido.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir os pedidos filtrados.',
          position: 'right'
        }
      },
      {
        element: '#tabelaPedido',
        popover: {
          title: 'Tabela Pedidos',
          description: 'Aqui estão os dados dos pedidos cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let activeColVis = '';

  const filtrarSomentePedidosRepresentanteUsuarioLogado = await CopiaParametro('PEDIDO', 14) == 1
  const objetoFiltroRepresentante = {
    filtrar: false,
    codigoRepresentante: '',
  }
  if (filtrarSomentePedidosRepresentanteUsuarioLogado) {
    codigoRepresentante = retornaRepresentanteUsuario()
    if (codigoRepresentante) {
      objetoFiltroRepresentante.filtrar = true
      objetoFiltroRepresentante.codigoRepresentante = codigoRepresentante
    }
  }

  var ultimaColunaOrdenada = {
    nome: '',
    ordenacao: 'ASC'
  };

  const permissaoUsuarioLogado = await permissaoAcessos("PEDIDO");
  const paramVen54 = await CopiaParametro('VENDA', 54);
  await VinculaCaixaComUsuario();
  await setarDataAnoAnterior('txtDataEmiDe');
  await carregaValoresPadroes();
  let sEmpID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
    : [getCookie('emp_id')];

  addFuncoesBotoes();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.pedido == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pedido: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.pedidoItens == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pedidoItens: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.pedidoNotas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pedidoNotas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    let tabela = ''

    if (activeColVis == 'buttonColVisCapa') {
      tabela = '#tabelaPedido'
    }
    if (activeColVis == 'buttonColVisItens') {
      tabela = '#tabelaPedidoVisualizacao'
    }
    if (activeColVis == 'buttonColVisNotas') {
      tabela = '#tabelaPedidoNotasVisualizacao'
    }
    $(tabela).DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text().trim(),
        'data': this.dataSrc()
      })
    });

    if (activeColVis == 'buttonColVisCapa') {
      adicionaColunas(cols, colunasInvisiveis.pedido ?? [], ['Pedido'])
    }
    if (activeColVis == 'buttonColVisItens') {
      adicionaColunas(cols, colunasInvisiveis.pedidoItens ?? [], [])

    }
    if (activeColVis == 'buttonColVisNotas') {
      adicionaColunas(cols, colunasInvisiveis.pedidoNotas ?? [], [])
    }
  })

  preencheOrdenacaoTela('RelPedidoA', 'txtOrdem');
  await buscaDados();

  if (pegaValor('#txtCaixa') == '') {
    $("#txtCaixa").val(sessionStorage.getItem('g_caixa_logado'));
  }

  $('#txtValor').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  async function retornaRepUsuario() {
    const filtraClientesRepresentante = await CopiaParametro('SISTEMA', 2) == 1;

    if (!filtraClientesRepresentante) {
      return '';
    }


    const usuarioMasterSupervisor = await uMasterOuSupervisor()

    if (usuarioMasterSupervisor) {
      return ''
    }

    const repUsuario = retornaRepresentanteUsuario()

    return `'${repUsuario}'`
  }


  const repUsuario = await retornaRepUsuario();
  if (repUsuario != '') {
    $('#RepresentanteConsulta').addClass('d-none')
  }

  async function buscaDados(colunaOrdenacao = '') {

    const representanteUsuario = await retornaRepUsuario()
    ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
    ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

    $('#modal-filtros').modal('hide');

    const orderBy = colunaOrdenacao == '' ? '[]' : `["${colunaOrdenacao}"]`;
    try {
      $.LoadingOverlay("show");
      let where = '';
      where = $('#txtPedidoConsulta').val() != '' ? ` AND PEDIDO.NUMERO IN (${await formataListas($('#txtPedidoConsulta').val().toString())})` : '';
      where += $('#txtClienteConsulta').val() != '' ? ` AND PEDIDO.CODCLI IN (${await formataListas($('#txtClienteConsulta').val().toString())})` : '';
      where += $('#txtStatusConsulta').val() != '' ? ` AND PEDIDO.STATUS IN (${await formataListas($('#txtStatusConsulta').val().toString())})` : '';
      if (representanteUsuario === '') {
        where += $('#txtRepresentanteConsulta').val() != '' ? ` AND PEDIDO.CODREP IN (${await formataListas($('#txtRepresentanteConsulta').val().toString())})` : '';
      } else {
        where += representanteUsuario != '' ? ` AND PEDIDO.CODREP = ${representanteUsuario}` : '';
      }

      where += pegaChave('#txtTabPrecoConsulta') != '' ? ` AND PEDIDO.TAB_PRE = '${pegaChave('#txtTabPrecoConsulta')}'` : '';
      where += pegaChave('#txtColecaoConsulta') != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecaoConsulta')}'` : '';
      where += pegaChave('#txtGrupoPedConsulta') != '' ? ` AND PEDIDO.GRUPO = '${pegaChave('#txtGrupoPedConsulta')}'` : '';
      where += pegaChave('#txtGrupoProdConsulta') != '' ? ` AND PRODUTO.GRUPO = '${pegaChave('#txtGrupoProdConsulta')}'` : '';
      where += pegaChave('#txtTipoProdConsulta') != '' ? ` AND PRODUTO.TIPO = '${pegaChave('#txtTipoProdConsulta')}'` : '';
      where += pegaChave('#txtUFConsulta') != '' ? ` AND CIDADE.COD_UF = '${pegaChave('#txtUFConsulta')}'` : '';
      where += pegaChave('#txtBloqComConsulta') != '' ? ` AND PEDIDO.BLOQUEIO = '${pegaChave('#txtBloqComConsulta')}'` : '';
      where += pegaChave('#txtBloqFinConsulta') != '' ? ` AND PEDIDO.FINANCEIRO = '${pegaChave('#txtBloqFinConsulta')}'` : '';
      where += pegaChave('#txtResponsavelConsulta') != '' ? ` AND PEDIDO.RESPONSAVEL = '${pegaChave('#txtResponsavelConsulta')}'` : '';
      where += pegaChave('#txtSituacaoConsulta') == 'P' ? ` AND PED_ITEN.QTDE > 0` :
        pegaChave('#txtSituacaoConsulta') == 'F' ? ` AND PED_ITEN.QTDE_F > 0` : ``;
      where += ` AND PEDIDO.EMP_ID IN (${sEmpID})`

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and PEDIDO.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }
      if ($("#txtDataEntregaDe").val() != "01-01-1200" || $$("#txtDataEntregaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.ENTREGA >= '${$("#txtDataEntregaDe").val()}' and PEDIDO.ENTREGA <= '${$("#txtDataEntregaAte").val()}'`;
      }
      if ($("#txtDataFaturaDe").val() != "01-01-1200" || $$("#txtDataFaturaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}' and PEDIDO.DT_FATURA <= '${$("#txtDataFaturaAte").val()}'`;
      }
      if ($("#txtDataSaidaDe").val() != "01-01-1200" || $$("#txtDataSaidaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_SAIDA >= '${$("#txtDataSaidaDe").val()}' and PEDIDO.DT_SAIDA <= '${$("#txtDataSaidaAte").val()}'`;
      }

      if (objetoFiltroRepresentante.filtrar) where += ` AND PEDIDO.CODREP = '${objetoFiltroRepresentante.codigoRepresentante}'`

      const tipoBanco = await retornaDatabase()
      // where += `AND PED_ITEN.QTDE + PED_ITEN.QTDE_F + PED_ITEN.QTDE_CANC > 0`

      const colunasInvisiveis = JSON.parse(
        localStorage.getItem("colunasInvisiveisRelatorios")
      );

      $("#tabelaPedido").DataTable({
        destroy: true,
        lengthChange: true,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{ "tabela":"PEDIDO", "camposSelect":["PEDIDO.NUMERO Pedido", ` +
              ` "ENTIDADE.NOME Cliente", ` +
              ` "CASE WHEN PEDIDO.FINANCEIRO = '0' THEN 'BLOQUEADO' ELSE 'LIBERADO' END Financeiro", ` +
              ` "CASE WHEN PEDIDO.BLOQUEIO = '0' THEN 'BLOQUEADO' ELSE 'LIBERADO' END Comercial", ` +
              ` "REPRESEN.NOME Representante", ` +
              ` "TABTRAN.NOME Transportadora",` +
              ` "((SUM(CAST(PED_ITEN.PRECO AS NUMERIC(10,2))*(PED_ITEN.QTDE[MAIS]PED_ITEN.QTDE_F))-CAST(CAST((SUM(CAST(PED_ITEN.PRECO AS NUMERIC(10,2))*(PED_ITEN.QTDE[MAIS]PED_ITEN.QTDE_F))*CAST(PEDIDO.PER_DESC AS NUMERIC(10,2))) AS NUMERIC(10,2))/100 AS NUMERIC(10,2))) - coalesce(PEDIDO.VAL_DESC_EMPENHO, 0)) Valor_Liq",` +
              ` "PEDIDO.DT_EMISSAO Data_Emissao", ` +
              ` "PEDIDO.ENTREGA Data_Entrega", ` +
              ` "PEDIDO.PED_CLI Ped_Cliente", ` +
              ` "${tipoBanco == 'FIREBIRD' || tipoBanco == 'ORACLE' ? `PEDIDO.STATUS || ' - ' ||SITPROD.DESCRICAO` : `CONCAT(PEDIDO.STATUS, ' - ', SITPROD.DESCRICAO)`} Status"], ` +
              ` "leftjoin": [{"tabela" : "ENTIDADE", "condicao" : "PEDIDO.CODCLI = ENTIDADE.CODCLI"},` +
              ` {"tabela" : "PED_ITEN", "condicao" : "PED_ITEN.NUMERO = PEDIDO.NUMERO"},` +
              ` {"tabela" : "PRODUTO", "condicao"  : "PRODUTO.CODIGO = PED_ITEN.CODIGO"},` +
              ` {"tabela" : "REPRESEN", "condicao" : "PEDIDO.CODREP = REPRESEN.CODREP" },` +
              ` {"tabela" : "CADCEP", "condicao" : "CADCEP.CEP = PEDIDO.CLI_CEP" },` +
              ` {"tabela" : "CIDADE", "condicao" : "CIDADE.CODIGO = CADCEP.CODMUN" },` +
              ` {"tabela" : "SITPROD", "condicao" : "SITPROD.CODIGO = PEDIDO.STATUS" },` +
              ` {"tabela" : "TABTRAN", "condicao"  : "PEDIDO.TAB_TRANS = TABTRAN.CODIGO"}], ` +
              ` "where": ["1=1 ${where}"], ` +
              ` "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "PEDIDO.FINANCEIRO", "PEDIDO.BLOQUEIO", "REPRESEN.NOME", "TABTRAN.NOME", "PEDIDO.PER_DESC", "PEDIDO.DT_EMISSAO", "PEDIDO.ENTREGA", "PEDIDO.PED_CLI", "PEDIDO.VAL_DESC_EMPENHO", "PEDIDO.STATUS", "SITPROD.DESCRICAO"], ` +
              ` "orderby": ["PEDIDO.NUMERO DESC"], ` +
              ` "CamposWhereServerSide": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "REPRESEN.NOME", "TABTRAN.NOME", "PEDIDO.PED_CLI", "PEDIDO.STATUS", "SITPROD.DESCRICAO"]}`,
            CLIENTE: "S",
          },
        },

        columnDefs: [
          {
            render(row) {
              return retornaBotaoOpcoes(row);
            },
            targets: [0],
          },
          {
            targets: [6],
            visible: false
          }
        ],
        createdRow: function (row, data, dataIndex) {
          if (colunasInvisiveis.pedido.indexOf("2") == -1) {
            var Financeiro = data[2];
            if (Financeiro === "LIBERADO") {
              $('td', row).eq(2).css('color', 'green');
            } else if (Financeiro === "BLOQUEADO") {
              $('td', row).eq(2).css('color', 'red');
            }
            $('td', row).eq(2).css('font-weight', 'bold');
          }
          if (colunasInvisiveis.pedido.indexOf("3") == -1) {
            var Comercial = data[3];
            if (Comercial === "LIBERADO") {
              $('td', row).eq(3).css('color', 'green');
            } else if (Comercial === "BLOQUEADO") {
              $('td', row).eq(3).css('color', 'red');
            }
            $('td', row).eq(3).css('font-weight', 'bold');
          }
        }
      });

      $('#tabelaPedido_length').prepend('<button class="buttonColVis" id="buttonColVisCapa"><i class="fas fa-cogs"></i></button>');
      $('#tabelaPedido_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVisCapa').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVisCapa').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          activeColVis = 'buttonColVisCapa'
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });

      $("#btnConfirmarColunas").off();
      $("#btnConfirmarColunas").on("click", async function () {
        try {
          $.LoadingOverlay("show");
          let tabela = ''

          const novasColunas = retornaNovasColunasInvisiveis();
          if (activeColVis == 'buttonColVisCapa') {
            tabela = '#tabelaPedido'
            localStorage.setItem(
              "colunasInvisiveisRelatorios",
              JSON.stringify({
                ...colunas,
                pedido: novasColunas,
              })
            );
          }
          if (activeColVis == 'buttonColVisItens') {
            tabela = '#tabelaPedidoVisualizacao'
            localStorage.setItem(
              "colunasInvisiveisRelatorios",
              JSON.stringify({
                ...colunas,
                pedidoItens: novasColunas,
              })
            );
          }
          if (activeColVis == 'buttonColVisNotas') {
            tabela = '#tabelaPedidoNotasVisualizacao'
            localStorage.setItem(
              "colunasInvisiveisRelatorios",
              JSON.stringify({
                ...colunas,
                pedidoNotas: novasColunas,
              })
            );
          }

          $(tabela).DataTable().columns().visible(true);

          $(tabela)
            .DataTable()
            .columns()
            .every(function () {
              const colAtual = String(this.dataSrc());
              if (novasColunas.indexOf(colAtual) != -1) {
                this.visible(false);
              }
            });

        } finally {
          $.LoadingOverlay("hide");
          $("#modal-ColunasVisiveis").modal("hide");
        }
      });

      $("#tabelaPedido")
        .DataTable()
        .columns()
        .every(function () {
          const colAtual = String(this.dataSrc());
          if (colunasInvisiveis.pedido.indexOf(colAtual) != -1) {
            this.visible(false);
          }
        });

      $('#buttonExcel').off()
      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaPedido").DataTable().data().toArray();
        const dadosFormatados = dados.map((item) => ({
          'PEDIDO': item[0].toString(),
          'CLIENTE': item[1].toString(),
          'FINANCEIRO': item[2].toString(),
          'COMERCIAL': item[3].toString(),
          'REPRESENTANTE': item[4].toString(),
          'TRANSPORTADORA': item[5].toString(),
          'DATA_EMISSAO': item[7].toString(),
          'DATA_ENTREGA': item[8].toString(),
          'PED_CLIENTE': item[9].toString(),
          'SITUACAO': item[10].toString(),
        }))
        await exportaCSV("", "", undefined, null, 'Relatório de Pedido', '', '', 999, false, false, dadosFormatados);
      })

      $.LoadingOverlay("hide");
      $('#tabelaPedido th').unbind('click');
      $('#tabelaPedido th').on('click', async function () {
        const nomeColuna = $(this).html();
        const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
        const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
        await buscaDados(nomeColuna + ' ' + ordenacao);
      });

      await criaGraficosCabecalho();
      $($('#tabelaPedido tr')[1]).addClass('selected')
      await retornaInformacoesPedido($('#tabelaPedido').DataTable().row($($('#tabelaPedido tr')[1])).data())
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  };

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "pedido/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaPedido').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      if (await validaEdicao(data[0])) {
        window.location.href = `pedido/${btoa(data[0])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaPedido').on('click', '#btn-imprimirItem', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/acesso_pedido?`;

      const filtros = `&NUMERO=${data[0]}&INDIVIDUAL=S`;
      const ordem = `&TELA_ORDENACAO=RelPedidoAIndividual`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoAIndividual');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 1000000, false, 'RelPedidoAIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaPedido').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaPedido').DataTable().row($(this)).data();
      if (await validaEdicao(data[0])) {
        window.location.href = `pedido/${btoa(data[0])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaPedido').on('click', '#btnAntecipacao', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();

      const pesquisaParam = {
        tabela: 'PEDIDO',
        camposSelect: ['PEDIDO.CODCLI', 'PEDIDO.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'PEDIDO.CODREP', 'REPRESEN.NOME NOME_REPRESEN',
          'PEDIDO.NUMERO', 'ENTIDADE.NOME', `(SELECT SUM(QTDE * PRECO) FROM [PED_ITEN] WHERE NUMERO = '${data[0]}') VALOR_TOTAL`],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
          { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = PEDIDO.CLASSE_GER' },
          { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = PEDIDO.CODREP' },
        ],
        where: [`PEDIDO.NUMERO = '${data[0]}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      $('#txtDTvencimento').val('');
      insereValor('#txtPedidoAnte', jsonStr[0].NUMERO);
      insereValor('#txtClienteAnte', jsonStr[0].CODCLI, jsonStr[0].NOME);
      insereValor('#txtRepresenAnte', jsonStr[0].CODREP, jsonStr[0].NOME_REPRESEN);
      insereValor('#txtClasseGer', jsonStr[0].CLASSE_GER, jsonStr[0].DESC_CLASSE);
      insereValor('#txtValor', ArredondarValor(jsonStr[0].VALOR_TOTAL, 2));
      setarDataAtual('txtDTemissao');
      $('#txtDTemissao').prop('disabled', true);
      $('#txtDTemissao').prop('readonly', true);

      await carregaValoresPadroesAnte()
    } finally {
      $.LoadingOverlay('hide');
      $('#modalAntecipacao').modal('show');
    }
  });

  $('#txtDTvencimento').on('blur', function () {
    const dtVencto = $('#txtDTvencimento').val();
    const dtEmissao = $('#txtDTemissao').val();

    if (dtVencto == '') {
      return;
    }

    if (new Date(dtVencto) < new Date(dtEmissao)) {
      msgAlerta('Data de vencimento menor que a data de emissão, favor verificar.');
      $('#txtDTvencimento').val('');
      return;
    }
  });

  $('#txtMoeda').on('blur', async function () {
    const moeda = pegaChave('#txtMoeda');

    if (moeda == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'MOEDA',
      camposSelect: ['MOEDA.HISTORICO', 'HISTCP.DESCRICAO', 'MOEDA.TIPO', "MOEDA_CONTA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA", "CADCONTA.BANCO", "CADBAN.NOME_BANCO"],
      leftJoin: [{ tabela: 'HISTCP', condicao: 'MOEDA.HISTORICO = HISTCP.HISTORICO' },
      { tabela: "MOEDA_CONTA", condicao: `MOEDA.CODMOE = MOEDA_CONTA.MOEDA AND MOEDA_CONTA.EMPRESA = '${getCookie("empresa").substring(1)}'` },
      { tabela: "CADCONTA", condicao: "MOEDA_CONTA.CONTA = CADCONTA.CONTA" },
      { tabela: "CADBAN", condicao: "CADCONTA.BANCO = CADBAN.BANCO" }],
      where: [`MOEDA.CODMOE = '${moeda}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    $('#cartao').addClass('d-none');
    $('#cbNaoLancaCc').prop('checked', false);
    $('#labelNaoLancaCc').addClass('d-none');
    $('#cbNaoLancaCc').addClass('d-none');
    if (jsonStr[0].TIPO == '3') {
      $('#labelNaoLancaCc').removeClass('d-none');
      $('#cbNaoLancaCc').removeClass('d-none');
      $('#cartao').removeClass('d-none');
      await addBandeira();
    }

    insereValor('#txtHistorico', jsonStr[0].HISTORICO, jsonStr[0].DESCRICAO);

    if (jsonStr[0].CONTA != "") {
      insereValor("#txtConta", jsonStr[0].CONTA, jsonStr[0].DESC_CONTA);
      bloqueiaCampoConta(true);
    } else {
      $("#txtConta").val("");
      bloqueiaCampoConta(false);
    }

    if (jsonStr[0].BANCO != "") {
      insereValor("#txtBanco", jsonStr[0].BANCO, jsonStr[0].NOME_BANCO);
      bloqueiaCampoBanco(true);
    } else {
      $("#txtBanco").val("");
      bloqueiaCampoBanco(false);
    }

  });

  $('#txtConta').on('blur', async function () {
    if (pegaValor('#txtConta') == '') {
      return;
    }

    const conta = pegaChave('#txtConta');

    const pesquisaParam = {
      tabela: 'CADCONTA',
      camposSelect: ['CADCONTA.BANCO', 'CADBAN.NOME_BANCO'],
      leftJoin: [{ tabela: 'CADBAN', condicao: 'CADCONTA.BANCO = CADBAN.BANCO' },],
      where: [`CADCONTA.CONTA = '${conta}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    insereValor('#txtBanco', jsonStr[0].BANCO, jsonStr[0].NOME_BANCO);
  });

  $('#tabelaPedido').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaPedido").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $('#btnImprimir').on('click', async function () {
    msgAlerta('Tem certeza que deseja imprimir os pedidos listados?', () => { imprimirPedidos(); })
  });

  async function imprimirPedidos() {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/acesso_pedido?`;

        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=acesso_pedido&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnConfirmarAnte').on('click', async function gravaReceber() {
    if ((pegaValor('#txtMoeda') == '') || (pegaValor('#txtHistorico') == '') || (pegaValor('#txtClasseGer') == '') || (pegaValor('#txtSituacao') == '') || (pegaValor('#txtConta') == '') ||
      (pegaValor('#txtBanco') == '') || (pegaValor('#txtDTemissao') == '') || (pegaValor('#txtDTvencimento') == '') || (pegaValor('#txtCaixa') == '') || (pegaValor('#txtValor') == '')) {
      msgAlerta('Necessário preencher todos os campos para gravar a antecipação, favor verificar.')
      return;
    }

    if (!$('#cartao').hasClass('d-none') && ((pegaValor('#txtNSU') == '') || (pegaValor('#txtCondicaoDePagamento') == ''))) {
      msgAlerta('Necessário preencher todos os campos para gravar a antecipação, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const receberClass = {
        VALOR: parseFloat(pegaValor('#txtValor')),
        VALOR2: parseFloat(pegaValor('#txtValor')),
        DT_EMISSAO: `${$('#txtDTemissao').val()}T00:00:00Z`,
        DT_VENCTO: `${$('#txtDTvencimento').val()}T00:00:00Z`,
        STATUS: 'ANTE',
        OBS: `Antecipação do pedido ${pegaValor('#txtPedidoAnte')}.`,
        CODREP: pegaChave('#txtRepresenAnte'),
        CODCLI: pegaChave('#txtClienteAnte'),
        SITUACAO: pegaChave('#txtSituacao'),
        CLASSE: pegaChave('#txtClasseGer'),
        BANCO: pegaChave('#txtBanco'),
        NRCAIXA: pegaChave('#txtCaixa'),
        MOEDA: pegaChave('#txtMoeda'),
        HISTORICO: pegaChave('#txtHistorico'),
        CONTA_CH: pegaChave('#txtConta'),
        CONTA_CHEQUE: pegaChave('#txtConta'),
        PEDIDO: pegaValor('#txtPedidoAnte'),
        GERACAIXALOJA: false, //necessário fazer a negação, pois foi alterado o backend dia 06/03/23 pendencia 239227, para não duplicar o caixa quando for lançamento de cheque que gere antecipação
        NAO_LANCA_CC: isChecked('#cbNaoLancaCc')
      };

      let response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      const lancamento = jsonStr.lancamento;
      const numero = jsonStr.numero;
      if (pegaValor('#txtStatus') != '') {
        await alteraStatus(pegaChave('#txtStatus'), receberClass.PEDIDO);
      }

      const tipo = await buscaValor('MOEDA', 'TIPO', 'CODMOE', pegaChave('#txtMoeda'));

      if (tipo.TIPO == '3') {
        let sCodCli = await retornaOperadora(pegaChave('#txtMoeda'));
        let novoPrazo = new Date();
        let arrayVencimentos;
        if (pegaChave('#txtCondicaoDePagamento') != '') {
          arrayVencimentos = await RetornaVencimentos(pegaChave('#txtCondicaoDePagamento'));
        }
        if (typeof arrayVencimentos == "undefined") {
          arrayVencimentos = [];
          arrayVencimentos.push(formataData(novoPrazo));
        }
        const valorTotal = parseFloat($('#txtValor').val());
        const nr_parcelas = pegaChave('#txtNrParcelas');
        const moeda = await buscaValor('MOEDA', 'BANCO, BAIXA, HISTORICO, CODSIT', 'CODMOE', pegaChave('#txtMoeda'));
        const conta = await RetornaConta(pegaChave('#txtMoeda'));

        let valorParcela = parseFloat(parseFloat(valorTotal / nr_parcelas).toFixed(2));
        let guardaValor = valorParcela;
        let diferenca = 0;
        if (valorTotal > valorParcela * nr_parcelas || valorTotal < valorParcela * nr_parcelas) {
          diferenca = parseFloat(parseFloat(valorTotal - valorParcela * nr_parcelas).toFixed(2));
        }

        for (let i = 0; i < nr_parcelas; i++) {
          if (diferenca > 0 && i == 0) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
            diferenca = 0;
          } else {
            valorParcela = guardaValor;
          }
          if (diferenca < 0 && i == nr_parcelas - 1) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
          }
          const receberClass = {
            VALOR: valorParcela,
            VALOR2: valorParcela,
            DT_EMISSAO: formataData(novoPrazo),
            DT_VENCTO: arrayVencimentos[i],
            STATUS: 'DUPL',
            OBS: `Duplicata gerada pela antecipação ${numero} paga com cartão`,
            CODREP: pegaChave('#txtRepresenAnte'),
            CODCLI: sCodCli,
            SITUACAO: pegaChave('#txtSituacao'),
            CLASSE: pegaChave('#txtClasseGer'),
            BANCO: moeda.BANCO,
            NRCAIXA: pegaChave('#txtCaixa'),
            MOEDA: pegaChave('#txtMoeda'),
            CONTA_CH: conta,
            CARTAO_NSU: $('#txtNSU').val(),
            BANDEIRA: $('#select_bandeira').val(),
            LANCAMENTO: lancamento,
            PARCELA: i + 1,
            TAXACARTAO: true,
            CONDICAO: pegaChave('#txtCondicaoDePagamento'),
            QTDEPARCELAS: pegaChave('#txtNrParcelas'),
            HISTORICO: moeda.HISTORICO,
            SITUACAO: moeda.CODSIT
          };

          response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();

          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          const numeroB = jsonStr.numero;
          const taxaBandeira = jsonStr.taxa_bandeira;

          if (moeda.BAIXA == '1') {
            const receberBClass = await pegaValoresBaixa(numeroB, taxaBandeira, valorParcela, sCodCli);

            response = await requisicao('POST', '/Sisplan/receber/V1/BaixaReceber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberBClass[0]))}`);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (response.status != 200) {
              msgErro(jsonStr.RESULT[0].mensagem);
              return;
            }
          }
        }
      }

      criaMensagemSucesso('Antecipação gravada com sucesso.', () => { window.location.reload() });
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function alteraStatus(pStatus, pPedido) {
    try {
      const response = await requisicao('GET', '/sisplan/pedido/v1/alterastatus?', `PEDIDO=${pPedido}&STATUS=${pStatus}`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
    } catch (error) {
      console.error(error);
    }
  }

  async function retornaDadosItens(sNumero) {
    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: [
        'PED_ITEN.CODIGO',
        `CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
        'PED_ITEN.COR',
        'CADCOR.DESCRICAO DESC_COR',
        'PED_ITEN.TAM',
        'PED_ITEN.QTDE',
        'PED_ITEN.QTDE_F',
        'PED_ITEN.QTDE_CANC',
        'PED_ITEN.PRECO',
        'PED_ITEN.PRECO_ORIG',
        'PED_ITEN.TIPO',
        'PED_ITEN.ORDEM',
        'PED_ITEN.LOTE',
        'PED_ITEN.DEPOSITO',
        'PED_ITEN.OBSERVACAO'
      ],
      leftJoin: [
        { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'CADCOR', condicao: 'CADCOR.COR = PED_ITEN.COR' }
      ],
      where: [`PED_ITEN.NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  };

  async function carregaDadosPedidosFaturados() {
    $.LoadingOverlay('show');
    try {
      let where = '';
      const representanteUsuario = await retornaRepUsuario()

      where = $('#txtPedidoConsulta').val() != '' ? ` AND PEDIDO.NUMERO IN (${await formataListas($('#txtPedidoConsulta').val().toString())})` : '';
      where += $('#txtClienteConsulta').val() != '' ? ` AND PEDIDO.CODCLI IN (${await formataListas($('#txtClienteConsulta').val().toString())})` : '';
      where += $('#txtStatusConsulta').val() != '' ? ` AND PEDIDO.STATUS IN (${await formataListas($('#txtStatusConsulta').val().toString())})` : '';
      if (representanteUsuario === '') {
        where += $('#txtRepresentanteConsulta').val() != '' ? ` AND PEDIDO.CODREP IN (${await formataListas($('#txtRepresentanteConsulta').val().toString())})` : '';
      } else {
        where += representanteUsuario != '' ? ` AND PEDIDO.CODREP = ${representanteUsuario}` : '';
      }

      where += pegaChave('#txtTabPrecoConsulta') != '' ? ` AND PEDIDO.TAB_PRE = '${pegaChave('#txtTabPrecoConsulta')}'` : '';
      where += pegaChave('#txtColecaoConsulta') != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecaoConsulta')}'` : '';
      where += pegaChave('#txtGrupoPedConsulta') != '' ? ` AND PEDIDO.GRUPO = '${pegaChave('#txtGrupoPedConsulta')}'` : '';
      where += pegaChave('#txtGrupoProdConsulta') != '' ? ` AND PRODUTO.GRUPO = '${pegaChave('#txtGrupoProdConsulta')}'` : '';
      where += pegaChave('#txtTipoProdConsulta') != '' ? ` AND PRODUTO.TIPO = '${pegaChave('#txtTipoProdConsulta')}'` : '';
      where += pegaChave('#txtUFConsulta') != '' ? ` AND CIDADE.COD_UF = '${pegaChave('#txtUFConsulta')}'` : '';
      where += pegaChave('#txtBloqComConsulta') != '' ? ` AND PEDIDO.BLOQUEIO = '${pegaChave('#txtBloqComConsulta')}'` : '';
      where += pegaChave('#txtBloqFinConsulta') != '' ? ` AND PEDIDO.FINANCEIRO = '${pegaChave('#txtBloqFinConsulta')}'` : '';
      where += pegaChave('#txtResponsavelConsulta') != '' ? ` AND PEDIDO.RESPONSAVEL = '${pegaChave('#txtResponsavelConsulta')}'` : '';
      where += pegaChave('#txtSituacaoConsulta') == 'P' ? ` AND PED_ITEN.QTDE > 0` :
        pegaChave('#txtSituacaoConsulta') == 'F' ? ` AND PED_ITEN.QTDE_F > 0` : ``;
      where += ` AND PEDIDO.EMP_ID IN (${sEmpID})`

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and PEDIDO.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }
      if ($("#txtDataEntregaDe").val() != "01-01-1200" || $$("#txtDataEntregaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.ENTREGA >= '${$("#txtDataEntregaDe").val()}' and PEDIDO.ENTREGA <= '${$("#txtDataEntregaAte").val()}'`;
      }
      if ($("#txtDataFaturaDe").val() != "01-01-1200" || $$("#txtDataFaturaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}' and PEDIDO.DT_FATURA <= '${$("#txtDataFaturaAte").val()}'`;
      }
      if ($("#txtDataSaidaDe").val() != "01-01-1200" || $$("#txtDataSaidaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_SAIDA >= '${$("#txtDataSaidaDe").val()}' and PEDIDO.DT_SAIDA <= '${$("#txtDataSaidaAte").val()}'`;
      }

      if (objetoFiltroRepresentante.filtrar) where += ` AND PEDIDO.CODREP = '${objetoFiltroRepresentante.codigoRepresentante}'`

      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO',
          'NOTA.EMP_ID',
          'NOTAITEN.FATURA',
          'PEDIDO.DT_FATURA',
          'PEDIDO.CODCLI',
          'ENTIDADE.NOME',
          'SUM(CAST(PED_ITEN.QTDE_F AS NUMERIC(10,2)) * CAST(PED_ITEN.PRECO AS numeric(10,2))) VALOR_FATURADO',
          `CASE WHEN NATUREZA.TIPO = 'V' THEN 'VENDA' ELSE 'DEVOLUÇÃO' END TIPO`,
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
          { tabela: 'NOTAITEN', condicao: 'NOTAITEN.PEDIDO = PED_ITEN.NUMERO AND NOTAITEN.CODIGO = PED_ITEN.CODIGO AND NOTAITEN.COR = PED_ITEN.COR AND NOTAITEN.TAMANHO = PED_ITEN.TAM' },
          { tabela: 'NOTA', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' },
          { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = NOTA.NATUREZA' },
          { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
        ],
        where: [`1=1 ${where} AND PED_ITEN.QTDE_F > 0`],
        groupBy: [
          "PEDIDO.NUMERO",
          "NOTA.EMP_ID",
          "NOTAITEN.FATURA",
          "PEDIDO.DT_FATURA",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "NATUREZA.TIPO",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return [];
      }

      return jsonStr;
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosPedidosPendentes() {
    $.LoadingOverlay('show');
    try {
      let where = '';
      const representanteUsuario = await retornaRepUsuario()

      where = $('#txtPedidoConsulta').val() != '' ? ` AND PEDIDO.NUMERO IN (${await formataListas($('#txtPedidoConsulta').val().toString())})` : '';
      where += $('#txtClienteConsulta').val() != '' ? ` AND PEDIDO.CODCLI IN (${await formataListas($('#txtClienteConsulta').val().toString())})` : '';
      where += $('#txtStatusConsulta').val() != '' ? ` AND PEDIDO.STATUS IN (${await formataListas($('#txtStatusConsulta').val().toString())})` : '';
      if (representanteUsuario === '') {
        where += $('#txtRepresentanteConsulta').val() != '' ? ` AND PEDIDO.CODREP IN (${await formataListas($('#txtRepresentanteConsulta').val().toString())})` : '';
      } else {
        where += representanteUsuario != '' ? ` AND PEDIDO.CODREP = ${representanteUsuario}` : '';
      }

      where += pegaChave('#txtTabPrecoConsulta') != '' ? ` AND PEDIDO.TAB_PRE = '${pegaChave('#txtTabPrecoConsulta')}'` : '';
      where += pegaChave('#txtColecaoConsulta') != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecaoConsulta')}'` : '';
      where += pegaChave('#txtGrupoPedConsulta') != '' ? ` AND PEDIDO.GRUPO = '${pegaChave('#txtGrupoPedConsulta')}'` : '';
      where += pegaChave('#txtGrupoProdConsulta') != '' ? ` AND PRODUTO.GRUPO = '${pegaChave('#txtGrupoProdConsulta')}'` : '';
      where += pegaChave('#txtTipoProdConsulta') != '' ? ` AND PRODUTO.TIPO = '${pegaChave('#txtTipoProdConsulta')}'` : '';
      where += pegaChave('#txtUFConsulta') != '' ? ` AND CIDADE.COD_UF = '${pegaChave('#txtUFConsulta')}'` : '';
      where += pegaChave('#txtBloqComConsulta') != '' ? ` AND PEDIDO.BLOQUEIO = '${pegaChave('#txtBloqComConsulta')}'` : '';
      where += pegaChave('#txtBloqFinConsulta') != '' ? ` AND PEDIDO.FINANCEIRO = '${pegaChave('#txtBloqFinConsulta')}'` : '';
      where += pegaChave('#txtResponsavelConsulta') != '' ? ` AND PEDIDO.RESPONSAVEL = '${pegaChave('#txtResponsavelConsulta')}'` : '';
      where += pegaChave('#txtSituacaoConsulta') == 'P' ? ` AND PED_ITEN.QTDE > 0` :
        pegaChave('#txtSituacaoConsulta') == 'F' ? ` AND PED_ITEN.QTDE_F > 0` : ``;
      where += ` AND PEDIDO.EMP_ID IN (${sEmpID})`

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and PEDIDO.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }
      if ($("#txtDataEntregaDe").val() != "01-01-1200" || $$("#txtDataEntregaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.ENTREGA >= '${$("#txtDataEntregaDe").val()}' and PEDIDO.ENTREGA <= '${$("#txtDataEntregaAte").val()}'`;
      }
      if ($("#txtDataFaturaDe").val() != "01-01-1200" || $$("#txtDataFaturaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}' and PEDIDO.DT_FATURA <= '${$("#txtDataFaturaAte").val()}'`;
      }
      if ($("#txtDataSaidaDe").val() != "01-01-1200" || $$("#txtDataSaidaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_SAIDA >= '${$("#txtDataSaidaDe").val()}' and PEDIDO.DT_SAIDA <= '${$("#txtDataSaidaAte").val()}'`;
      }

      if (objetoFiltroRepresentante.filtrar) where += ` AND PEDIDO.CODREP = '${objetoFiltroRepresentante.codigoRepresentante}'`

      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO',
          'PEDIDO.CODCLI',
          'ENTIDADE.NOME',
          'SITPROD.DESCRICAO STATUS',
          'TIPO.ID_TIPO',
          'TIPO.DESCRICAO TIPO_VENDA',
          'PEDIDO.DT_EMISSAO',
          'PEDIDO.DT_FATURA',
          'PEDIDO.ENTREGA',
          'SUM(CAST(PED_ITEN.QTDE AS NUMERIC(10,2)) * CAST(PED_ITEN.PRECO AS numeric(10,2))) VALOR_PENDENTE'
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
          { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
          { tabela: 'SITPROD', condicao: 'SITPROD.CODIGO = PEDIDO.STATUS' },
          { tabela: 'TIPO', condicao: 'TIPO.ID_TIPO = PEDIDO.ID_TIPO' },
        ],
        where: [`1=1 ${where} AND PED_ITEN.QTDE > 0`],
        groupBy: [
          "PEDIDO.NUMERO",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "SITPROD.DESCRICAO",
          "TIPO.ID_TIPO",
          "TIPO.DESCRICAO",
          "PEDIDO.DT_EMISSAO",
          "PEDIDO.DT_FATURA",
          "PEDIDO.ENTREGA",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return [];
      }

      return jsonStr;
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function criaGraficosCabecalho() {
    const dadosPendentes = await carregaDadosPedidosPendentes();
    const dadosFaturados = await carregaDadosPedidosFaturados();

    Graficos.criarGrafico({
      container: 'graficosPedidos',
      tipo: 'pie',
      dados: dadosPendentes,
      nomeSerie: 'Valor Pendente',
      colunasAgrupamento: ['NOME'],
      colunasValor: ['VALOR_PENDENTE'],
      title: 'Pedidos Pendentes'
    })
    Graficos.criarGrafico({
      container: 'graficosPedidos1',
      tipo: 'pie',
      dados: dadosFaturados,
      nomeSerie: 'Valor Faturado',
      colunasAgrupamento: ['NOME'],
      colunasValor: ['VALOR_FATURADO'],
      title: 'Pedidos Faturados'
    })

  }

  async function retornaInformacoesPedido(pedido) {
    try {
      $.LoadingOverlay('show');
      const numero = pedido[0];
      const itens = await retornaDadosItens(numero);
      const notas = await buscaNotasFiscais(numero);
      const dataSetCols = []
      const dataSetColsNotas = []

      if ($.fn.DataTable.isDataTable('#tabelaPedidoNotasVisualizacao')) {
        $('#tabelaPedidoNotasVisualizacao').DataTable().destroy();
        $('#tabelaPedidoNotasVisualizacao').empty();
      };
      if ($.fn.DataTable.isDataTable('#tabelaPedidoVisualizacao')) {
        $('#tabelaPedidoVisualizacao').DataTable().destroy();
        $('#tabelaPedidoVisualizacao').empty();
      };

      if (itens.length > 0) {
        var keys = Object.keys(itens[0]);
        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
          });
        }


        const colunasInvisiveis = JSON.parse(
          localStorage.getItem("colunasInvisiveisRelatorios")
        );
        criaDataTablePadrao('#tabelaPedidoVisualizacao', true, false, false, false, true, true, false, itens, dataSetCols, [], [], [], [], {}, '', 'buttonColVisItens', 'buttonExcel2');
        $('#tabelaPedidoVisualizacao').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.pedidoItens).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )
      }

      if (notas.length > 0) {
        var keys = Object.keys(notas[0]);
        for (var k in keys) {
          dataSetColsNotas.push({
            'title': keys[k],
            'data': keys[k]
          });
        }

        const colunasInvisiveis = JSON.parse(
          localStorage.getItem("colunasInvisiveisRelatorios")
        );
        criaDataTablePadrao('#tabelaPedidoNotasVisualizacao', true, false, false, false, true, true, false, notas, dataSetColsNotas, [], [], [], [], {}, '', 'buttonColVisNotas', 'buttonExcel3');
        $('#tabelaPedidoNotasVisualizacao').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.pedidoNotas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )
      }

      $('#buttonExcel2').on('click', async function () {
        await exportaCSV('', '', true, null, 'Relatório dos Itens do Pedido', undefined, '', 999, false, false, itens);
      })
      $('#buttonExcel3').on('click', async function () {
        await exportaCSV('', '', true, null, 'Relatório das Notas do Pedido', undefined, '', 999, false, false, notas);
      })


      $('#buttonColVisItens').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          activeColVis = 'buttonColVisItens'
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });

      $('#buttonColVisNotas').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          activeColVis = 'buttonColVisNotas'
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#tabelaPedido').on('click', 'tr', async function () {
    const data = $('#tabelaPedido').DataTable().row($(this)).data();

    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected');
    } else {
      $('#tabelaPedido').DataTable().$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
    }

    await retornaInformacoesPedido(data)
  });

  async function retornaFiltros(sNumero = '') {
    const numero = await formataListas($('#txtPedidoConsulta').val().toString());
    const codcli = await formataListas($('#txtClienteConsulta').val().toString());
    const codrep = objetoFiltroRepresentante.filtrar ? objetoFiltroRepresentante.codigoRepresentante : await formataListas($('#txtRepresentanteConsulta').val().toString());
    const status = await formataListas($('#txtStatusConsulta').val().toString());
    const tab_pre = pegaChave('#txtTabPrecoConsulta');
    const colecao = pegaChave('#txtColecaoConsulta');
    const grupo_ped = pegaChave('#txtGrupoPedConsulta');
    const grupo_prod = pegaChave('#txtGrupoProdConsulta');
    const tipo = pegaChave('#txtTipoProdConsulta');
    const bloqueio = pegaChave('#txtBloqComConsulta');
    const financeiro = pegaChave('#txtBloqFinConsulta');
    const emissaoDe = $("#txtDataEmiDe").val();
    const emissaoAte = $("#txtDataEmiAte").val();
    const entregaDe = $("#txtDataEntregaDe").val();
    const entregaAte = $("#txtDataEntregaAte").val();
    const faturaDe = $("#txtDataFaturaDe").val();
    const faturaAte = $("#txtDataFaturaAte").val();
    const saidaDe = $("#txtDataSaidaDe").val();
    const saidaAte = $("#txtDataSaidaAte").val();
    const situacao = pegaChave('#txtSituacaoConsulta');
    const uf = pegaChave('#txtUFConsulta');
    const responsavel = pegaChave('#txtResponsavelConsulta');

    const filtros = `NUMERO=${sNumero == '' ? numero : sNumero}` +
      `&CODCLI=${codcli}` +
      `&CODREP=${codrep}` +
      `&TAB_PRE=${tab_pre}` +
      `&COLECAO=${colecao}` +
      `&PEDIDOGRUPO=${grupo_ped}` +
      `&PRODUTOGRUPO=${grupo_prod}` +
      `&TIPO=${tipo}` +
      `&BLOQUEIO=${bloqueio}` +
      `&FINANCEIRO=${financeiro}` +
      `&EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&ENTREGADE=${entregaDe}` +
      `&ENTREGAATE=${entregaAte}` +
      `&FATURADE=${faturaDe}` +
      `&FATURAATE=${faturaAte}` +
      `&SAIDADE=${saidaDe}` +
      `&SAIDAATE=${saidaAte}` +
      `&STATUS=${status}` +
      `&EMP_ID=${sEmpID}` +
      `&SITUACAO=${situacao}` +
      `&UF=${uf}` +
      `&RESPONSAVEL=${responsavel}`;

    return filtros;
  };


  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = data.data();
        const response = await requisicao('DELETE', '/sisplan/pedido/v1/pedido?', `NUMERO=${encodeURIComponent(valorLinha[0])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function VinculaCaixaComUsuario() {
    const _url = '/sisplan/funcoes/v1/pesquisa?';
    const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
    const _usuarioCaixa =
      `JSON={"tabela": "VENDA_CAIXA", 
      "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO", "VENDA_CAIXA.DEPOSITO", "DEPOSITO.DESCRICAO AS DESC_DEPOSITO", "VENDA_CAIXA.REGIAO", "REGIAO.DESCRICAO AS DESC_REGIAO"], 
      "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'"],
      "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}],
      "leftjoin": [{"tabela" : "DEPOSITO", "condicao" : "DEPOSITO.CODIGO = VENDA_CAIXA.DEPOSITO"},
                   {"tabela" : "REGIAO", "condicao" : "REGIAO.REGIAO = VENDA_CAIXA.REGIAO"}]}`;
    try {
      const response = await requisicao('GET', _url, _usuarioCaixa, null);
      if (!response) {
        msgErro('Erro ao buscar caixas vinculados ao usuário.');
        return;
      }

      if (response.status == 200) {
        var jsonStr = await response.json();
        if (jsonStr['RESULT'][0].length >= 1) {

          if (paramVen54 == '2') { //consultar apenas os caixas vinculados ao usuário
            $('#btn-caixa').pesquisa(
              '#txtCaixa',
              'CODIGO',
              'DESCRICAO',
              `/sisplan/funcoes/v1/pesquisa?JSON={ 
                "tabela":"caixa_loja", 
                "camposSelect":[ "caixa_loja.codigo", "caixa_loja.descricao"], 
                "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}],
                "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
              }`,
              'Pesquisa Caixa',
              'caixa_loja'
            );

            $('#txtCaixa').autocompleta(
              2,
              `JSON={ 
                "tabela":"caixa_loja", 
                "camposSelect":[ "caixa_loja.codigo CHAVE", "caixa_loja.descricao"],
                "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}], 
                "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
              }`
            );
          } else if (paramVen54 == '0') {
            insereValor('#txtCaixa', jsonStr['RESULT'][0][0].NRCAIXA, jsonStr['RESULT'][0][0].DESCRICAO);
            $('#txtCaixa').prop('disabled', true);
            $('#btn-caixa').prop('disabled', true);
            $('#btn-limpa-caixa2').prop('disabled', true);
          }

        }
      } else {
        return;
      }
    } catch (error) {
      console.error(error);
      return;
    }
  }

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('PEDIDO')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'STATUS_ANTECIPACAO': {
          insereValor('#txtStatus', item.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
      }
    });
  };

  function addFuncoesBotoes() {
    componenteFiltro('pedido', true, false, 'PedidoConsulta', [`EMP_ID IN (${sEmpID}) ${objetoFiltroRepresentante.filtrar ? ` AND CODREP = '${objetoFiltroRepresentante.codigoRepresentante}'` : ''} `])
    componenteFiltro('cliente', true, false, 'ClienteConsulta')
    componenteFiltro('representante', true, false, 'RepresentanteConsulta', objetoFiltroRepresentante.filtrar ? `["REPRESEN.CODREP = '${objetoFiltroRepresentante.codigoRepresentante}'"]` : 'null')
    componenteFiltro('status', true, false, 'StatusConsulta')

    $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
    $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
    $('#btn-limpa-condicao').on('click', function () {
      $('#txtCondicaoDePagamento').val('');
      $('#txtNrParcelas').val('1');
    });

    $("#txtTabPrecoConsulta").autocompleta(2, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO.REGIAO CHAVE, REGIAO.DESCRICAO"]}`);
    $("#btn-TabPrecoConsulta").pesquisa_serverside(["#txtTabPrecoConsulta"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ]}`, "Pesquisa Tabela de Preço");
    $('#btn-limpa-TabPrecoConsulta').on('click', function () { $('#txtTabPrecoConsulta').val(''); });

    $("#txtColecaoConsulta").autocompleta(2, `JSON={ "tabela":"COLECAO", "camposSelect":["COLECAO.CODIGO CHAVE, COLECAO.DESCRICAO"]}`);
    $("#btn-ColecaoConsulta").pesquisa_serverside(["#txtColecaoConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Coleção");
    $('#btn-limpa-ColecaoConsulta').on('click', function () { $('#txtColecaoConsulta').val(''); });

    $("#txtGrupoPedConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PED", "camposSelect":["GRUPO_PED.CODIGO CHAVE, GRUPO_PED.DESCRICAO"]}`);
    $("#btn-GrupoPedConsulta").pesquisa_serverside(["#txtGrupoPedConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Pedido");
    $('#btn-limpa-GrupoPedConsulta').on('click', function () { $('#txtGrupoPedConsulta').val(''); });

    $("#txtGrupoProdConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["GRUPO_PA.CODIGO CHAVE, GRUPO_PA.DESCRICAO"]}`);
    $("#btn-GrupoProdConsulta").pesquisa_serverside(["#txtGrupoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Produto");
    $('#btn-limpa-GrupoProdConsulta').on('click', function () { $('#txtGrupoProdConsulta').val(''); });

    $("#txtTipoProdConsulta").autocompleta(2, `JSON={ "tabela":"CAD_TIPO_PROD", "camposSelect":["CAD_TIPO_PROD.CODIGO CHAVE, CAD_TIPO_PROD.DESCRICAO"]}`);
    $("#btn-TipoProdConsulta").pesquisa_serverside(["#txtTipoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CAD_TIPO_PROD", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Tipo Produto");
    $('#btn-limpa-TipoProdConsulta').on('click', function () { $('#txtTipoProdConsulta').val(''); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Moeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btn-limpa-Moeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-Historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-ClasseGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-ClasseGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-Situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-Banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-Banco").on("click", function () { $("#txtBanco").val(""); });

    $("#txtConta").autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Conta").pesquisa("#txtConta", "CONTA", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}', "Pesquisa Conta", "cadconta");
    $("#btn-limpa-Conta").on("click", function () { $("#txtConta").val(""); });

    // $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    // $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    // $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val('') });

    $('#txtStatusConsulta').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-StatusConsulta').pesquisa('#txtStatusConsulta', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-StatusConsulta').on('click', function () { $('#txtStatusConsulta').val('') });

    $("#txtUFConsulta").autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":["TABUF.CODIGO CHAVE, TABUF.DESCRICAO"]}`);
    $("#btn-UFConsulta").pesquisa_serverside(["#txtUFConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa UF", 'TABUF');
    $('#btn-limpa-UFConsulta').on('click', function () { $('#txtUFConsulta').val(''); });

    $("#txtResponsavelConsulta").autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"]}`);
    $("#btn-ResponsavelConsulta").pesquisa_serverside(["#txtResponsavelConsulta"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ]}`, "Pesquisa Responsável", 'ENTIDADE');
    $('#btn-limpa-ResponsavelConsulta').on('click', function () { $('#txtResponsavelConsulta').val(''); });

    //MODAL DUPLICAR
    $("#txtClienteDestino").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"]}`);
    $("#btnClienteDestino").pesquisa_serverside(["#txtClienteDestino"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "FANTASIA" ]}`, "Pesquisa Cliente");
    $('#btnLimpaClienteDestino').on('click', function () { $('#txtClienteDestino').val(''); });

    $('#txtStatusDestino').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnStatusDestino').pesquisa('#txtStatusDestino', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btnLimpaStatusDestino').on('click', function () { $('#txtStatusDestino').val('') });

    if (paramVen54 != '2') {
      $('#btn-caixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
      $('#txtCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
    }
    $("#btn-limpa-caixa2").on("click", function () { $("#txtCaixa").val(""); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtClienteConsulta').empty().trigger('change');
      $('#txtClienteConsulta').val('');
      $('#txtClienteConsulta').attr('data-chave', '');
      $('#txtClienteConsulta').attr('data-desc', '');

      $('#txtPedidoConsulta').empty().trigger('change');
      $('#txtPedidoConsulta').val('');
      $('#txtPedidoConsulta').attr('data-chave', '');
      $('#txtPedidoConsulta').attr('data-desc', '');

      $('#txtRepresentanteConsulta').empty().trigger('change');
      $('#txtRepresentanteConsulta').val('');
      $('#txtRepresentanteConsulta').attr('data-chave', '');
      $('#txtRepresentanteConsulta').attr('data-desc', '');

      $('#txtStatusConsulta').empty().trigger('change');
      $('#txtStatusConsulta').val('');
      $('#txtStatusConsulta').attr('data-chave', '');
      $('#txtStatusConsulta').attr('data-desc', '');

      $('#txtTabPrecoConsulta').val('');
      $('#txtColecaoConsulta').val('');
      $('#txtGrupoPedConsulta').val('');
      $('#txtGrupoProdConsulta').val('');
      $('#txtTipoProdConsulta').val('');
      $('#txtUFConsulta').val('');
      $("#txtDataEmiDe").val("1200-01-01");
      $("#txtDataEntregaDe").val("1200-01-01");
      $("#txtDataFaturaDe").val("1200-01-01");
      $("#txtDataSaidaDe").val("1200-01-01");
      $("#txtDataEmiAte").val("2500-12-01");
      $("#txtDataEntregaAte").val("2500-12-01");
      $("#txtDataFaturaAte").val("2500-12-01");
      $("#txtDataSaidaAte").val("2500-12-01");
      $('#txtBloqFinConsulta').val('');
      $('#txtBloqComConsulta').val('');
      $('#txtSituacaoConsulta').val('');
      $('#txtResponsavelConsulta').val('');
    });

    $('#txtSituacao').on('focusout', async function () {
      const contaCor = await buscaValor('TABSIT', 'GERA_CONTACOR', 'CODIGO', pegaChave(this));
      $('#cbNaoLancaCc').prop('checked', contaCor.GERA_CONTACOR == 'S');
    });
  };

  $("#tabelaPedido").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[0], data[1], 'PEDIDO');
  });

  function retornaBotaoOpcoes(pedido) {
    var retorno = '<div style="text-align:center;"> ' +
      '   <div class="dropdown" style="position: initial"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + pedido + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button id="btn-editar" type="button" class="dropdown-item">Alterar</button>' +
      `    <button id="btn-imprimirItem" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelPedidoAIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>` +
      '    <button id="btn-excluir" type="button" class="dropdown-item">Excluir</button>' +
      '    <button id="btnAnexos" type="button" class="dropdown-item">Gestão Documentos</button>' +
      '    <button id="btnAntecipacao" type="button" class="dropdown-item">Antecipação</button>' +
      '    <button id="btnDuplicar" type="button" class="dropdown-item">Duplicar</button>' +
      '    <button id="btnSituacao" type="button" class="dropdown-item">Situação</button>' +
      '    <button id="btnVisualizaNotas" type="button" class="dropdown-item">Visualizar Notas Fiscais</button>';
    retorno += '</div>' +
      '  </div>' +
      '</div>';
    return retorno;
  }

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#modal-empresas').on('hide.bs.modal', function () {
    sEmpID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

    componenteFiltro('pedido', true, false, 'PedidoConsulta', [`EMP_ID IN (${sEmpID}) ${objetoFiltroRepresentante.filtrar ? ` AND CODREP = '${objetoFiltroRepresentante.codigoRepresentante}'` : ''} `])
  });

  async function addBandeira() {
    $("#select_bandeira").empty();
    const dados = await RetornaBandeiras();
    for (const bandeira of dados) {
      const optionText = bandeira.DESCRICAO;
      const optionValue = bandeira.DESCRICAO;
      $('#select_bandeira').append(`<option value="${optionValue}">
                                                 ${optionText}
                                              </option>`);

    }
  }

  async function retornaOperadora(moeda) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    let retorno = pegaChave('#txtClienteAnte');
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"MOEDA", "camposSelect":[ "USA_ADM_CARTAO", "CODCLI"], "where": ["CODMOE = ${moeda}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ((jsonStr.RESULT[0][0].CODCLI != '') && (jsonStr.RESULT[0][0].USA_ADM_CARTAO = 'S')) {
        retorno = jsonStr.RESULT[0][0].CODCLI;
      }
      return retorno;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function RetornaVencimentos(iCodCondicao) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let arrVencimentos = [];
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${iCodCondicao}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let nrParcelas = jsonStr.RESULT[0].length;
      let dataAtual = new Date();
      for (let index = 0; index < nrParcelas; index++) {
        let novoPrazo = new Date();
        let nrDia = jsonStr.RESULT[0][index].PRAZO;
        novoPrazo.setDate(dataAtual.getDate() + nrDia);
        arrVencimentos.push(formataData(novoPrazo));
      }
      if (typeof arrVencimentos == "undefined") {
        let novoPrazo = new Date();
        arrVencimentos.push(formataData(novoPrazo));
      }

      return arrVencimentos;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function RetornaConta(moeda) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"MOEDA_CONTA", "camposSelect":[ "CONTA"], "where": ["MOEDA = ${moeda} AND EMPRESA = ${getCookie('empresa').substring(1, 4)}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return jsonStr.RESULT[0][0].CONTA;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function RetornaBandeiras() {
    const _url = `/Sisplan/Funcoes/v1/pesquisa?`;
    const _params = `JSON={ "tabela":"bandeira", "camposSelect":["id_bandeira", "descricao"], "where": ["ativo = 'S'"], "orderby": ["ordem","descricao"]}`;

    try {
      const response = await requisicao('GET', _url, _params, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem)
        return;
      }
      return jsonStr['RESULT'][0];
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar as bandeiras de cartões');
    }
  }

  async function pegaValoresBaixa(numeroB, taxaBandeira, valorParcela, sCodCli) {
    try {
      let valores = [];
      let objeto = {};

      objeto = {
        VALOR_PAGO: valorParcela - parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
        DESCONTO: 0,
        JUROS: 0,
        CODCLI: sCodCli,
        CODREP: pegaChave('#txtRepresenAnte'),
        DT_EMISSAO: new Date().toISOString().slice(0, 10),
        DT_VENCTO: new Date().toISOString().slice(0, 10),
        EMP_ID: getCookie('emp_id'),
        DESP_COBRANCA: parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
        NUMERO: numeroB,
        VALOR: valorParcela,
        VALOR2: valorParcela,
        DT_PAGTO: new Date().toISOString().slice(0, 10),
        DT_CONT: new Date().toISOString().slice(0, 10),
        MOEDA: pegaChave("#txtMoeda"),
        NSU: $("#txtNSU").val(),
        BANDEIRA: $('#select_bandeira').val()
      };

      valores.push(objeto);
      objeto = {};

      return valores;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os dados da baixa");
    }
  }

  $('#btnConsultar').on('click', async function () {
    await buscaDados();
  });

  async function validaEdicao(numero) {
    const _url = `/Sisplan/Funcoes/v1/pesquisa?`;
    const _params = `JSON={ "tabela":"NOTA", "camposSelect":["NOTA.TIPFAT"], 
                            "leftJoin":  [{"tabela" : "NOTAITEN", "condicao" : "NOTAITEN.FATURA = NOTA.FATURA AND NOTAITEN.SERIE = NOTA.SERIE"}],
                            "where": ["NOTAITEN.PEDIDO = '${numero}'"] 
                          }`;

    try {
      const response = await requisicao('GET', _url, _params, null);

      if (!response) {
        return true;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem)
        return;
      }
      if ((jsonStr['RESULT'][0].length > 0) && (jsonStr['RESULT'][0][0].TIPFAT == 'P')) {
        msgAlerta('Pedido com quantidade faturada, impossível continuar.');
        return false;
      }
      return true;
    } catch (error) {
      console.error(error);
    }
  }

  function bloqueiaCampoConta(bloqueia = true) {
    $("#txtConta").prop("disabled", bloqueia);
    $("#btn-Conta").prop("disabled", bloqueia);
    $("#btn-limpa-Conta").prop("disabled", bloqueia);
  }

  function bloqueiaCampoBanco(bloqueia = true) {
    $("#txtBanco").prop("disabled", bloqueia);
    $("#btn-Banco").prop("disabled", bloqueia);
    $("#btn-limpa-Banco").prop("disabled", bloqueia);
  }

  $('#tabelaPedido').on('click', '#btnDuplicar', async function () {
    let data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
    $('#modalDuplicarPedido').modal('show');
    $('#txtPedidoOrigem').val(data[0])
    $('#txtPedidoDestino').val(await RetornaProximo('PEDIDO', 'PEDIDO', 'NUMERO', 0))
  });

  $('.configCheck').on('change', function (e) {
    if (e.target.id === 'cbDuplicarSomenteItensPendentes') {
      if ($('#cbDuplicarSomenteItensPendentes').is(':checked')) {
        $('#cbColocarFaturadoComoPendente').attr('disabled', true)
        $('#cbNaoDuplicarItensCancelados').attr('disabled', true)
        $('#cbColocarCanceladoComoPendente').attr('disabled', true)
        $('#cbDuplicarSomenteItensFaturados').attr('disabled', true)
        $('#cbDuplicarQuantidadeOriginalPedido').attr('disabled', true)

        $('#cbColocarFaturadoComoPendente').prop('checked', false)
        $('#cbNaoDuplicarItensCancelados').prop('checked', false)
        $('#cbColocarCanceladoComoPendente').prop('checked', false)
        $('#cbDuplicarSomenteItensFaturados').prop('checked', false)
        $('#cbDuplicarQuantidadeOriginalPedido').prop('checked', false)
      } else {
        $('#cbColocarFaturadoComoPendente').attr('disabled', false)
        $('#cbNaoDuplicarItensCancelados').attr('disabled', false)
        $('#cbColocarCanceladoComoPendente').attr('disabled', false)
        $('#cbDuplicarSomenteItensFaturados').attr('disabled', false)
        $('#cbDuplicarQuantidadeOriginalPedido').attr('disabled', false)
      }
    }

    if (e.target.id === 'cbDuplicarSomenteItensFaturados') {
      if ($('#cbDuplicarSomenteItensFaturados').is(':checked')) {
        $('#cbColocarFaturadoComoPendente').attr('disabled', true)
        $('#cbDuplicarSomenteItensPendentes').attr('disabled', true)
        $('#cbNaoDuplicarItensCancelados').attr('disabled', true)
        $('#cbColocarCanceladoComoPendente').attr('disabled', true)
        $('#cbDuplicarQuantidadeOriginalPedido').attr('disabled', true)

        $('#cbColocarFaturadoComoPendente').prop('checked', false)
        $('#cbDuplicarSomenteItensPendentes').prop('checked', false)
        $('#cbNaoDuplicarItensCancelados').prop('checked', false)
        $('#cbColocarCanceladoComoPendente').prop('checked', false)
        $('#cbDuplicarQuantidadeOriginalPedido').prop('checked', false)
      } else {
        $('#cbColocarFaturadoComoPendente').attr('disabled', false)
        $('#cbNaoDuplicarItensCancelados').attr('disabled', false)
        $('#cbDuplicarSomenteItensPendentes').attr('disabled', false)
        $('#cbColocarCanceladoComoPendente').attr('disabled', false)
        $('#cbDuplicarQuantidadeOriginalPedido').attr('disabled', false)
      }
    }

    if (e.target.id === 'cbDuplicarQuantidadeOriginalPedido') {
      if ($('#cbDuplicarQuantidadeOriginalPedido').is(':checked')) {
        $('#cbColocarFaturadoComoPendente').attr('disabled', true)
        $('#cbDuplicarSomenteItensPendentes').attr('disabled', true)
        $('#cbNaoDuplicarItensCancelados').attr('disabled', true)
        $('#cbColocarCanceladoComoPendente').attr('disabled', true)
        $('#cbDuplicarSomenteItensFaturados').attr('disabled', true)

        $('#cbColocarFaturadoComoPendente').prop('checked', false)
        $('#cbDuplicarSomenteItensPendentes').prop('checked', false)
        $('#cbNaoDuplicarItensCancelados').prop('checked', false)
        $('#cbColocarCanceladoComoPendente').prop('checked', false)
        $('#cbDuplicarSomenteItensFaturados').prop('checked', false)
      } else {
        $('#cbColocarFaturadoComoPendente').attr('disabled', false)
        $('#cbNaoDuplicarItensCancelados').attr('disabled', false)
        $('#cbDuplicarSomenteItensPendentes').attr('disabled', false)
        $('#cbColocarCanceladoComoPendente').attr('disabled', false)
        $('#cbDuplicarSomenteItensFaturados').attr('disabled', false)
      }
    }
  })

  $('#btnDuplicarPedido').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      if (!$('#txtPedidoDestino').val()) {
        throw msgAlerta('Código não informado, impossível continuar!');
      }
      if (!$('#txtClienteDestino').val()) {
        throw msgAlerta('Cliente não informado, impossível continuar!');
      }
      const body = {
        colocaFaturadoComoPendente: $('#cbColocarFaturadoComoPendente').is(':checked') ? 'S' : 'N',
        naoDuplicarItensCancelados: $('#cbNaoDuplicarItensCancelados').is(':checked') ? 'S' : 'N',
        colocarCanceladoComoPendente: $('#cbColocarCanceladoComoPendente').is(':checked') ? 'S' : 'N',
        duplicarSomenteItensPendentes: $('#cbDuplicarSomenteItensPendentes').is(':checked') ? 'S' : 'N',
        manterIndoAdProdDosItens: $('#bdManterIndoAdProdDosItens').is(':checked') ? 'S' : 'N',
        duplicarSomenteItensFaturados: $('#cbDuplicarSomenteItensFaturados').is(':checked') ? 'S' : 'N',
        duplicarQuantidadeOriginalPedido: $('#cbDuplicarQuantidadeOriginalPedido').is(':checked') ? 'S' : 'N',
        ignorarProdutosSemSaldo: $('#cbIgnorarProdutosSemSaldo').is(':checked') ? 'S' : 'N'
      }

      const response = await requisicao('PUT',
        `/sisplan/pedido/v1/duplicapedido?`,
        `PEDIDO_ORIGEM=${$('#txtPedidoOrigem').val()}&PEDIDO_DESTINO=${$('#txtPedidoDestino').val()}&CLIENTE_DESTINO=${pegaChave('#txtClienteDestino')}&STATUS_DESTINO=${pegaChave('#txtStatusDestino')}`,
        JSON.stringify(body),
        100000);

      if (!response) {
        return
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw msgErro(jsonStr.mensagem);
      }
      toastr.success(`Pedido duplicado com sucesso: ${$('#txtPedidoDestino').val()}!`, "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/pedido/${btoa($('#txtPedidoDestino').val())}`
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#modalDuplicarPedido').on('hide.bs.modal', function () {
    $('#txtClienteDestino').val('')
    $('#txtStatusDestino').val('')
  });

  /// AQUI PRA BAIXO COMEÇA FUNÇÕES DO MODAL DE SITUAÇÃO DO PEDIDO

  $('#tabelaPedido').on('click', '#btnSituacao', async function () {
    const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
    await buscaSituacao(data[0])
    $('#txtTituloSituacao').html(data[0]);
    $('#txtTituloSituacao').val(data[0]);
    $('#modal-situacaopedido').modal('show');
  });

  async function buscaSituacao(numero) {
    $.LoadingOverlay('show')
    try {
      const pesquisaDesconto = {
        tabela: 'PEDIDO',
        camposSelect: ['PER_DESC'],
        where: [`NUMERO = '${numero}'`]
      }

      const jsonStrDesconto = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDesconto));

      const filtros = `PEDIDO=${numero}&DESCONTO=${jsonStrDesconto[0].PER_DESC}&EMPRESA=${getCookie('empresa')}`
      const response = await requisicao('GET', `/sisplan/pedido/v1/buscaresumopedido?`, filtros, '', null);

      if (!response) {
        return true;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem)
        return;
      }

      await preencheSituacao(jsonStr[0])
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function preencheSituacao(resumo) {
    $('#txtQtdeTotalQtde').val(resumo.QTDEVENDA)
    $('#txtQtdeTotalValor').val(formataNumeroValor(resumo.VALVENDA))
    $('#txtQtdeTotalValorLiq').val(formataNumeroValor(resumo.VALVENDALIQ))
    $('#txtQtdeTotalPesoMedioSomado').val(resumo.PESOMEDIO)

    $('#txtQtdeTotalFreteQtde').val(resumo.QTDEVENDAFRETE)
    $('#txtQtdeTotalFreteValor').val(formataNumeroValor(resumo.VALVENDAFRETE))
    $('#txtQtdeTotalFreteValorLiq').val(formataNumeroValor(resumo.VALVENDALIQFRETE))

    $('#txtFaturadoQtde').val(resumo.QTDEENTREGUE)
    $('#txtFaturadoValor').val(formataNumeroValor(resumo.VALENTREGUE))
    $('#txtFaturadoValorLiq').val(formataNumeroValor(resumo.VALENTREGUELIQ))

    $('#txtReservaQtde').val(resumo.QTDERES)
    $('#txtReservaValor').val(formataNumeroValor(resumo.VALRES))
    $('#txtReservaValorLiq').val(formataNumeroValor(resumo.VALLIQRES))

    $('#txtExpedicaoQtde').val(resumo.QTDEDESTINADO)
    $('#txtExpedicaoValor').val(formataNumeroValor(resumo.VALDESTINADO))
    $('#txtExpedicaoValorLiq').val(formataNumeroValor(resumo.VALDESTINADOLIQ))
    $('#txtExpedicaoPesoMedioSomado').val(resumo.PESOMEDIOEXP)

    $('#txtCanceladoQtde').val(resumo.QTDECANCELADO)
    $('#txtCanceladoValor').val(formataNumeroValor(resumo.VALCANCELADO))
    $('#txtCanceladoValorLiq').val(formataNumeroValor(resumo.VALCANCELADOLIQ))

    $('#txtSaldoPedidoExpQtde').val(resumo.SALDOQTDE)
    $('#txtSaldoPedidoExpValor').val(formataNumeroValor(resumo.SALDOVALOR))
    $('#txtSaldoPedidoExpValorLiq').val(formataNumeroValor(resumo.SALDOVALLIQ))

    $('#txtSaldoPedidoQtde').val(resumo.QTDESALDO)
    $('#txtSaldoPedidoValor').val(formataNumeroValor(resumo.VALSALDO))
    $('#txtSaldoPedidoValorLiq').val(formataNumeroValor(resumo.VALSALDOLIQ))
    // AQUI COMEÇA AS PARADAS DE NOTA
    $('#txtFaturadoNotaQtde').val(resumo.QTDEENTREGUENOTA)
    $('#txtFaturadoNotaValor').val(formataNumeroValor(resumo.VALENTREGUENOTA))
    $('#txtFaturadoNotaValorLiq').val(formataNumeroValor(resumo.VALENTREGUENOTALIQ))

    $('#txtDevolvidoNotaQtde').val(resumo.QTDEDEVOLVIDO)
    $('#txtDevolvidoNotaValor').val(formataNumeroValor(resumo.VALDEVOLVIDO))
    $('#txtDevolvidoNotaValorLiq').val(formataNumeroValor(resumo.VALDEVOLVIDOLIQ))

    $('#txtCanceladoNotaQtde').val(resumo.QTDECANCELADONOTA)
    $('#txtCanceladoNotaValor').val(formataNumeroValor(resumo.VALORCANCELADONOTA))
    $('#txtCanceladoNotaValorLiq').val(formataNumeroValor(resumo.VALLIQCANCELADONOTA))

    $('#txtSaldoNotaQtde').val(resumo.QTDESALDONOTA)
    $('#txtSaldoNotaValor').val(formataNumeroValor(resumo.VALORSALDONOTA))
    $('#txtSaldoNotaValorLiq').val(formataNumeroValor(resumo.VALORLIQSALDONOTA))

    $('#txtTotalIPIQtde').val(resumo.TOTALIPI)
    $('#txtTotalIPIValor').val(formataNumeroValor(resumo.SALDOTOTALIPI))
    $('#txtTotalIPIValorLiq').val(formataNumeroValor(resumo.SALDOTOTALIPILIQ))
  }

  function formataNumeroValor(numero) {
    return numero.toFixed(2).replace('.', ',').replace(/\d(?=(\d{3})+,)/g, '$&.');
  }

  $('#tabelaPedido').on('click', '#btnVisualizaNotas', async function () {
    $.LoadingOverlay('show')
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      const notas = await buscaNotasFiscais(data[0])

      if (notas.length <= 0) {
        throw new Error('Nenhuma nota encontrada para este pedido!')
      }

      await montaDataTableNotas(notas)

      $('#txtTituloNotasFiscais').html(data[0]);
      $('#txtTituloNotasFiscais').val(data[0]);
      $('#modal-notasFiscais').modal('show');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function buscaNotasFiscais(numero) {
    const pesquisaCliente = {
      tabela: 'PEDIDO',
      camposSelect: ['CODCLI'],
      where: [`NUMERO = '${numero}'`]
    }

    const jsonStrCliente = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCliente));

    const filtros = `NUMERO=${numero}&CLIENTE=${jsonStrCliente[0].CODCLI}`
    const response = await requisicao('GET', `/sisplan/pedido/v1/buscanotasfiscais?`, filtros, '', null);

    if (!response) {
      return true;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr['RESULT'][0].mensagem)
      return;
    }

    return jsonStr
  }

  async function montaDataTableNotas(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaNotasFiscais').DataTable({
      bPaginate: false,
      search: false,
      destroy: true,
      colReorder: true,
      info: false,

      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [6, 10, 11],
        },
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [2, 4],
        },
      ],
    });
  }

  async function carregaValoresPadroesAnte() {
    const jsonStr = await buscaValoresPadroes('GERAR_ANTECIPACAO')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'MOEDA': {
          if (item.VALOR != '' && $('#txtMoeda').val() == '') {
            insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
            $('#txtMoeda').trigger('blur');
          }
          break;
        }
        case 'HISTORICO': {
          if (item.VALOR != '' && $('#txtHistorico').val() == '') {
            insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CLASSE': {
          if (item.VALOR != '' && $('#txtClasseGer').val() == '') {
            insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'SITUACAO': {
          if (item.VALOR != '' && $('#txtSituacao').val() == '') {
            insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CONTA': {
          if (item.VALOR != '' && $('#txtConta').val() == '') {
            insereValor('#txtConta', item.VALOR, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: item.VALOR });
            $('#txtConta').trigger('blur');
          }
          break;
        }
        case 'BANCO': {
          if (item.VALOR != '' && $('#txtBanco').val() == '') {
            insereValor('#txtBanco', item.VALOR, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: item.VALOR });
          }
          break;
        }

        default:
          break;
      }
    });
  }

});