$(document).ready(async function () {
  $("#tutorial").on("click", function () {
    $(document).ready(async function () {
      function RotinaCliqueAvancar(componente) {
        currentFs = $(componente).parent();
        nextFs = $(componente).parent().next();

        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

        nextFs.show();
        currentFs.animate(
          {
            opacity: 0,
          },
          {
            step(now) {
              opacity = 1 - now;

              currentFs.css({
                display: "none",
                position: "relative",
              });
              nextFs.css({
                opacity,
              });
            },
            duration: 600,
          }
        );
      }
      const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
        animate: true,
        onNext: (Element) => {
          if (Element.node.id == "avancar1") {
            RotinaCliqueAvancar($("#avancar1"));
          }
          if (Element.node.id == "gravar") {
            $(".driver-next-btn").on("click", location.reload());
          }
        },
        onPrevious: (Element) => {
          if (Element.node.id == "configuracao") {
            $("#voltar3").trigger("click");
          }
          if (Element.node.id == "formcard1") {
            $(".driver-close-btn").on("click", location.reload());
          }
        },
      });

      driver.defineSteps([
        {
          element: "#formcard1",
          popover: {
            title: "Dados Gerais",
            description: "Aqui estão os campos disponíveis para o cadastro.",
            position: "top",
          },
        },
        {
          element: "#avancar1",
          popover: {
            title: "Botão Avançar",
            description: "Clique aqui para ir para a próxima aba.",
            position: "left",
          },
        },
        {
          element: "#configuracao",
          popover: {
            title: "Itens",
            description: "Aqui você adicionará os itens a serem movimentados",
            position: "top",
          },
        },
        {
          element: "#voltar3",
          popover: {
            title: "Botão Voltar",
            description:
              "Ao clicar nesse botão você retorna para a aba Configurações.",
            position: "left",
          },
        },
        {
          element: "#btnGravar",
          popover: {
            title: "Botão Gravar",
            description:
              "Clique aqui para gravar e efetuar a transferência de depósito.",
            position: "left",
          },
        },
        {
          element: "#btnSair",
          popover: {
            title: "Botão Sair",
            description: "Clique aqui para sair da tela",
            position: "left",
          },
        },
      ]);
      driver.start();
    });
  });

  let codigoSaidasTransfDepositoManual = '';
  let codigoEntradasTransfDepositoManual = '';

  async function carregaTipoTransferencia() {
    const pesquisaParam = {
      tabela: 'TABBAI',
      camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
      where: [`ATIVO = 'S'`],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    let entradaManual = '';
    let saidaManual = '';

    jsonStr.forEach(tipoEntradaSaida => {
      if (tipoEntradaSaida.TIPO) {
        if (tipoEntradaSaida.TIPO.charAt(8) === 'S') {
          entradaManual += entradaManual ? `,'${tipoEntradaSaida.CODIGO}'` : `'${tipoEntradaSaida.CODIGO}'`;
        }
        if (tipoEntradaSaida.TIPO.charAt(17) === 'S') {
          saidaManual += saidaManual ? `,'${tipoEntradaSaida.CODIGO}'` : `'${tipoEntradaSaida.CODIGO}'`;
        }
      }
    });

    codigoEntradasTransfDepositoManual = entradaManual;
    codigoSaidasTransfDepositoManual = saidaManual;
  }

  await carregaTipoTransferencia();

  function RotinaCliqueAvancar(componente) {
    currentFs = $(componente).parent();
    nextFs = $(componente).parent().next();

    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

    nextFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            display: "none",
            position: "relative",
          });
          nextFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  }
  $("#txtQuantidadeBipada").val(0);
  $("#txtNumero").focus();
  let currentFs;
  let nextFs;
  let previousFs;
  let opacity;

  $(".next").click(function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    // $("#msform").validate().element("#txtNumero");
    // $("#msform").validate().element("#txtFuncionario");
    // $("#msform").validate().element("#txtDepOrigem");

    if (
      !$("#msform").validate().element("#txtNumero") ||
      !$("#msform").validate().element("#txtFuncionario") ||
      !$("#msform").validate().element("#txtDepOrigem")
    ) {
      erros += 1;
    }

    if (erros == 0) {
      RotinaCliqueAvancar(this);
    }
  });

  $(".previous").click(function () {
    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li")
      .eq($("fieldset").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  $("#btnSair").on("click", function () {
    msgAlerta(
      `Tem certeza que deseja sair? Os dados não gravados serão perdidos.`,
      async function () {
        await deletaArquivo("JsonProdTransferenciaDeposito");
        window.location.reload();
      }
    );
  });

  $("#msform").validate({
    ignore: "",
    rules: {
      txtNumero: {
        required: true,
      },
      txtFuncionario: {
        required: true,
      },
      txtDepOrigem: {
        required: true,
      },
      txtDepDestino: {
        required: true,
      },
      txtTipoMovSaida: {
        required: true,
      },
      txtTipoMovEntrada: {
        required: true,
      },
    },
    messages: {
      txtNumero: {
        required: "Informe um número de transferência",
      },
      txtFuncionario: {
        required: "Informe um funcionário.",
      },
      txtDepOrigem: {
        required: "Informe um depósito",
      },
      txtDepDestino: {
        required: "Informe um depósito.",
      },
      txtTipoMovSaida: {
        required: "Informe um tipo de movimento.",
      },
      txtTipoMovEntrada: {
        required: "Informe um tipo de movimento.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $(".submit").click(function () {
    return false;
  });

  let filtroDepositos;
  filtroDepositos = await verificaDepositosUsuarioLogado(getCookie('cod_usuario'));

  if (filtroDepositos == '') {
    filtroDepositos = await verificaDepositosEmpresaLogada(getCookie('empresa'));
  }

  let listaBarrasBipadas = [];
  const parametrosSistema = await BuscaParametrosSistema();
  const utilizaBarraLog = parametrosSistema[0].VALOR != 0;
  await carregaValoresPadroes();

  const paramsPesquisaFuncionarioCadastroUsuario = {
    tabela: "ACESSO_USUARIOS",
    camposSelect: [
      "CODFUN"
    ],
    where: [`CODIGO = '${getCookie('cod_usuario')}'`]
  };

  const jsonStrPesquisaFuncionarioCadastroUsuario = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(paramsPesquisaFuncionarioCadastroUsuario)));
  if (jsonStrPesquisaFuncionarioCadastroUsuario[0].CODFUN !== '') {
    const paramsPesquisaNomeFuncionarioCadastroUsuario = {
      tabela: "PESSOAL",
      camposSelect: [
        "CODIGO",
        "NOME"
      ],
      where: [`CODIGO = '${jsonStrPesquisaFuncionarioCadastroUsuario[0].CODFUN}'`]
    };
    const jsonStrPesquisaNomeFuncionarioCadastroUsuario = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(paramsPesquisaNomeFuncionarioCadastroUsuario)));
    insereValor('#txtFuncionario', jsonStrPesquisaNomeFuncionarioCadastroUsuario[0].CODIGO, jsonStrPesquisaNomeFuncionarioCadastroUsuario[0].NOME);
  }

  const whereDeposito = filtroDepositos ? `"CODIGO IN (${filtroDepositos})"` : null;
  CriaTabelaPadrao("#tabelaItens");
  CriaTabela("#tabelaItensGravados", [8], [10]);
  $("#txtFuncionario").autocompleta(1, `JSON={"tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $("#txtDepOrigem").autocompleta(1, `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": [${whereDeposito}]}`);
  $("#txtDepDestino").autocompleta(1, `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": [${whereDeposito}]}`);
  $("#txtTipoMovSaida").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": ["CODIGO IN (${codigoSaidasTransfDepositoManual})"]}`);
  $("#txtTipoMovEntrada").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": ["CODIGO IN (${codigoEntradasTransfDepositoManual})"]}`);
  $("#txtProduto").autocompleta(3, `JSON={"tabela": "PRODUTO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], [], () => habilitaProximoCampo("#txtProduto"));
  $("#txtCor").autocompleta(1, `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], [], () => habilitaProximoCampo("#txtCor"));
  $("#txtTam").autocompleta(1, `JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": null}`, [], [], [], () => habilitaProximoCampo("#txtTam"));
  $("#txtQualidade").autocompleta(1, `JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, [], [], [], () => habilitaProximoCampo("#txtQualidade"));
  $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"PA_MOV", "camposSelect":["DISTINCT NUM_DOCTO CHAVE, LANCAMENTO DESCRICAO"], "where": ["PA_MOV.OPERACAO = 'E'"]}`, [], [], []);

  $("#btnFuncionario").pesquisa_array(["#txtFuncionario"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`, "Pesquisa Funcionário", "pessoal");
  $("#btnDepOrigem").pesquisa_array(["#txtDepOrigem"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": [${whereDeposito}]}`, "Pesquisa Deposito", "deposito");
  $("#btnDepDestino").pesquisa_array(["#txtDepDestino"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": [${whereDeposito}]}`, "Pesquisa Deposito", "deposito");

  $('#btnTipoMov').on('click', function () {
    if (!codigoSaidasTransfDepositoManual) {
      msgErro('Não existe Tipo Movimento Saída cadastrada como Saída Transf. Depósito na tela "Tipo Baixa" para essa consulta.');
      return;
    }

    $('#btnTipoMov').pesquisa_array(['#txtTipoMovSaida'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoSaidasTransfDepositoManual})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
  });

  $('#btnTipoMovEntrada').on('click', function () {
    if (!codigoEntradasTransfDepositoManual) {
      msgErro('Não existe Tipo Movimento Entrada cadastrada como Entrada Transf. Depósito na tela "Tipo Baixa" para essa consulta.');
      return;
    }

    $('#btnTipoMovEntrada').pesquisa_array(['#txtTipoMovEntrada'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoEntradasTransfDepositoManual})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
  });

  $("#btnProduto").pesquisa_array(["#txtProduto"], ["CHAVE", "CODIGO2"], ["DESCRICAO", "CODIGO2"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PRODUTO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO", "CODIGO2"], "where": null}', "Pesquisa Produto", "produto", () => habilitaProximoCampo("#txtProduto"));
  $("#btnCor").pesquisa_array(["#txtCor"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}', "Pesquisa Cor", "cadcor", () => habilitaProximoCampo("#txtCor"));
  $("#btnTam").pesquisa_array(["#txtTam"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": null}', "Pesquisa Tam", "tabtam", () => habilitaProximoCampo("#txtTam"));
  $("#btnQualidade").pesquisa_array(["#txtQualidade"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}', "Pesquisa Qualidade", "tabqul", () => habilitaProximoCampo("#txtQualidade"));
  $("#btnDocumento").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["LANCAMENTO"], `{"tabela":"PA_MOV", "camposSelect":[ "NUM_DOCTO", "LANCAMENTO", "DT_MVTO"], "orderBy": ["DT_MVTO DESC"], "groupBy": ["NUM_DOCTO", "LANCAMENTO", "DT_MVTO"], "where": ["OPERACAO  = 'E'"]}`, "Pesquisa Documento");

  $("#btnProdutoNovoIt").pesquisa_array(["#txtProdutoNovoIt"], ["CHAVE", "CODIGO2"], ["DESCRICAO", "CODIGO2"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PRODUTO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO", "CODIGO2"], "where": null}', "Pesquisa Produto", "produto", () => alteraPesquisaCor());
  $("#btnCorNovoIt").pesquisa_array(["#txtCorNovoIt"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}', "Pesquisa Cor", "cadcor");
  $("#btnTamNovoIt").pesquisa_array(["#txtTamNovoIt"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": null}', "Pesquisa Tam", "tabtam");
  $("#btnQualidadeNovoIt").pesquisa_array(["#txtQualidadeNovoIt"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}', "Pesquisa Qualidade", "tabqul");

  function alteraPesquisaCor() {
    $("#btnCorNovoIt").pesquisa_array(
      ["#txtCorNovoIt"],
      ["CHAVE"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave("#txtProdutoNovoIt")}')"]}`,
      "Pesquisa Cor",
      "cadcor",
      () => alteraPesquisaTam()
    );
  }

  function alteraPesquisaTam() {
    $("#btnTamNovoIt").pesquisa_array(
      ["#txtTamNovoIt"],
      ["CHAVE"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": ["TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO='${pegaChave("#txtProdutoNovoIt")}' AND COR ='${pegaChave("#txtCorNovoIt")}')"]}`,
      "Pesquisa Tamanho",
      "tabtam"
    );
  }

  $("#btnLimparFuncionario").on("click", function () {
    $("#txtFuncionario").val("");
  });

  $("#btnLimparNovoIt").on("click", function () {
    $("#txtProdutoNovoIt").val("");
    $("#txtCorNovoIt").val("");
    $("#txtTamNovoIt").val("");
    $("#txtQualidadeNovoIt").val("");
    $("#txtQtdeNovoItem").val("");
  });

  $("#btnLimparDepositoDestino").on("click", function () {
    $("#txtDepDestino").val("");
  });

  $("#btnLimparDepositoOrigem").on("click", function () {
    $("#txtDepOrigem").val("");
  });

  $("#btnLimparTipoMov").on("click", function () {
    $("#txtTipoMovSaida").val("");
  });

  $("#btnLimparTipoMovEntrada").on("click", function () {
    $("#txtTipoMovEntrada").val("");
  });

  $('#btnLimpaDocumento').on('click', function () {
    $('#txtDocumento').val('');
  });

  $('#btnLimparObs').on('click', function () {
    $('#txtObs').val('');
  });

  $("#txtProduto").on("blur", function () {
    $("#txtCor").autocompleta(
      1,
      `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
        "#txtProduto"
      )}')"]}`,
      [],
      [],
      [],
      () => habilitaProximoCampo("#txtCor")
    );
    $("#txtTam").autocompleta(
      1,
      `JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": ["TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
        "#txtProduto"
      )}')"]}`,
      [],
      [],
      [],
      () => habilitaProximoCampo("#txtTam")
    );
    $("#btnCor").pesquisa_array(
      ["#txtCor"],
      ["CHAVE"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
        "#txtProduto"
      )}')"]}`,
      "Pesquisa Cor",
      "cadcor",
      () => habilitaProximoCampo("#txtCor")
    );
    $("#btnTam").pesquisa_array(
      ["#txtTam"],
      ["CHAVE"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": ["TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
        "#txtProduto"
      )}')"]}`,
      "Pesquisa Tam",
      "tabtam",
      () => habilitaProximoCampo("#txtTam")
    );

    rotinaSaidaTamanho();
  });

  function habilitaProximoCampo(campoAtual) {
    const listaCampos = [
      "#txtProduto",
      "#txtCor",
      "#txtTam",
      "#txtLote",
      "#txtQualidade",
      "#btn-adicionar",
    ];
    const indiceEncontrado = listaCampos.findIndex(
      (campo) => campo === campoAtual
    );

    listaCampos.forEach((campo, index) => {
      if (index <= indiceEncontrado) {
        $(listaCampos[index + 1]).prop("disabled", false);
      } else {
        $(listaCampos[index + 1]).prop("disabled", true);
      }
    });
  }

  $("#txtProduto").on("change", function () {
    habilitaProximoCampo("#txtProduto");
  });

  $("#txtCor").on("change", function () {
    habilitaProximoCampo("#txtCor");
  });

  $("#txtTam").on("change", function () {
    habilitaProximoCampo("#txtTam");
  });

  $("#txtLote").on("change", function () {
    habilitaProximoCampo("#txtLote");
  });

  $("#txtQualidade").on("change", function () {
    habilitaProximoCampo("#txtQualidade");
  });

  function rotinaSaidaProduto() { }

  function rotinaSaidaCor() { }

  function rotinaSaidaTamanho() {
    $("#txtTam").on("blur", function () {
      const sCodigo = `'${pegaChave("#txtProduto")}'`;
      const sCor = `'${pegaChave("#txtCor")}'`;
      const sTam = `'${pegaChave("#txtTam")}'`;
      const sDeposito = `'${pegaChave("#txtDepOrigem")}'`;
      $("#txtLote").autocompleta(
        1,
        `JSON={"tabela": "PA_ITEN", "camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["CODIGO = ${sCodigo} AND COR = ${sCor} AND TAM=${sTam} AND DEPOSITO = ${sDeposito}"]}`,
        [],
        [],
        [],
        () => habilitaProximoCampo("#txtLote")
      );
      $("#btnLote").pesquisa_array(
        ["#txtLote"],
        ["CHAVE"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PA_ITEN", "camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["CODIGO = ${sCodigo} AND COR = ${sCor} AND TAM=${sTam} AND DEPOSITO = ${sDeposito}"]}`,
        "Pesquisa Lote",
        "pa_iten",
        () => habilitaProximoCampo("#txtLote")
      );
    });
  }

  function rotinaSaidaLote() { }

  function rotinaSaidaQualidade() { }

  $("#btn-adicionar").on("keypress", async function () {
    $("#btn-adicionar").trigger("click");
  });

  function limpaCampos() {
    $("#txtProduto").val("");
    $("#txtCor").val("");
    $("#txtTam").val("");
    $("#txtLote").val("");
    $("#txtQualidade").val("");
    $("#txtBarra").val("");
  }

  $("#txtNumero").on("blur", async function () {
    try {
      $.LoadingOverlay("show");
      const lancamento = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
      insereValor('#txtLancamento', lancamento);
      if ($(this).val() == "") {
        const docto = await RetornaProximo("DOCTO", "PA_MOV", "NUM_DOCTO", "6");
        $("#tabelaItensGravados").DataTable().clear().draw(false);
        insereValor("#txtNumero", docto);
        $(this).attr("disabled", $(this).val() != "");
      } else {
        carregaItensMovimentados();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function carregaItensMovimentados() {
    try {
      const documento = $("#txtNumero").val();
      const tipoBanco = await retornaDatabase();
      let subStringObservacao = '';
      if (tipoBanco == 'FIREBIRD') {
        subStringObservacao = `AND SUBSTRING(Observacao FROM 1 FOR 9) <> 'ESTORNADO'`;
      } else if (tipoBanco == 'SQLSERVER') {
        subStringObservacao = `AND SUBSTRING(OBSERVACAO, 1, 9) <> 'ESTORNADO'`
      } else if (tipoBanco == 'ORACLE') {
        subStringObservacao = `AND SUBSTR(OBSERVACAO, 1, 9) <> 'ESTORNADO'`;
      }
      const dadosSelect = {
        camposSelect: [
          `'' AS SEL`,
          "PA_MOV.CODIGO",
          "PRODUTO.DESCRICAO",
          "PA_MOV.COR",
          "CADCOR.DESCRICAO DESC_COR",
          "PA_MOV.TAMANHO",
          "PA_MOV.LOTE",
          "PA_MOV.TIPO",
          "SUM(PA_MOV.QTDE) QTDE",
          "PA_MOV.LANCAMENTO",
          "PA_MOV.DT_MVTO",
        ],
        tabela: "PA_MOV",
        leftJoin: [
          {
            tabela: "PRODUTO",
            condicao: "PRODUTO.CODIGO = PA_MOV.CODIGO",
          },
          {
            tabela: "CADCOR",
            condicao: "CADCOR.COR = PA_MOV.COR",
          },
        ],
        where: [`PA_MOV.NUM_DOCTO = '${documento}' AND OPERACAO = 'E' ${subStringObservacao}`],
        groupBy: [
          "PA_MOV.CODIGO, PRODUTO.DESCRICAO",
          "PA_MOV.COR",
          "CADCOR.DESCRICAO",
          "PA_MOV.TAMANHO",
          "PA_MOV.LOTE",
          "PA_MOV.TIPO",
          "PA_MOV.LANCAMENTO",
          "PA_MOV.DT_MVTO",
        ],
      };

      $("#tabelaItensGravados").DataTable().clear().draw(false);
      const listaItens = await retornaJsonPesquisaPadrao(
        JSON.stringify(dadosSelect)
      );

      listaItens.forEach((item, i) => {
        const dados = [
          item.SEL = `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check${i}" class="campoSel">
          <label for="check${i}"></label>
          </div>`,
          item.CODIGO,
          item.DESCRICAO,
          item.COR,
          item.DESC_COR,
          item.TAMANHO,
          item.QTDE,
          item.LOTE,
          item.TIPO,
          item.LANCAMENTO,
          item.DT_MVTO
        ];
        $('#check_todos').prop('checked', false);
        $("#tabelaItensGravados").DataTable().row.add(dados).draw(false);
      });
    } finally {
      $(".itens_gravados").removeClass("d-none");
      $('#btnEstornar').removeClass('d-none');
    }

    $('.campoSel').on('change', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
      $('#check_todos').prop('checked', $('.campoSel').length == $('.selecionado').length);
    });


  }

  async function adicionaRegistroGrid() {
    const barra = $("#txtBarra").val();
    let barralog = barra.substr(0, 6);
    const codigo = pegaChave("#txtProduto");
    const cor = pegaChave("#txtCor");
    const tam = pegaChave("#txtTam");
    const lote = pegaChave("#txtLote");
    const qual = pegaChave("#txtQualidade");
    const deposito = pegaChave("#txtDepOrigem");
    const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');
    const qtde = pegaValor('#txtQuantidade') > 0 ? parseFloat(pegaValor('#txtQuantidade')) : 1;
    const bBarraLog = await retornaBarraLogLida($('#txtBarra').val()) == "barra_log";
    let dadosBarra = [];

    if (bBarraLog) {
      barralog = await extraiBarra28(barra);
    }

    const indiceItemImportacao = $("#tabelaItens")
      .DataTable()
      .data()
      .toArray()
      .findIndex(
        (item) =>
          item[12] === barra);

    if (indiceItemImportacao === -1) {
      let where
      let dadosSelect

      if (utilizaBarraLog && barra !== "" && bBarraLog) {
        where = [`BARRA_LOG.BARRA = '${encodeURIComponent(barra)}' AND BARRA_LOG.DEPOSITO='${deposito}'`,]

        dadosSelect = {
          camposSelect: [
            "PA_ITEN.CODIGO",
            "PRODUTO.DESCRICAO",
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO DESC_COR",
            "PA_ITEN.TAM",
            "PA_ITEN.LOTE",
            "PA_ITEN.TIPO",
            "SUM(PA_ITEN.QUANTIDADE) QTDE",
            "PRODUTO.CUSTO",
          ],
          tabela: "PA_ITEN",
          leftJoin: [
            {
              tabela: "PRODUTO",
              condicao: "PRODUTO.CODIGO = PA_ITEN.CODIGO",
            },
            {
              tabela: "CADCOR",
              condicao: "CADCOR.COR = PA_ITEN.COR",
            },
            {
              tabela: "BARRA_LOG",
              condicao: "BARRA_LOG.CODIGO = PA_ITEN.CODIGO AND BARRA_LOG.COR = PA_ITEN.COR AND BARRA_LOG.TAMANHO = PA_ITEN.TAM AND BARRA_LOG.DEPOSITO = PA_ITEN.DEPOSITO",
            }
          ],
          where,
          groupBy: [
            "PA_ITEN.CODIGO, PRODUTO.DESCRICAO",
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO",
            "PA_ITEN.TAM",
            "PA_ITEN.LOTE",
            "PA_ITEN.TIPO",
            "PRODUTO.CUSTO",
          ],
          having: ["SUM(PA_ITEN.QUANTIDADE) > 0"],
        };

      } else {
        where =
          barra === ""
            ? [
              `PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.COR = '${cor}' AND PA_ITEN.TAM = '${tam}' AND PA_ITEN.LOTE = '${lote}' AND PA_ITEN.TIPO = '${qual}' AND PA_ITEN.DEPOSITO = '${deposito}'`,
            ]
            : [
              `(PA_ITEN.BARRA = '${encodeURIComponent(barra)}' OR PA_ITEN.BARRA28 = '${encodeURIComponent(barralog)}' OR PA_ITEN.BARRACLI = '${encodeURIComponent(barra)}') AND PA_ITEN.DEPOSITO='${deposito}'`,
            ];

        dadosSelect = {
          camposSelect: [
            "PA_ITEN.CODIGO",
            "PRODUTO.DESCRICAO",
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO DESC_COR",
            "PA_ITEN.TAM",
            "PA_ITEN.LOTE",
            "PA_ITEN.TIPO",
            "SUM(PA_ITEN.QUANTIDADE) QTDE",
            "PRODUTO.CUSTO",
          ],
          tabela: "PA_ITEN",
          leftJoin: [
            {
              tabela: "PRODUTO",
              condicao: "PRODUTO.CODIGO = PA_ITEN.CODIGO",
            },
            {
              tabela: "CADCOR",
              condicao: "CADCOR.COR = PA_ITEN.COR",
            },
          ],
          where,
          groupBy: [
            "PA_ITEN.CODIGO, PRODUTO.DESCRICAO",
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO",
            "PA_ITEN.TAM",
            "PA_ITEN.LOTE",
            "PA_ITEN.TIPO",
            "PRODUTO.CUSTO",
          ],
          having: ["SUM(PA_ITEN.QUANTIDADE) > 0"],
        };
      }

      const retornoSelect = await retornaJsonPesquisaPadrao(
        JSON.stringify(dadosSelect)
      );
      if (!retornoSelect) {
        msgAlerta("Produto não encontrado, verifique");
        return;
      }
      if (retornoSelect.length === 0) {
        msgAlerta("Produto não encontrado ou sem estoque disponível, verifique");
        return;
      }

      dadosBarra = [
        retornoSelect[0].CODIGO,
        retornoSelect[0].DESCRICAO,
        retornoSelect[0].COR,
        retornoSelect[0].DESC_COR,
        retornoSelect[0].TAM,
        retornoSelect[0].QTDE,
        qtde,
        retornoSelect[0].LOTE,
        retornoSelect[0].TIPO,
        retornoSelect[0].CUSTO,
      ];

      if (dadosBarra[5] === 0) {
        $('#txtQuantidade').val('1');
        msgAlerta("Quantidade em estoque insuficiente, verifique");
        return;
      }
    }

    if ((bBarraLog) && (utilizaBarraLog)) {
      if (validaBarraLog(barra, estornaQuantidade == 'true')) {
        return;
      }
    }

    const total = $("#tabelaItens").DataTable().data().length;
    const indexItem = indiceItemImportacao != -1 ? indiceItemImportacao
      : $("#tabelaItens").DataTable().data().toArray().findIndex(
        (item) =>
          item[0] === dadosBarra[0] && item[2] === dadosBarra[2] && item[4] === dadosBarra[4]);
    if (indexItem === -1 && estornaQuantidade == 'true' && codigo == '') {
      msgAlerta('Nenhum item para estornar!');
    } else if (indexItem === -1) {
      if (dadosBarra[5] < qtde) {
        $('#txtQuantidade').val('1');
        msgAlerta("Quantidade excedida, verifique");
        return;
      }
      $("#tabelaItens").DataTable().row.add(dadosBarra).draw(false);
      $(`#tabelaItens tbody tr:eq(${total})`).click();
    } else {
      let data = $("#tabelaItens").DataTable().row(indexItem).data();
      const quant = estornaQuantidade == 'true' && codigo == '' ? data[6] - qtde : data[6] + qtde;

      if (data[5] < quant) {
        $('#txtQuantidade').val('1');
        msgAlerta("Quantidade excedida, verifique");
        return;
      }

      if (quant == 0) {
        $('#tabelaItens').DataTable().row(indexItem).remove().draw(false);
        VerificaQuantidadeBipada();
        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonProdTransferenciaDeposito', jsonarquivo);
        return;
      }
      data[6] = quant;
      $('#tabelaItens').DataTable().row(indexItem).data(data).draw(false);

      $($("#tabelaItens tbody tr")[indexItem]).click();
      $(".dataTables_scrollBody").scrollTo(
        $("#tabelaItens tbody tr").eq(indexItem),
        200
      );
    }

    $("#tabelaItens").DataTable().columns.adjust().draw(false);
    VerificaQuantidadeBipada();
    const jsonarquivo = montaJsonArquivo();
    await salvaArquivo('JsonProdTransferenciaDeposito', jsonarquivo);
    $('#txtQuantidade').val('1');
  }

  async function adicionaRegistroGridRFID(obj) {
    const codigo = pegaChave("#txtProduto");
    const barra = obj.BARRA != '' ? obj.BARRA : obj.BARRA28 != '' ? obj.BARRA28 : obj.BARRACLI;
    const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');
    const qtde = 1;
    const bBarraLog = utilizaBarraLog ? await retornaBarraLogLida($('#txtBarra').val()) == "barra_log" : false;
    let dadosBarra = [];

    const indiceItemImportacao = $("#tabelaItens")
      .DataTable()
      .data()
      .toArray()
      .findIndex(
        (item) =>
          item[12] === barra);

    if (indiceItemImportacao === -1) {
      dadosBarra = [
        obj.CODIGO,
        obj.DESCRICAO,
        obj.COR,
        obj.DESC_COR,
        obj.TAM,
        obj.QTDE,
        qtde,
        obj.LOTE,
        obj.TIPO,
        obj.CUSTO,
      ];

      if (dadosBarra[5] === 0) {
        $('#txtQuantidade').val('1');
        msgAlerta("Quantidade em estoque insuficiente, verifique");
        return;
      }
    }

    if ((bBarraLog) && (utilizaBarraLog)) {
      if (validaBarraLog(barra, estornaQuantidade == 'true')) {
        return;
      }
    }

    const total = $("#tabelaItens").DataTable().data().length;
    const indexItem = indiceItemImportacao != -1 ? indiceItemImportacao
      : $("#tabelaItens").DataTable().data().toArray().findIndex(
        (item) =>
          item[0] === dadosBarra[0] && item[2] === dadosBarra[2] && item[4] === dadosBarra[4]);
    if (indexItem === -1 && estornaQuantidade == 'true' && codigo == '') {
      msgAlerta('Nenhum item para estornar!');
    } else if (indexItem === -1) {
      $("#tabelaItens").DataTaable().row.add(dadosBarra).draw(false);
      $(`#tabelaItens tbody tr:eq(${total})`).click();
    } else {
      let data = $("#tabelaItens").DataTable().row(indexItem).data();
      const quant = estornaQuantidade == 'true' && codigo == '' ? data[6] - qtde : data[6] + qtde;

      if (data[5] < quant) {
        $('#txtQuantidade').val('1');
        msgAlerta("Quantidade excedida, verifique");
        return;
      }

      if (quant == 0) {
        $('#tabelaItens').DataTable().row(indexItem).remove().draw(false);
        return;
      }
      data[6] = quant;
      $('#tabelaItens').DataTable().row(indexItem).data(data).draw(false);

      $($("#tabelaItens tbody tr")[indexItem]).click();
      $(".dataTables_scrollBody").scrollTo(
        $("#tabelaItens tbody tr").eq(indexItem),
        200
      );
    }
    $("#tabelaItens").DataTable().columns.adjust().draw(false);
  }

  async function montaJsonObjeto() {
    const dados = $("#tabelaItens").DataTable().data().toArray();
    const lista = dados
      .map((item) => {
        return {
          codigo: item[0],
          cor: item[2],
          tamanho: item[4],
          deposito: pegaChave("#txtDepOrigem"),
          quantidade: item[6],
          documento: $("#txtNumero").val(),
          custo: item[9],
          qualidade: item[8],
          lote: item[7],
          unidade: "",
          cliente: "",
          descricao: "",
          tipo: "MN",
          observacao: `- ${$('#txtObs').val()} Funcionario: ${pegaChave(
            "#txtFuncionario"
          )} ${pegaDescricao("#txtFuncionario")}`,
          docto: item[11],
          funcionario: pegaChave('#txtFuncionario'),
          tipobaixa: pegaChave("#txtTipoMovSaida"),
          tipoMovSaida: pegaChave("#txtTipoMovSaida"),
          tipoMovEntrada: pegaChave('#txtTipoMovEntrada')
        };
      })
      .filter((item) => item.quantidade > 0);
    return lista;
  }

  $("#btnGravar").on("click", async function () {
    try {
      $.LoadingOverlay('show');
      $('#btnGravar').prop('disabled', true);
      try {

        const listaProdutos = await montaJsonObjeto();
        if (listaProdutos.length === 0) {
          msgErro("Nenhum item a ser movimentado, verifique!");
          return;
        }
        const objeto = {
          produtos: listaProdutos,
        };

        const barraslog = {
          barras: utilizaBarraLog ? listaBarrasBipadas : []
        };

        const depositoDestino = pegaChave("#txtDepDestino");
        let lancamento = $('#txtLancamento').val();

        const novoItem = {
          codigo: pegaChave('#txtProdutoNovoIt'),
          cor: pegaChave('#txtCorNovoIt'),
          tamanho: pegaChave('#txtTamNovoIt'),
          lote: pegaChave('#txtLoteNovoIt'),
          qualidade: pegaChave('#txtQualidadeNovoIt'),
          quantidade: pegaValor('#txtQtdeNovoItem')
        };

        if ((novoItem.codigo != '' || novoItem.cor != '' || novoItem.tamanho != '' || novoItem.qualidade != '' || novoItem.quantidade != '') &&
          (novoItem.codigo == '' || novoItem.cor == '' || novoItem.tamanho == '' || novoItem.qualidade == '' || novoItem.quantidade == '')) {
          msgAlerta('Novo item preenchido parcialmente, necessário preencher todos os campos ou clicar no botão limpar.');
          return;
        };

        const response = await requisicao(
          "POST",
          "/Sisplan/Estoque/V1/transferenciaestoque?",
          "",
          `JSON=${encodeURIComponent(
            JSON.stringify(objeto)
          )}&DEPOSITO_DESTINO=${depositoDestino}&LANCAMENTO=${lancamento}&JSONBARRAS=${encodeURIComponent(JSON.stringify(barraslog))}` +
          `&NOVO_ITEM=${encodeURIComponent(JSON.stringify(novoItem))}`,
          300000);

        if (!response) {
          return "";
        }
        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return jsonStr.mensagem;
        }
        await carregaItensMovimentados();
        lancamento = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtLancamento', lancamento);
        $("#tabelaItens").DataTable().clear().draw(false);
        $("#txtQuantidadeBipada").val(0);
        if (listaImportacao.length > 0) {
          await rotinaGeraLog('TRANSFERENCIA_DEPOSITO', $('#txtNumero').val(), `Documentos ${listaImportacao.toString()} foram importados na transferencia ${$('#txtNumero').val()}`, 'Movimentação');
        }
        await deletaArquivo('JsonProdTransferenciaDeposito');
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível gravar os dados.`);
        return "";
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#btnGravar').prop('disabled', false);
    }
  });

  $('#btnEstornar').on('click', async function () {
    msgAlerta('Deseja realmente estornar a movimentação?', estornaMovimentacao);
  });

  async function estornaMovimentacao() {
    try {
      $.LoadingOverlay('show');
      try {

        const selecionados = $('.selecionado');

        if (selecionados.length == 0) {
          msgAlerta('Nenhum produto selecionado para estornar, verifique!');
          return;
        }

        let produtosEstorno = [{}];

        for (let i = 0; i < selecionados.length; i++) {
          const id = selecionados[i].id.substr(5, selecionados[i].id.length);
          const data = $('#tabelaItensGravados').DataTable().row(id).data();
          produtosEstorno[i] = {
            CODIGO: data[1],
            COR: data[3],
            TAMANHO: data[5],
            LOTE: data[7],
            TIPO: data[8],
            LANCAMENTO: data[9],
            DOCUMENTO: $('#txtNumero').val()
          }
        }

        const objeto = {
          produtos: produtosEstorno
        }

        const response = await requisicao('POST', '/Sisplan/Estoque/V1/estornamovimento?', '', `PRODUTOS_ESTORNO=${encodeURIComponent(JSON.stringify(objeto))}`, 300000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }
        carregaItensMovimentados();
        $('#check_todos').prop('checked', false);
        listaImportacao = [];
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível estornar o movimento');
        return;
      }
    } finally {
      $('.itens_gravados').addClass('d-none');
      $('#btnEstornar').addClass('d-none');
      $.LoadingOverlay('hide');
    }
  }

  async function VerificaQuantidadeBipada() {
    let QuantidadeBipada = 0;
    const tabelaItens = $("#tabelaItens").DataTable().data();
    for (let i = 0; i < tabelaItens.length; i++) {
      QuantidadeBipada =
        parseFloat(QuantidadeBipada) +
        parseFloat(tabelaItens[i][6])
    }
    $("#txtQuantidadeBipada").val(QuantidadeBipada);
  }

  $("#txtBarra").on("keydown", async function (event) {
    if (event.key == "Enter") {
      $("#txtBarra").trigger("blur");
      $("#txtBarra").focus();
    }
  });

  $("#btn-adicionar").on("click", async function () {
    adicionaRegistroGrid();
    limpaCampos();
    habilitaProximoCampo("#txtProduto");
    $("#txtProduto").focus();
  });

  $("#txtBarra").on("blur", async function () {
    if ($(this).val() !== "") {
      adicionaRegistroGrid();
      limpaCampos();
      $("#txtBarra").focus();
    }
  });

  rotinaSaidaProduto();
  rotinaSaidaTamanho();
  rotinaSaidaCor();
  rotinaSaidaLote();
  rotinaSaidaQualidade();

  retornaHintRelatorio('btnImprimir', 'transferencia_deposito_prod')

  $("#btnImprimir").on("click", async function () {
    const DadosGravados = $("#tabelaItensGravados").DataTable().data();
    if (DadosGravados.length > 0) {
      ImprimirRelatorio();
    } else {
      msgAlerta('Necessário gravar alguma informação antes de imprimir os dados.');
    }
  });

  async function ImprimirRelatorio() {
    const url = `/sisplan/impressao/v1/imprimirtransferenciadeposito?`;
    const documento = $('#txtNumero').val();
    const params = `DOCUMENTO=${documento}`;
    const response = await requisicao("GET", url, params, null);
    const arquivo = await response.text();

    if (arquivo != undefined) {
      window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
      await limparRelatorios();
    }
  }

  $('#btnImportar').on('click', function () {
    $('#modalImportar').modal('show');
  });

  let listaImportacao = [];
  $('#btnConfirmarImportacao').on('click', async function () {
    await buscaImportacao();
  });

  async function buscaImportacao() {
    const documento = pegaChave('#txtDocumento');
    const lancamento = pegaDescricao('#txtDocumento');
    const movimentacao = $('#radioEntrada').prop('checked') == true ? 'E' : 'S';

    try {

      if (listaImportacao.find(importacao => importacao == $('#txtDocumento').val()) != undefined) {
        msgAlerta('Documento já foi importado!');
        return;
      }

      const response = await requisicao('GET', '/sisplan/estoque/v1/importamovimentacao?', `MOVIMENTACAO=${movimentacao}&DOCUMENTO=${documento}&LANCAMENTO=${lancamento}`, '', 600000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        return;
      }

      listaImportacao.push($('#txtDocumento').val());
      await adicionaImportacaoGrid(jsonStr, pegaChave('#txtDocumento'));

    } catch (error) {
      console.log(error);
    } finally {
      $('#modalImportar').modal('hide');
    }
  }

  async function adicionaImportacaoGrid(itens, docto) {

    for (let i = 0; i < itens.length; i++) {

      const total = $("#tabelaItens").DataTable().data().length;

      const dados = [
        itens[i].CODIGO,
        itens[i].DESCRICAO,
        itens[i].COR,
        itens[i].DESC_COR,
        itens[i].TAMANHO,
        itens[i].QTDE,
        itens[i].QTDE,
        itens[i].LOTE,
        itens[i].TIPO,
        itens[i].CUSTO,
        itens[i].DEPOSITO,
        docto,
        itens[i].BARRA
      ];

      if (dados[5] === 0) {
        msgAlerta("Atenção! Item " + itens[i].CODIGO + " - " + itens[i].DESCRICAO + " - " + itens[i].COR + " - " + itens[i].TAMANHO + " sem quantidade na movimentação importada");
      }

      const indexItem = $("#tabelaItens")
        .DataTable()
        .data()
        .toArray()
        .findIndex(
          (item) =>
            item[0] === dados[0] && item[2] === dados[2] && item[4] === dados[4] &&
            item[7] === dados[7] && item[8] === dados[8] && item[10] === dados[10] &&
            item[11] === dados[11] && item[12] === dados[12]
        );
      if (indexItem === -1) {
        $("#tabelaItens").DataTable().row.add(dados).draw(false);
        $(`#tabelaItens tbody tr:eq(${total})`).click();
      } else {
        let data = $("#tabelaItens").DataTable().row(indexItem).data();
        const valorInput = parseInt(itens[i].QTDE) + parseInt(data[6]);
        data[5] = valorInput;

        if (data[5] < valorInput) {
          msgAlerta("Quantidade excedida, verifique");
          return;
        }

        data[6] = valorInput;
        $('#tabelaItens').DataTable().row(indexItem).data(data);
        $($("#tabelaItens tbody tr")[indexItem]).click();
        $(".dataTables_scrollBody").scrollTo(
          $("#tabelaItens tbody tr").eq(indexItem),
          200
        );
      }

      $("#tabelaItens").DataTable().columns.adjust().draw(false);
      VerificaQuantidadeBipada();
      const jsonarquivo = montaJsonArquivo();
      await salvaArquivo('JsonProdTransferenciaDeposito', jsonarquivo);
    }
  }

  $('#divMovimento').on('change', async function () {
    const movimentacao = $('#radioEntrada').prop('checked') == true ? 'E' : 'S';
    $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"PA_MOV", "camposSelect":["DISTINCT NUM_DOCTO CHAVE, LANCAMENTO DESCRICAO"], "where": ["PA_MOV.OPERACAO = '${movimentacao}'"]}`, [], [], []);
    $("#btnDocumento").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["LANCAMENTO"], `{"tabela":"PA_MOV", "camposSelect":[ "NUM_DOCTO", "LANCAMENTO", "DT_MVTO"], "orderBy": ["DT_MVTO DESC"], "groupBy": ["NUM_DOCTO", "LANCAMENTO", "DT_MVTO"], "where": ["OPERACAO  = '${movimentacao}'"]}`, "Pesquisa Documento");
  });

  try {
    const response = await carregaArquivo('JsonProdTransferenciaDeposito');
    if (response.status === 200) {
      const jsonStr = await response.json();
      insereValor("#txtFuncionario", jsonStr.funcionario.split("] - ")[0].substr(1), jsonStr.funcionario.split("] - ")[1]);
      insereValor("#txtDepOrigem", jsonStr.depositoOrig.split("] - ")[0].substr(1), jsonStr.depositoOrig.split("] - ")[1]);
      insereValor("#txtDepDestino", jsonStr.depositoDest.split("] - ")[0].substr(1), jsonStr.depositoDest.split("] - ")[1]);
      insereValor("#txtTipoMovSaida", jsonStr.tipoMovimento.split("] - ")[0].substr(1), jsonStr.tipoMovimento.split("] - ")[1]);

      for (let i = 0; i < jsonStr.itens.length; i++) {
        if (!jsonStr.itens[i].docto) {
          jsonStr.itens[i].estoque = await buscaQuantidadeEstoque(jsonStr.itens[i], pegaChave('#txtDepOrigem'));
        }
      }

      jsonStr.itens.forEach((item) => {
        if (item.docto) {
          $("#tabelaItens")
            .DataTable()
            .row.add([
              item.codigo,
              item.descricao,
              item.cor,
              item.descCor,
              item.tam,
              item.estoque,
              item.qtde,
              item.lote,
              item.qualidade,
              item.custo,
              item.deposito,
              item.docto,
              item.barra,
            ])
            .draw(false);
        } else {
          $("#tabelaItens")
            .DataTable()
            .row.add([
              item.codigo,
              item.descricao,
              item.cor,
              item.descCor,
              item.tam,
              item.estoque,
              item.qtde,
              item.lote,
              item.qualidade,
              item.custo,
            ])
            .draw(false);
        }
      });
      listaBarrasBipadas = jsonStr.barrasbipadas;

      VerificaQuantidadeBipada();
      msgAlerta("Carregado dados não salvos, verifique.");
    }
  } catch (error) {
    console.log(error);
  }

  function montaJsonItens() {
    const itensDataTable = $("#tabelaItens").DataTable().data().toArray();
    const itens = itensDataTable.map((itemDT, i) => {
      if (itemDT.length == 10) {
        const item = {
          codigo: itemDT[0],
          descricao: itemDT[1],
          cor: itemDT[2],
          descCor: itemDT[3],
          tam: itemDT[4],
          estoque: itemDT[5],
          qtde: itemDT[6],
          lote: itemDT[7],
          qualidade: itemDT[8],
          custo: itemDT[9],
        };
        return item;
      } else if (itemDT.length == 13) {
        const item = {
          codigo: itemDT[0],
          descricao: itemDT[1],
          cor: itemDT[2],
          descCor: itemDT[3],
          tam: itemDT[4],
          estoque: itemDT[5],
          qtde: itemDT[6],
          lote: itemDT[7],
          qualidade: itemDT[8],
          custo: itemDT[9],
          deposito: itemDT[10],
          docto: itemDT[11],
          barra: itemDT[12],
        };
        return item;
      }
    });
    return itens;
  }

  function montaJsonArquivo() {
    const importacao = {
      numero: $("#txtNumero").val(),
      funcionario: $("#txtFuncionario").val(),
      depositoOrig: $("#txtDepOrigem").val(),
      depositoDest: $("#txtDepDestino").val(),
      tipoMovimento: $("#txtTipoMovSaida").val(),
      itens: montaJsonItens(),
      barrasbipadas: listaBarrasBipadas,
    };
    return importacao;
  }

  async function buscaQuantidadeEstoque(produto, deposito) {
    try {

      const dadosSelect = {
        camposSelect: ["PA_ITEN.QUANTIDADE"],
        tabela: "PA_ITEN",
        where: [`PA_ITEN.CODIGO = '${produto.codigo}' AND PA_ITEN.COR = '${produto.cor}' AND PA_ITEN.TAM = '${produto.tam}' AND PA_ITEN.LOTE = '${produto.lote}' AND PA_ITEN.DEPOSITO = '${deposito}'`],
      };

      const quantidade = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

      return quantidade[0].QUANTIDADE;

    } catch (error) {
      console.log(error);
    }

  }

  $('#btnMenosOuMais').on('click', function () {
    const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
    $('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
    $('#txtBarra').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
    $('#txtBarra').focus();
    $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
    if (estaComoEstorno) {
      $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
    } else { $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus'); }
  });

  function CriaTabela(sSeletor, colunasInvisiveis = [], colunasData = []) {
    $(sSeletor).DataTable({
      autoWidth: false,
      destroy: true,
      order: false,
      filter: false,
      paginate: false,
      key: "true",
      columnDefs: [
        {
          targets: colunasInvisiveis,
          visible: false,
        },
        {
          render: render = function (data, type, row) {
            let isIE = function () {
              if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
                return true;
              }
              return false;

            };
            if (isIE()) {
              x = data.slice(0, 10).split('-');
              return `${x[2]}/${x[1]}/${x[0]}`;
            }
            x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;

          },
          targets: colunasData,
        },
      ],
    });

  }

  $('#check_todos').on('change', function () {
    $('.campoSel').prop('checked', $('#check_todos').prop('checked'));
    if ($('#check_todos').prop('checked')) {
      $('.campoSel').addClass('selecionado');

    } else {
      $('.campoSel').removeClass('selecionado');

    }
  });

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('TRANSF_DEPOSITO')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'FUNCIONARIO_PROD': {
          if (item.VALOR != '') {
            insereValor('#txtFuncionario', item.VALOR, { tabela: 'PESSOAL', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'DEPOSITO_ORIGEM_PROD': {
          if (filtroDepositos) {
            const arrayDepositos = filtroDepositos.replaceAll(`'`, '').split(',')
            if (item.VALOR && arrayDepositos.includes(item.VALOR)) {
              insereValor('#txtDepOrigem', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR })
            }
          } else {
            if (item.VALOR) {
              insereValor('#txtDepOrigem', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR })
            }
          }
          break
        }
        case 'DEPOSITO_DEST_PROD': {
          if (filtroDepositos) {
            const arrayDepositos = filtroDepositos.replaceAll(`'`, '').split(',')
            if (item.VALOR && arrayDepositos.includes(item.VALOR)) {
              insereValor('#txtDepDestino', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR })
            }
          } else {
            if (item.VALOR) {
              insereValor('#txtDepDestino', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
            }
          }
          break;
        }
        case 'TIPO_MOVTO_PROD': {
          if (item.VALOR != '') {
            insereValor('#txtTipoMovSaida', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TIPO_MOVTO_PROD_ENTR': {
          if (item.VALOR != '') {
            insereValor('#txtTipoMovEntrada', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
      }
    });
  };

  async function retornaBarraLogLida(sBarra) {
    try {
      const url = `/sisplan/barralog/v1/validarbarra?`;
      const params = `barra=${encodeURIComponent(sBarra)}`;
      const response = await requisicao('GET', url, params, 15000);

      if (!response) {
        return;
      }

      jsonStr = await response.json();
      if (response.status != 200) {
        return jsonStr.mensagem;
      }

      return jsonStr.mensagem;
    } catch (error) {
      console.error(error);
    }
  }

  function validaBarraLog(barra, estorno) {
    if (estorno) {
      if (!listaBarrasBipadas.some(item => item.barra === barra)) {
        msgAlerta('Barra não foi bipada ou já foi estornada, verifique.')
        return true
      }
      listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== barra)];
    } else if (listaBarrasBipadas.find(item => item.barra == barra)) {
      msgAlerta(`Barra ${barra} já lida, verifique.`);
      return true;
    } else {
      listaBarrasBipadas.push({ barra: barra });
    }
  }

  $('#btnImportarRfid').on('click', async function () {
    await buscaEPCApiSisplan();
  });

  async function buscaEPCApiSisplan() {
    $('#modalRfid').modal('hide');
    $.LoadingOverlay('show');
    try {
      const numero = pegaValor('#txtNumLeitura');
      const deposito = pegaChave('#txtDepOrigem');

      if (numero == '') {
        msgAlerta('Necessário informar um número de leitura.');
        return;
      }

      let response = await requisicao('GET', '/sisplan/epc/v1/buscaepctransfdeposito?', `NUMERO=${numero}&DEPOSITO=${deposito}`, null, 30000);

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      };

      for (const epc of jsonStr) {
        await adicionaRegistroGridRFID(epc);
      }

      $("#tabelaItens").DataTable().columns.adjust().draw(false);
      VerificaQuantidadeBipada();
      const jsonarquivo = montaJsonArquivo();
      await salvaArquivo('JsonProdTransferenciaDeposito', jsonarquivo);
      $('#txtQuantidade').val('1');

    } catch (error) {
      console.log(error)
    } finally {
      $('#txtBarra').val('');
      $.LoadingOverlay('hide');
    }
  };

  $('#voltar3').on('click', async function () {
    const datatableItens = $('#tabelaItens').DataTable().data().toArray().length;

    if (datatableItens > 0) {
      $('#txtDepOrigem').prop('disabled', true);
      $('#btnDepOrigem').prop('disabled', true);
      $('#btnLimparDepositoOrigem').prop('disabled', true);
    } else {
      $('#txtDepOrigem').prop('disabled', false);
      $('#btnDepOrigem').prop('disabled', false);
      $('#btnLimparDepositoOrigem').prop('disabled', false);
    }
  });
  // async function buscaEPCApiSisplan() {//rotina antiga
  //   $('#modalRfid').modal('hide');
  //   $.LoadingOverlay('show');
  //   try {
  //     const numero = pegaValor('#txtNumLeitura');
  //     const deposito = pegaChave('#txtDepOrigem');

  //     if (numero == '') {
  //       msgAlerta('Necessário informar um número de leitura.');
  //       return;
  //     }

  //     let response = await requisicao('GET', '/sisplan/epc/v1/buscaepcexpedicaoapisisplan?', `NUMERO=${numero}&DEPOSITO=${deposito}&TRANSDEP=S`, null, 30000);

  //     const jsonStr = await response.json();

  //     if (response.status != 200) {
  //       msgErro(jsonStr.mensagem);
  //       return;
  //     };

  //     let barra;
  //     for (const epc of jsonStr) {
  //       if (epc.BARRA != '') {
  //         barra = epc.BARRA;
  //       } else if (epc.BARRA28 != '') {
  //         barra = epc.BARRA28;
  //       } else if (epc.BARRACLI != '') {
  //         barra = epc.BARRACLI;
  //       }
  //       $('#txtQuantidade').val(1);
  //       $('#txtBarra').val(barra);
  //       $('#txtCodigoEPC').val(epc.EPC);
  //       await adicionaRegistroGrid();
  //       // await sleep(150);
  //     }

  //   } catch (error) {
  //     console.log(error)
  //   } finally {
  //     $('#txtBarra').val('');
  //     $.LoadingOverlay('hide');
  //   }
  // };

});
