$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta das FALs.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma FAL.',
          position: 'right'
        }
      },
      {
        element: '#tabelaAcesso',
        popover: {
          title: 'Tabela Serviço de Tingimento',
          description: 'Aqui estão todas as FALs cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  let consultando = true

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.progppcpAcesso == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpAcesso: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.progppcpConsumos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpConsumos: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.progppcpOps == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpOps: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.progppcpEstoque == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpEstoque: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  function validaNovasColunas(novasColunas) {
    if (novasColunas.includes('SEL')) {
      throw new Error('Impossível deixar a coluna SEL invisível, favor desmarcar a mesma!');
    }
  }

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const novasColunas = retornaNovasColunasInvisiveis();

      validaNovasColunas(novasColunas)

      if (localStorage.getItem('tabelaconsumos') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpConsumos: novasColunas }))
        $('#tabelaConsumos').DataTable().columns().visible(true);
        $('#tabelaConsumos').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelaops') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpOps: novasColunas }))
        $('#tabelaOps').DataTable().columns().visible(true);
        $('#tabelaOps').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelaestoque') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpEstoque: novasColunas }))
        $('#tabelaEstoque').DataTable().columns().visible(true);
        $('#tabelaEstoque').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, progppcpAcesso: novasColunas }))
        $('#tabelaAcesso').DataTable().columns().visible(true);
        $('#tabelaAcesso').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('tabelaconsumos') == 'true') {
      $('#tabelaConsumos').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.progppcpConsumos ?? [], ['SEL'])
    } else if (localStorage.getItem('tabelaops') == 'true') {
      $('#tabelaOps').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.progppcpOps ?? [])
    } else if (localStorage.getItem('tabelaestoque') == 'true') {
      $('#tabelaEstoque').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.progppcpEstoque ?? [])
    } else {
      $('#tabelaAcesso').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.progppcpAcesso ?? [], ['SEL'])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('tabelaconsumos')
    localStorage.removeItem('tabelaops')
    localStorage.removeItem('tabelaestoque')
  })

  montaPesquisa();

  let bOculto = false;

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    consultando = true
    await consultaOps();
    $('#modal-filtros').modal('hide');
    destroiTabelasProcessar()
    consultando = false
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#dtFinalOpIni').val('1200-01-01');
    $('#dtFinalOpFim').val('2500-12-31');
    $('#dtEmissaoOpIni').val('1200-01-01');
    $('#dtEmissaoOpFim').val('2500-12-31');
    $('.camposFiltros').empty().trigger('change');
    $('.camposFiltros').val('');
    $('.camposFiltros').attr('data-chave', '');
    $('.camposFiltros').attr('data-desc', '');
  });

  async function buscaProcessar() {
    const filtros = await retornaFiltros(true)
    const response = await requisicao('GET', '/sisplan/progppcp/v1/buscaconsumos?', filtros, undefined, 480000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay("hide");
      throw new Error(jsonStr.mensagem);
    }

    return { tbConsumos: jsonStr[0], tbOfs: jsonStr[1] }
  }

  $('#btnProcessar').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      if ($('#tabelaAcesso').DataTable().rows('.selected').data().length == 0) {
        msgAlerta('Necessário selecionar ao menos uma OP para processar.');
        return;
      }

      const consultaProcessar = await buscaProcessar()
      await carregarConsumos(consultaProcessar.tbConsumos);
      await carregarOps(consultaProcessar.tbOfs);
      $('#tabelaConsumos tbody tr:eq(0)').trigger('click')
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#btnSolCompra').on('click', async function () {
    if ($('#tabelaConsumos').DataTable().rows('.selected').data().length == 0) {
      msgAlerta('Necessário selecionar ao menos uma OP para gerar solicitação de compra.');
      return;
    }

    await gerarSolCompra();
  });

  $('#btnConsumosOF').on('click', async function () {
    if ($('#tabelaConsumos').DataTable().rows('.selected').data().length == 0) {
      msgAlerta('Necessário selecionar ao menos uma OP para reservar os consumos.');
      return;
    }

    await reservarConsumos();
  });

  $('#btnSaldoNeg').on('click', async function () {
    mostrarSaldoNegativo();

    if (!bOculto) {
      bOculto = true;
    } else {
      bOculto = false;
    }
  });

  $('#btnGravar').on('click', async function () {
    await gravarDados();
  });

  async function gravarDados() {
    if (!validaGravar()) {
      msgAlerta('Nenhum item reservado para gravar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const dados = $('#tabelaConsumos').DataTable().rows().data().filter(item => item.RESERVA_CALC > 0);
      const sDeposito = await formataListas($('#txtDeposito').val().toString());
      let itens = [];
      dados.map(async item => {
        itens.push({
          CODIGO: item.CODIGO,
          COR: item.COR,
          DEPOSITO: sDeposito,
          LOTE: item.LOTE,
          TIPO: '',
          QTDE_B: 0,
          QTDE: item.RESERVA_CALC,
          ORDEM: 1,
          QUAL: '',
          PEDIDO: item.PEDIDO,
          NUMERO: item.NUMERO,
          DATA: retornaDataAtual()
        });
      });

      const response = await requisicao('POST', '/sisplan/progppcp/v1/gravareservas?', '', JSON.stringify({ RESERVAS: itens }), 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      $('#btnGravar').trigger('blur')

      criaMensagemSucesso('Reserva criada com sucesso para os consumos reservados.', () => { window.location.reload(); })

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function gerarSolCompra() {
    $.LoadingOverlay('show');
    try {

      const depositoPadrao = (await buscaValor('DEPOSITO', 'CODIGO', 'PRIORIDADE', '1')).CODIGO;

      const solicitacao = {
        NUMERO: await RetornaProximo('SOL_COMPRA', 'SOL_COMPRA', 'NUMERO', 6),
        EMPRESA: getCookie('empresa').replace('_', ''),
        DT_INICIO: retornaDataAtual(),
        USUARIO: getCookie('usuario'),
        DATA: retornaDataAtual(),
        DT_BAIXA: `1899-01-01T00:00:00Z`,
        LIBERADO: 'B',
        OBS: 'Solicitação criada através da Programação MRP',
        ITENS: [],
      };

      $('#tabelaConsumos').DataTable().rows('.selected').data().map((item, index) => {
        solicitacao.ITENS.push({
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          COR: item.COR,
          DEPOSITO: depositoPadrao,
          UNIDADE: item.UNIDADE,
          UNI_COM: item.UNI_COM,
          DIVISOR: item.DIVISOR,
          QTDE: item.CONSUMO,
          PRECO: item.PRECO_COMPRA,
          ORDEM: index + 1,
          TP_ITEM: 'M'
        });
      });

      const response = await requisicao('POST', '/sisplan/solicitacao_compra/v1/solicitacao_compra?', '', JSON.stringify(solicitacao), 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      $('#cbSelTodosCons').prop('checked', false);
      $('.campoSelCons').prop('checked', false);
      $('.linhaAcessoCons').removeClass('selected');

      criaMensagemSucesso(`Solicitação ${solicitacao.NUMERO} gravada com sucesso!`);

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregarConsumos(dados) {
    const tabelaJaCriada = $.fn.DataTable.isDataTable('#tabelaConsumos')
    if (tabelaJaCriada) {
      $("#tabelaConsumos").DataTable().destroy();
      $("#tabelaConsumos").empty();
    };
    $.LoadingOverlay('show');
    alteraAba();
    try {
      $('#divButtonsCons').addClass('d-none')

      let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
      ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

      const dataSetCols = [];
      let keys
      if (ordemColunasRelatorio != null && ordemColunasRelatorio.progppcpConsumos != undefined) {
        const ordenacao = 'GERAL'
        const colunas = ordemColunasRelatorio.progppcpConsumos.filter(f => f.ordenacao == ordenacao)
        keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(dados[0]);
      } else {
        keys = Object.keys(dados[0]);
      }

      const colunasOriginais = Object.keys(dados[0])

      keys.forEach((k) => {
        if (k == 'SEL') {
          dataSetCols.push({
            title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelTodosCons">
                <label for="cbSelTodosCons"></label>
              </div>
              `,
            data: k,
          });
        } else {
          dataSetCols.push({
            title: k,
            data: k,
          });
        }
      });

      dados.map(item => {
        item.SALDO = parseFloat(item.ESTOQUE + item.COMPRA - item.CONSUMO).toFixed(3)
      })

      $('#tabelaConsumos').DataTable({
        destroy: true,
        filter: false,
        autoWidth: true,
        paging: false,
        info: false,
        data: dados,
        columns: dataSetCols,
        scrollY: '250px',
        scrollX: true,
        paging: false,
        processing: true,
        order: [[keys.indexOf(colunasOriginais[1]), 'desc']],
        colReorder: true,
        createdRow: function (row, data, dataIndex) {
          $(row).addClass('linhaAcessoCons');
          if (data.SALDO < 0) {
            $(row).css('color', 'var(--vermelho-grid)')
          }
        },
        columnDefs: [
          {
            render: funcCheckboxConsumos,
            targets: [keys.indexOf(colunasOriginais[0])]
          },
          {
            class: 'pr-4 text-right',
            render: function (data) {
              if (data) {
                return parseFloat(data).toLocaleString("pt-br", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2,
                });
              } else {
                return ''
              }
            },
            targets: [keys.indexOf(colunasOriginais[9]), keys.indexOf(colunasOriginais[10]), keys.indexOf(colunasOriginais[11]),
            keys.indexOf(colunasOriginais[12]), keys.indexOf(colunasOriginais[13]), keys.indexOf(colunasOriginais[14]),
            keys.indexOf(colunasOriginais[15]), keys.indexOf(colunasOriginais[16]), keys.indexOf(colunasOriginais[17]),
            keys.indexOf(colunasOriginais[18]), keys.indexOf(colunasOriginais[19]), keys.indexOf(colunasOriginais[21]),
            keys.indexOf(colunasOriginais[22]), keys.indexOf(colunasOriginais[23]), keys.indexOf(colunasOriginais[31]),
            keys.indexOf(colunasOriginais[32]), keys.indexOf(colunasOriginais[35]), keys.indexOf(colunasOriginais[36]),
            keys.indexOf(colunasOriginais[37]), keys.indexOf(colunasOriginais[39]), keys.indexOf(colunasOriginais[40]),
            keys.indexOf(colunasOriginais[41]), keys.indexOf(colunasOriginais[43]), keys.indexOf(colunasOriginais[44]),
            keys.indexOf(colunasOriginais[45]), keys.indexOf(colunasOriginais[49]), keys.indexOf(colunasOriginais[50]),
            keys.indexOf(colunasOriginais[20])],
          }
        ]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaConsumos').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.progppcpConsumos).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('.campoSelCons').on('click', function () {
        $(this).parents('tr').trigger('click');
      });

      if (!tabelaJaCriada) {
        $('#tabelaConsumos').on('click', 'tr', async function () {
          selecionarLinhaTabela('#tabelaConsumos', 'campoSelCons', this);
          await carregaEstoque($('#tabelaConsumos').DataTable().row($(this)).data());
          await ajustaOps($('#tabelaConsumos').DataTable().row($(this)).data());
        });
      }

      $('#cbSelTodosCons').on('change', function () {
        if (isChecked('#cbSelTodosCons')) {
          $('.campoSelCons').prop('checked', true);
          $('.linhaAcessoCons').addClass('selected');
        } else {
          $('.campoSelCons').prop('checked', false);
          $('.linhaAcessoCons').removeClass('selected');
        }
      });

      $('#tabelaConsumos').on('column-reorder.dt', function (e, settings, details) {
        if (consultando) {
          return
        }
        const newColumnOrder = []

        for (let i = 0; i < settings.aoColumns.length; i++) {
          const column = settings.aoColumns[i].mData

          newColumnOrder.push(column)
        }

        let ordemColunas = localStorage.getItem('ordemColunasDataTable')
        ordemColunas = JSON.parse(ordemColunas)
        const ordenacao = 'GERAL'

        if (ordemColunas == null || ordemColunas.progppcpConsumos == undefined) {
          localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, progppcpConsumos: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

        } else if (!ordemColunas.progppcpConsumos.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
          ordensSalvas.progppcpConsumos.push(newObj)
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

        } else if (ordemColunas.progppcpConsumos.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          ordensSalvas.progppcpConsumos.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
        }
      });


      $('#divButtonsCons').removeClass('d-none')
      $.LoadingOverlay('hide');
    } catch (error) {
      console.error(error);
      msgAlerta(error.message)
      $.LoadingOverlay('hide');
    }
  };

  async function carregaEstoque(sData) {
    $.LoadingOverlay('show');
    try {
      let sWhere = `MAT_ITEN.CODIGO = '${sData.CODIGO}' AND MAT_ITEN.COR = '${sData.COR}' `;

      if (await formataListas($('#txtDeposito').val().toString()) != '') {
        sWhere += ` AND MAT_ITEN.DEPOSITO IN (${await formataListas($('#txtDeposito').val().toString())})`;
      }

      if (await formataListas($('#txtQualidade').val().toString()) != '') {
        sWhere += ` AND MAT_ITEN.QUALIDADE IN (${await formataListas($('#txtQualidade').val().toString())})`;
      }

      if (await formataListas($('#txtGrupoMA').val().toString()) != '') {
        sWhere += ` AND MATERIAL.GRUPO IN (${await formataListas($('#txtGrupoMA').val().toString())})`;
      }

      if (await formataListas($('#txtSubGrupo').val().toString()) != '') {
        sWhere += ` AND MATERIAL.SUB_GRUPO IN (${await formataListas($('#txtSubGrupo').val().toString())})`;
      }

      if (await formataListas($('#txtStatus').val().toString()) != '') {
        sWhere += ` AND MATERIAL.STATUS IN (${await formataListas($('#txtStatus').val().toString())})`;
      }

      const pesquisaParam = {
        tabela: 'MAT_ITEN',
        camposSelect: [
          'MAT_ITEN.LOTE', 'MAT_ITEN.DEPOSITO', 'MAT_ITEN.OBS', 'SUM(MAT_ITEN.QTDE) ESTOQUE',
          '(SELECT MIN(MAT.QTD_MINIMA) FROM [MAT_ITEN] MAT WHERE MAT.CODIGO = MAT_ITEN.CODIGO AND MAT.COR = MAT_ITEN.COR AND MAT.QTD_MINIMA > 0 ) EST_MIN',
          '(SELECT MAX(MAT.QTD_MAXIMA) FROM [MAT_ITEN] MAT WHERE MAT.CODIGO = MAT_ITEN.CODIGO AND MAT.COR = MAT_ITEN.COR AND MAT.QTD_MAXIMA > 0 ) EST_MAX',
          '(SELECT SUM(RESERVA.QTDE - RESERVA.QTDE_B) QTDE FROM [MAT_RESERVA] RESERVA WHERE RESERVA.CODIGO = MAT_ITEN.CODIGO AND RESERVA.COR = MAT_ITEN.COR AND RESERVA.LOTE = MAT_ITEN.LOTE AND RESERVA.DEPOSITO = MAT_ITEN.DEPOSITO) RESERVA',
          'MATERIAL.TIPO_MALHA', 'MATERIAL.PESO', 'MAT_ITEN.GRAMATURA', 'MAT_ITEN.LARGURA', 'MAT_ITEN.DT_FAB'
        ],
        innerJoin: [{ tabela: 'MATERIAL', condicao: 'MAT_ITEN.CODIGO = MATERIAL.CODIGO' }],
        where: [sWhere],
        groupBy: ['MAT_ITEN.LOTE', 'MAT_ITEN.DEPOSITO', 'MAT_ITEN.OBS', 'MAT_ITEN.CODIGO', 'MAT_ITEN.COR', 'MAT_ITEN.GRAMATURA', 'MAT_ITEN.LARGURA', 'MATERIAL.TIPO_MALHA', 'MATERIAL.PESO', 'MAT_ITEN.DT_FAB'],
        having: ['SUM(MAT_ITEN.QTDE) > 0']
      }

      const campos = ['LOTE', 'DEPOSITO', 'OBS', 'ESTOQUE',
        'EST_MIN', 'EST_MAX', 'RESERVA', 'TIPO_MALHA', 'PESO',
        'GRAMATURA', 'LARGURA', 'DT_FAB']

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      consultando = true

      if ($.fn.DataTable.isDataTable('#tabelaEstoque')) {
        $('#tabelaEstoque').DataTable().destroy();
        $('#tabelaEstoque').empty();
      };

      consultando = false
      $('#divButtonsEst').addClass('d-none')

      // if (jsonStr.length == '') {
      //   return;
      // };

      let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
      ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

      const dataSetCols = [];
      let keys
      if (ordemColunasRelatorio != null && ordemColunasRelatorio.progppcpEstoque != undefined) {
        const ordenacao = 'GERAL'
        const colunas = ordemColunasRelatorio.progppcpEstoque.filter(f => f.ordenacao == ordenacao)
        keys = colunas.length > 0 ? colunas[0].colunas : campos
      } else {
        keys = campos
      }

      const colunasOriginais = campos
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $('#tabelaEstoque').DataTable({
        destroy: true,
        filter: false,
        autoWidth: true,
        paging: false,
        info: false,
        data: jsonStr,
        columns: dataSetCols,
        scrollY: '250px',
        scrollX: true,
        paging: false,
        processing: true,
        order: [[keys.indexOf(colunasOriginais[0]), 'desc']],
        colReorder: true,
        columnDefs: [
          {
            render: funcFormataData,
            targets: [keys.indexOf(colunasOriginais[11])],
          },
          {
            visible: false,
            targets: [],
          },
          {
            targets: [keys.indexOf(colunasOriginais[3]), keys.indexOf(colunasOriginais[4]), keys.indexOf(colunasOriginais[5]), keys.indexOf(colunasOriginais[6])],
            class: 'pr-4 text-right',
            render: function (data) {
              if (data) {
                return parseFloat(data).toLocaleString("pt-br", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2,
                });
              } else {
                return ''
              }
            },
          }
        ]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaEstoque').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.progppcpEstoque).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#tabelaEstoque').on('column-reorder.dt', function (e, settings, details) {
        if (consultando) {
          return
        }
        const newColumnOrder = []

        for (let i = 0; i < settings.aoColumns.length; i++) {
          const column = settings.aoColumns[i].mData

          newColumnOrder.push(column)
        }

        let ordemColunas = localStorage.getItem('ordemColunasDataTable')
        ordemColunas = JSON.parse(ordemColunas)
        const ordenacao = 'GERAL'

        if (ordemColunas == null || ordemColunas.progppcpEstoque == undefined) {
          localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, progppcpEstoque: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

        } else if (!ordemColunas.progppcpEstoque.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
          ordensSalvas.progppcpEstoque.push(newObj)
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

        } else if (ordemColunas.progppcpEstoque.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          ordensSalvas.progppcpEstoque.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
        }
      });

      $('#divButtonsEst').removeClass('d-none')

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function ajustaOps(sDados) {
    $.LoadingOverlay('show')
    try {
      let numeros = sDados.LISTAOFS;
      let codigo = sDados.CODIGO;
      let cor = sDados.COR;

      if (numeros != '') {
        let listaNumeros = numeros.replaceAll("'", "").split(',');
        $('#tabelaOps').DataTable().rows().every(function (rowIdx, tableLoop, rowLoop) {
          let data = this.data();
          let numeroOp = listaNumeros.includes(data.NUMERO?.trim());
          let codigoOp = data.CODIGO?.trim() === codigo?.trim();
          let corOp = data.COR?.trim() === cor?.trim();

          if (numeroOp && codigoOp && corOp) {
            $(this.node()).show();
          } else {
            $(this.node()).hide();
          }
        });
      } else {
        $('#tabelaOps tbody tr').hide();
      }
    } finally {
      $('#tabelaOps').DataTable().columns.adjust().draw(false)
      $.LoadingOverlay('hide')
    }
  }


  async function consultaOps() {
    const tabelaJaCriada = $.fn.DataTable.isDataTable('#tabelaAcesso')
    try {
      $.LoadingOverlay('show');
      $('#divButtonsAcesso').addClass('d-none')
      const filtros = await retornaFiltros()
      const response = await requisicao('GET', '/sisplan/progppcp/v1/buscaops?', filtros, undefined, 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
      ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

      const dataSetCols = [];
      let keys
      if (ordemColunasRelatorio != null && ordemColunasRelatorio.progppcpAcesso != undefined) {
        const ordenacao = 'GERAL'
        const colunas = ordemColunasRelatorio.progppcpAcesso.filter(f => f.ordenacao == ordenacao)
        keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(jsonStr[0]);
      } else {
        keys = Object.keys(jsonStr[0]);
      }

      const colunasOriginais = Object.keys(jsonStr[0])

      keys.forEach((k) => {
        if (k == 'SEL') {
          dataSetCols.push({
            title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelTodos">
                <label for="cbSelTodos"></label>
              </div>
              `,
            data: k,
          });
        } else {
          dataSetCols.push({
            title: k,
            data: k,
          });
        }
      });

      $('#tabelaAcesso').DataTable({
        info: false,
        destroy: true,
        filter: false,
        paging: false,
        data: jsonStr,
        columns: dataSetCols,
        order: [[keys.indexOf(colunasOriginais[1]), 'desc']],
        colReorder: true,
        createdRow: function (row, data, dataIndex) {
          $(row).addClass('linhaAcesso');
          if (data.NUM_OF_CONS == '') {
            $(row).css('color', 'var(--vermelho-grid)')
          }
        },
        columnDefs: [
          {
            render: funcCheckbox,
            targets: [keys.indexOf(colunasOriginais[0])]
          },
          {
            render: funcFormataData,
            targets: [keys.indexOf(colunasOriginais[8]), keys.indexOf(colunasOriginais[10]), keys.indexOf(colunasOriginais[19]), keys.indexOf(colunasOriginais[20])],
          },
          {
            visible: false,
            targets: [keys.indexOf(colunasOriginais[1]), keys.indexOf(colunasOriginais[2]), keys.indexOf(colunasOriginais[37])],
          }
        ]
      });

      $('#tabelaAcesso').DataTable().columns.adjust().draw()

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaAcesso').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.progppcpAcesso).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#tabelaAcesso').DataTable().data().toArray().forEach((item, index) => {
        if (item.NUM_OF_CONS == '') {
          $($('.campoSel')[index]).prop('disabled', true)
        } else {
          $($('.campoSel')[index]).prop('disabled', false)
        }
      })

      $('.campoSel').on('click', function () {
        window.event.preventDefault();
        $(this).parents('tr').trigger('click');
      });

      if (!tabelaJaCriada) {
        $('#tabelaAcesso').on('click', 'tr', function () {
          selecionarLinhaTabela('#tabelaAcesso', 'campoSel', this);
        });
      }

      $('#cbSelTodos').on('change', function () {
        if (isChecked('#cbSelTodos')) {
          $('#tabelaAcesso').DataTable().data().toArray().forEach((item, index) => {
            if (item.NUM_OF_CONS != '') {
              $($('.campoSel')[index]).prop('checked', true);
              $($('.linhaAcesso')[index]).addClass('selected');
            }
          })
        } else {
          $('#tabelaAcesso').DataTable().data().toArray().forEach((item, index) => {
            if (item.NUM_OF_CONS != '') {
              $($('.campoSel')[index]).prop('checked', false);
              $($('.linhaAcesso')[index]).removeClass('selected');
            }
          })
        }


      });

      $('#tabelaAcesso').on('column-reorder.dt', function (e, settings, details) {
        if (consultando) {
          return
        }
        const newColumnOrder = []

        for (let i = 0; i < settings.aoColumns.length; i++) {
          const column = settings.aoColumns[i].mData

          newColumnOrder.push(column)
        }

        let ordemColunas = localStorage.getItem('ordemColunasDataTable')
        ordemColunas = JSON.parse(ordemColunas)
        const ordenacao = 'GERAL'

        if (ordemColunas == null || ordemColunas.progppcpAcesso == undefined) {
          localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, progppcpAcesso: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

        } else if (!ordemColunas.progppcpAcesso.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
          ordensSalvas.progppcpAcesso.push(newObj)
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

        } else if (ordemColunas.progppcpAcesso.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          ordensSalvas.progppcpAcesso.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
        }
      });

      $('#btnProcessar').prop('disabled', false);
      $('#divButtonsAcesso').removeClass('d-none')
      $.LoadingOverlay('hide');
    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    }
  }

  async function retornaFiltros(bConsumos = false, bProcessado = false) {
    let ordemProducao = ''
    if (bConsumos || bProcessado) {
      $('#tabelaAcesso').DataTable().rows('.selected').data().map(item => {
        ordemProducao += (ordemProducao == '' ? `'${item.NUMERO}'` : `, '${item.NUMERO}'`);
      });
    }

    const retorno = `FINALOPINI=${pegaValor('#dtFinalOpIni')}` +
      `&FINALOPFIM=${pegaValor('#dtFinalOpFim')}` +
      `&EMISSAOOPINI=${pegaValor('#dtEmissaoOpIni')}` +
      `&EMISSAOOPFIM=${pegaValor('#dtEmissaoOpFim')}` +
      `&OPSINI=${pegaValor('#txtOpsIni')}` +
      `&OPSFIM=${pegaValor('#txtOpsFim')}` +
      `&PRAZOENTREGAINI=${pegaValor('#txtPrazoEntregaIni')}` +
      `&PRAZOENTREGAFIM=${pegaValor('#txtPrazoEntregaFim')}` +
      `&CORFT=${await formataListas($('#txtCorFt').val().toString())}` +
      `&SETORFT=${await formataListas($('#txtSetorFt').val().toString())}` +
      `&APLICACAOFT=${await formataListas($('#txtAplicacaoFt').val().toString())}` +
      `&DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
      `&PEDIDO=${await formataListas($('#txtPedido').val().toString())}` +
      `&STATUS=${await formataListas($('#txtStatus').val().toString())}` +
      `&SETORPEND=${await formataListas($('#txtSetorPend').val().toString())}` +
      `&TIPOOP=${await formataListas($('#txtTipoOp').val().toString())}` +
      `&PARTE=${await formataListas($('#txtParte').val().toString())}` +
      `&PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
      `&MODELO=${await formataListas($('#txtModelo').val().toString())}` +
      `&COLECAO=${await formataListas($('#txtColecao').val().toString())}` +
      `&GRUPOPA=${await formataListas($('#txtGrupoPA').val().toString())}` +
      `&MARCA=${await formataListas($('#txtMarca').val().toString())}` +
      `&ETIQUETA=${await formataListas($('#txtEtiqueta').val().toString())}` +
      `&CATEGORIA=${await formataListas($('#txtCategoria').val().toString())}` +
      `&LINHA=${await formataListas($('#txtLinha').val().toString())}` +
      `&COR=${await formataListas($('#txtCor').val().toString())}` +
      `&MATERIAL=${await formataListas($('#txtMaterial').val().toString())}` +
      `&GRUPOMA=${await formataListas($('#txtGrupoMA').val().toString())}` +
      `&SUBGRUPO=${await formataListas($('#txtSubGrupo').val().toString())}` +
      `&QUALIDADE=${await formataListas($('#txtQualidade').val().toString())}` +
      `&GRUPOCOR=${await formataListas($('#txtGrupoCor').val().toString())}` +
      `&FORNECEDOR=${await formataListas($('#txtFornecedor').val().toString())}` +
      `&ORDEMPRODUCAO=${bConsumos || bProcessado ? ordemProducao : await formataListas($('#txtOrdemProducao').val().toString())}` +
      `&CONSUMOS=${$('#rgSemConsumo').is(':checked') ? 'S' : $('#rgComConsumo').is(':checked') ? 'C' : 'T'}` +
      `&PROCESSADO=${bProcessado}`;

    return retorno;
  }

  function validaGravar() {
    let qtdeReservada = 0;

    $('#tabelaConsumos').DataTable().rows().data().map(item => {
      qtdeReservada += item.RESERVA_CALC;
    });

    return (qtdeReservada > 0);
  }

  async function carregarOps(data) {
    $('#divButtonsOps').addClass('d-none')
    const dataSetCols = [];

    let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
    ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

    let keys
    if (ordemColunasRelatorio != null && ordemColunasRelatorio.progppcpOps != undefined) {
      const ordenacao = 'GERAL'
      const colunas = ordemColunasRelatorio.progppcpOps.filter(f => f.ordenacao == ordenacao)
      keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(data[0]);
    } else {
      keys = Object.keys(data[0]);
    }

    const colunasOriginais = Object.keys(data[0])

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaOps').DataTable({
      destroy: true,
      filter: false,
      autoWidth: false,
      info: false,
      data: data,
      columns: dataSetCols,
      scrollY: '250px',
      scrollX: true,
      paging: false,
      processing: true,
      order: [[keys.indexOf(colunasOriginais[0]), 'desc']],
      colReorder: true,
      columnDefs: [
        {
          render: funcFormataData,
          targets: [keys.indexOf(colunasOriginais[10]), keys.indexOf(colunasOriginais[25]), keys.indexOf(colunasOriginais[36]), keys.indexOf(colunasOriginais[37]), keys.indexOf(colunasOriginais[38])],
        },
        {
          visible: false,
          targets: [keys.indexOf(colunasOriginais[0]), keys.indexOf(colunasOriginais[26]), keys.indexOf(colunasOriginais[10])],
        },
        {
          class: 'pr-4 text-right',
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [keys.indexOf(colunasOriginais[15]), keys.indexOf(colunasOriginais[16]), keys.indexOf(colunasOriginais[17]),
          keys.indexOf(colunasOriginais[18]), keys.indexOf(colunasOriginais[19])]
        },
        {
          class: 'pr-4 text-right',
          targets: [keys.indexOf(colunasOriginais[20]), keys.indexOf(colunasOriginais[4])]
        }
      ]
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaOps').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.progppcpOps).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $('#tabelaOps').on('column-reorder.dt', function (e, settings, details) {
      if (consultando) {
        return
      }
      const newColumnOrder = []

      for (let i = 0; i < settings.aoColumns.length; i++) {
        const column = settings.aoColumns[i].mData

        newColumnOrder.push(column)
      }

      let ordemColunas = localStorage.getItem('ordemColunasDataTable')
      ordemColunas = JSON.parse(ordemColunas)
      const ordenacao = 'GERAL'

      if (ordemColunas == null || ordemColunas.progppcpOps == undefined) {
        localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, progppcpOps: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

      } else if (!ordemColunas.progppcpOps.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
        ordensSalvas.progppcpOps.push(newObj)
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

      } else if (ordemColunas.progppcpOps.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        ordensSalvas.progppcpOps.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
      }
    });

    $('#divButtonsOps').removeClass('d-none')
  };

  async function reservarConsumos() {
    $.LoadingOverlay('show');
    try {
      $('#tabelaConsumos').DataTable().rows('.selected').data().map((item, index) => {
        const saldo = item.CONSUMO - coalesce(item.RESERVA) - coalesce(item.RESERVA_CALC);

        if ((saldo > 0) && (saldo <= item.ESTOQUE)) {
          item.RESERVA_CALC += saldo;
          item.SALDO = 0;
        }
      });

      $('#tabelaConsumos').DataTable().rows().data().map((item, index) => {
        $('#tabelaConsumos').DataTable().row(index).data(item).draw(false);
      });

      $('#btnConsumosOF').trigger('blur')

      await criaMensagemSucesso('Consumos reservados com sucesso', async () => {
        $('.campoSelCons').prop('checked', false);
        $('.linhaAcessoCons').removeClass('selected');
      })

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function mostrarSaldoNegativo() {
    $.LoadingOverlay('show');
    try {
      if (bOculto) {
        $('#tabelaConsumos tr').closest('tr').show();
        return;
      }

      $('#tabelaConsumos').DataTable().rows().data().map((item, index) => {
        if (item.SALDO >= 0) {
          $($('#tabelaConsumos tr')[index + 1]).closest('tr').hide()
        }
      });
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function alteraAba() {
    $('#tabAcesso').removeClass('active');
    $('#tabProgramacao').addClass('active');
    $('#tabAcesso').prop('aria-selected', 'false');
    $('#tabProgramacao').prop('aria-selected', 'true');
    $('#divAcesso').removeClass('active');
    $('#divProgramacao').addClass('active');
    $('#divAcesso').removeClass('show');
    $('#divProgramacao').addClass('show');
  };

  function funcFormataData(data, type, row) {
    if (!data) {
      return 'NÃO ESPECIFICADO'
    }
    x = data.slice(0, 10).split('-');
    return `${x[2]}/${x[1]}/${x[0]}`;
  };

  function funcCheckbox(data, type, row, meta) {
    return `<div class="icheck-primary d-inline">
                <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                <label for="check_col_${meta.row}_row_${meta.col}"></label>
            </div>`
  };

  function funcCheckboxConsumos(data, type, row, meta) {
    return `<div class="icheck-primary d-inline">
                <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSelCons">
                <label for="check_col_${meta.row}_row_${meta.col}"></label>
            </div>`
  };

  function funcPintaSaldoNeg(data) {
    if (data >= 0) {
      return data;
    }

    return `<p style="color: red">
              ${parseFloat(data).toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    })}
            </p>`
  };

  $('#buttonColVis').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      $('#modal-ColunasVisiveis').modal('show');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#buttonExcel').on('click', async function () {
    const dados = $("#tabelaAcesso").DataTable().data().toArray();
    await exportaCSV("", "", undefined, null, 'Relatório de programação MRP', '#tabelaAcesso', '', 999, false, false, dados);
  })

  $('#buttonColVisCons').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      localStorage.setItem('tabelaconsumos', 'true')
      $('#modal-ColunasVisiveis').modal('show');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#buttonExcelCons').on('click', async function () {
    const dados = $("#tabelaConsumos").DataTable().data().toArray();
    await exportaCSV("", "", undefined, null, 'Relatório de programação MRP', '#tabelaConsumos', '', 999, false, false, dados);
  })

  $('#buttonColVisOps').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      localStorage.setItem('tabelaops', 'true')
      $('#modal-ColunasVisiveis').modal('show');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#buttonExcelOps').on('click', async function () {
    const dados = $("#tabelaOps").DataTable().data().toArray();
    await exportaCSV("", "", undefined, null, 'Relatório de programação MRP', '#tabelaOps', '', 999, false, false, dados);
  })

  $('#buttonColVisEst').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      localStorage.setItem('tabelaestoque', 'true')
      $('#modal-ColunasVisiveis').modal('show');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#buttonExcelEst').on('click', async function () {
    const dados = $("#tabelaEstoque").DataTable().data().toArray();
    await exportaCSV("", "", undefined, null, 'Relatório de programação MRP', '#tabelaEstoque', '', 999, false, false, dados);
  })

  retornaHintRelatorio('btnImprimir', 'RelAcessoMRP')
  preencheOrdenacaoTela('RelAcessoMRP');

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = "/sisplan/impressao/v1/imprimiracessomrp?";

        const ordem = `TELA_ORDENACAO=RelAcessoMRP&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoMRP');
        const processado = $.fn.DataTable.isDataTable('#tabelaConsumos') && $('#tabelaConsumos').DataTable().data().toArray().length > 0
        const filtros = await retornaFiltros(false, processado)
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 480000, false, 'RelAcessoMRP', undefined);
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function destroiTabelasProcessar() {
    if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
      $("#tabelaConsumos").DataTable().destroy();
      $("#tabelaConsumos").empty();
    };
    if ($.fn.DataTable.isDataTable('#tabelaOps')) {
      $("#tabelaOps").DataTable().destroy();
      $("#tabelaOps").empty();
    };
    if ($.fn.DataTable.isDataTable('#tabelaEstoque')) {
      $("#tabelaEstoque").DataTable().destroy();
      $("#tabelaEstoque").empty();
    };
  }

  function montaPesquisa() {
    componenteFiltro('ordemProducao', true);
    componenteFiltro('projecao', true);
    componenteFiltro('corFt', true);
    componenteFiltro('setorFt', true);
    componenteFiltro('aplicacaoFt', true);
    componenteFiltro('deposito', true);
    componenteFiltro('pedido', true);
    componenteFiltro('status', true);
    componenteFiltro('tipoOp', true);
    componenteFiltro('setorPend', true);
    componenteFiltro('modelo', true);
    componenteFiltro('parte', true);
    componenteFiltro('produto', true);
    componenteFiltro('colecao', true);
    componenteFiltro('grupoPA', true);
    componenteFiltro('marca', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('categoria', true);
    componenteFiltro('linha', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('subGrupo', true);
    componenteFiltro('cor', true);
    componenteFiltro('material', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('grupoCor', true);
    componenteFiltro('fornecedor', true);
  };

});