function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {

    componenteFiltro('cliente', false, false, 'Empresa');
    componenteFiltro('setor', false, false);
    componenteFiltro('colecao', false, false);
    // componenteFiltro('cor', false, false);
    // componenteFiltro('tamanho', false, false, 'Tam');
    componenteFiltro('parte', true, true);
    componenteFiltro('produto', true, true);
    componenteFiltro('ordemProducao', true, true, 'Numero');
    componenteFiltro('maquina', true, true);

    adicionaMascaraCampos();

    function adicionaMascaraCampos() {
        $('.apenasFloat').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.apenasInteiros').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        });
    };

    $('#btnConsultar').on('click', async function (e) {
        e.preventDefault();
        $.LoadingOverlay('show');
        try {
            await buscaDados();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#cbValorManual').on('change', function () {
        if ($(this).prop('checked')) {
            senhaSupervisor('Necessário informar a senha de supervisor para realizar a operação.', () => {
                $('.valorManual').removeClass('d-none');
            }, () => { },
                false,
                () => {
                    $('.valorManual').addClass('d-none');
                    $('#cbValorManual').prop('checked', false);
                }, () => {
                    $('.valorManual').addClass('d-none');
                    $('#cbValorManual').prop('checked', false);
                }, () => {
                    $('.valorManual').addClass('d-none');
                    $('#cbValorManual').prop('checked', false);
                });
        } else {
            $('.valorManual').addClass('d-none');
        }
    })

    $('#txtValorManual').on('blur', async function () {
        if (($('#txtValorManual').val() > 0) && ($('#cbValorManual').prop('checked'))) {
            if (($.fn.DataTable.isDataTable('#tabelaRecalculo')) && ($('#tabelaRecalculo').DataTable().data().toArray().length > 0)) {
                $.LoadingOverlay('show');
                try {
                    await buscaDados();
                } finally {
                    $.LoadingOverlay('hide');
                }
            }
        }
    });

    async function retornaFiltros() {
        const result = {};

        result.data_de = $('#dtDe').val();
        result.data_ate = $('#dtAte').val();
        result.cliente = pegaChave('#txtEmpresa');
        result.setor = pegaChave('#txtSetor');
        result.colecao = pegaChave('#txtColecao');
        // result.cor = pegaChave('#txtCor');
        // result.tam = pegaChave('#txtTam');
        result.parte = (await formataListas($('#txtParte').val().toString()))
        result.produto = (await formataListas($('#txtProduto').val().toString()))
        result.numero = (await formataListas($('#txtNumero').val().toString()))
        result.maquina = (await formataListas($('#txtMaquina').val().toString()))
        result.movimento = $('#txtMov').val();
        result.movimento_ant = $('#txtMovAnt').val();
        result.lancto = $('#txtLanctoBaixa').val();
        result.lancto_envio = $('#txtLanctoEnvio').val();
        result.prazo_tabela = $('#txtDesconto').val();
        result.valor_manual = $('#txtValorManual').val();
        result.preco_estrutura = $('#cbPrecoEstrutura').prop('checked');
        result.somente_nao_pago = $('#cbSomenteNaoPago').prop('checked');
        // result.preco_cor_tam = $('#cbPrecoCorTam').prop('checked');
        result.somente_sem_valores = $('#cbSomenteSemValores').prop('checked');
        result.insere_valor_manual = $('#cbValorManual').prop('checked');
        result.ordenacao = $('input[name="rdOrdem"]:checked').val();

        return result;
    }

    async function buscaDados() {
        try {
            const filtros = await retornaFiltros();

            let response = await requisicao("GET", `/Sisplan/recalculoof/V1/buscadados?`, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`);

            if (!response) {
                return;
            }

            let json = await response.json();
            if (response.status != 200) {
                msgErro(json.mensagem);
                return;
            }

            criaTabelaPreco(json);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    function criaTabelaPreco(info) {
        if ($.fn.DataTable.isDataTable('#tabelaRecalculo')) {
            $('#tabelaRecalculo').DataTable().destroy();
            $('#tabelaRecalculo').empty();
        }

        function carregaInput(valor, indices) {
            try {

                switch (indices.col) {
                    case 11: {
                        return `<input type="text" id="txtCustoRec_${indices.row}"
                                class="input-default focus form-control text-right apenasFloat controleCusto"
                                style="width: 15ch" placeholder="0" value="${valor}">`;
                    }
                    case 17: {
                        return `<input type="text" id="txtValorRec_${indices.row}"
                                class="input-default focus form-control text-right apenasFloat"
                                style="width: 15ch" placeholder="0" value="${valor}">`;
                    }
                    case 40: {
                        return `<input type="text" id="txtMaquinaRec_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 20ch" placeholder="Máquina" value="${valor}">`;
                    }
                    default:
                        break;
                }
            } catch (e) {
                msgErro(`Não foi possível carregar os dados: ${e}`);
                console.log(e);
            }
        }

        const cols = [{
            data: 'CODCLI',
            title: 'Codcli'
        },
        {
            data: 'NOME',
            title: 'Nome'
        },
        {
            data: 'CODIGO',
            title: 'Código'
        },
        {
            data: 'DESC_PRODUTO',
            title: 'Descrição'
        },
        {
            data: 'COR',
            title: 'Cor'
        },
        {
            data: 'DT_S',
            title: 'Data saída'
        },
        {
            data: 'NUMERO',
            title: 'Número'
        },
        {
            data: 'OP',
            title: 'Setor'
        },
        {
            data: 'DESC_SETOR',
            title: 'Desc. Setor'
        },
        {
            data: 'PARTE',
            title: 'Parte'
        },
        {
            data: 'DESC_PARTE',
            title: 'Desc. Parte'
        },
        {
            data: 'CUSTO',
            title: 'Custo'
        },
        {
            data: 'QUANT',
            title: 'Qtde'
        },
        {
            data: 'QT_ORIG',
            title: 'Qtde Orig'
        },
        {
            data: 'QUANT_2',
            title: 'Qtde 2ª'
        },
        {
            data: 'QUANT_I',
            title: 'Qtde Incompletas'
        },
        {
            data: 'TAM',
            title: 'Tam'
        },
        {
            data: 'VALOR',
            title: 'Valor'
        },
        {
            data: 'IDENT',
            title: 'Ident'
        },
        {
            data: 'MOV',
            title: 'Mov'
        },
        {
            data: 'UNIDADE',
            title: 'Unidade'
        },
        {
            data: 'TAB_NUMERO',
            title: 'Número Tab'
        },
        {
            data: 'TAB_PRECO',
            title: 'Preço Tab'
        },
        {
            data: 'TABPRECO_PRECO',
            title: 'Preço Tab Preço'
        },
        {
            data: 'UNITARIO',
            title: 'Unitário'
        },
        {
            data: 'PRECO',
            title: 'Preço'
        },
        {
            data: 'TOTAL',
            title: 'Total'
        },
        {
            data: 'MOV_ANT',
            title: 'Mov Ant'
        },
        {
            data: 'LANCTO',
            title: 'Lancto'
        },
        {
            data: 'FAC_LANCTO',
            title: 'Fac Lancto'
        },
        {
            data: 'CUSTO_ATUAL',
            title: 'Custo Atual'
        },
        {
            data: 'CUSTO_NOVO',
            title: 'Custo Novo'
        },
        {
            data: 'PERC',
            title: 'Perc'
        },
        {
            data: 'CUSTO_REAL',
            title: 'Custo Real'
        },
        {
            data: 'PERC_PONT',
            title: 'Perc Pont'
        },
        {
            data: 'PERC_QUAL',
            title: 'Perc Qual'
        },
        {
            data: 'PERC_100',
            title: 'Perc 100'
        },
        {
            data: 'CODCLI_ANT',
            title: 'Codcli Ant'
        },
        {
            data: 'PRECO_SETOR',
            title: 'Preço Setor'
        },
        {
            data: 'PRECO_BONIFICACAO',
            title: 'Preço Bonificação'
        },
        {
            data: 'MAQUINA',
            title: 'Máquina'
        },
        ]

        $("#tabelaRecalculo").DataTable({
            order: false,
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: false,
            autoWidth: true,
            data: info,
            columns: cols,
            columnDefs: [
                {
                    targets: [17, 40],
                    render: function (data, v2, v3, index) {
                        return carregaInput(data, index);
                    }
                },
                {
                    targets: [11, 22, 23, 24, 25, 26, 30, 31, 32, 33, 34, 35, 36, 38, 39],
                    render: function (data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                    className: 'text-right'
                },
                {
                    type: "date-br",
                    render(data) {
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                    targets: [5],
                },
            ],
        });
        adicionaMascaraCampos();

        if ($('#cbValorManual').prop('checked')) {
            $('.controleCusto').prop('disabled', false);
        } else {
            $('.controleCusto').prop('disabled', true);
        }

        if ($('#tabelaRecalculo').DataTable().data().toArray().length > 0) {
            $('.btn-custos').prop('disabled', false);
        } else {
            $('.btn-custos').prop('disabled', true);
        }
    }

    $('#btnCustoAtual').on('click', async function (e) {
        e.preventDefault();
        $.LoadingOverlay('show');
        try {
            await atualizaCustoAtual();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function atualizaCustoAtual() {
        try {
            const filtros = await retornaFiltros();
            const dados = retornaDataTabela();

            let response = await requisicao("POST", `/Sisplan/recalculoof/V1/atualizacustoatual?`, '', `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&DADOS=${encodeURIComponent(JSON.stringify(dados))}`);

            if (!response) {
                return;
            }

            let json = await response.json();
            if (response.status != 200) {
                msgErro(json.mensagem);
                return;
            }

            criaTabelaPreco(json.DADOS);

            if (json.CUSTO_VAZIO) {
                msgErro('Existe um ou mais registros sem o custo atual informado. Esses não foram atualizados.');
            }
        } catch (e) {
            msgErro(`Não foi possível atualizar o custo: ${e}`);
            console.log(e);
        }
    }

    $('#btnCustoNovo').on('click', async function (e) {
        e.preventDefault();
        $.LoadingOverlay('show');
        try {
            await atualizaCustoNovo();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function atualizaCustoNovo() {
        try {
            const filtros = await retornaFiltros();
            const dados = retornaDataTabela();

            let response = await requisicao("POST", `/Sisplan/recalculoof/V1/atualizacustonovo?`, '', `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&DADOS=${encodeURIComponent(JSON.stringify(dados))}`);

            if (!response) {
                return;
            }

            let json = await response.json();
            if (response.status != 200) {
                msgErro(json.mensagem);
                return;
            }

            criaTabelaPreco(json.DADOS);

            if (json.CUSTO_VAZIO) {
                msgErro('Existe um ou mais registros sem o custo novo informado. Esses não foram atualizados.');
            }
        } catch (e) {
            msgErro(`Não foi possível atualizar o custo: ${e}`);
            console.log(e);
        }
    }

    function retornaDataTabela() {
        const result = $('#tabelaRecalculo').DataTable().data().toArray().map(function (e, i) {
            return {
                CODCLI: e.CODCLI,
                CODIGO: e.CODIGO,
                COR: e.COR,
                DT_S: e.DT_S,
                NUMERO: e.NUMERO,
                OP: e.OP,
                PARTE: e.PARTE,
                DESC_PARTE: e.DESC_PARTE,
                CUSTO: e.CUSTO,
                QUANT: e.QUANT,
                QT_ORIG: e.QT_ORIG,
                QUANT_2: e.QUANT_2,
                QUANT_I: e.QUANT_I,
                TAM: e.TAM,
                VALOR: parseFloat(parseFloat($(`#txtValorRec_${i}`).val()).toFixed(2)),
                IDENT: e.IDENT,
                MOV: e.MOV,
                DESC_SETOR: e.DESC_SETOR,
                DESC_PRODUTO: e.DESC_PRODUTO,
                UNIDADE: e.UNIDADE,
                NOME: e.NOME,
                TAB_NUMERO: e.TAB_NUMERO,
                TAB_PRECO: e.TAB_PRECO,
                TABPRECO_PRECO: e.TABPRECO_PRECO,
                UNITARIO: e.UNITARIO,
                PRECO: e.PRECO,
                TOTAL: e.TOTAL,
                MOV_ANT: e.MOV_ANT,
                LANCTO: e.LANCTO,
                FAC_LANCTO: e.FAC_LANCTO,
                CUSTO_ATUAL: e.CUSTO_ATUAL,
                CUSTO_NOVO: e.CUSTO_NOVO,
                PERC: e.PERC,
                CUSTO_REAL: e.CUSTO_REAL,
                PERC_PONT: e.PERC_PONT,
                PERC_QUAL: e.PERC_QUAL,
                PERC_100: e.PERC_100,
                CODCLI_ANT: e.CODCLI_ANT,
                PRECO_SETOR: e.PRECO_SETOR,
                PRECO_BONIFICACAO: e.PRECO_BONIFICACAO,
                MAQUINA: $(`#txtMaquinaRec_${i}`).val(),
            }
        });
        return result;
    }

    $('#btnGravar').on('click', async function (e) {
        e.preventDefault();
        $.LoadingOverlay('show');
        try {
            const data = retornaDataTabela();
            if (data.length == 0) {
                msgErro(`Não há informações a serem gravadas. Impossível continuar.`);
                return;
            }

            msgAlerta('Deseja gravar os dados?', () => { }, () => { }, async () => {
                $.LoadingOverlay('show');
                await gravaDados(data);
                $.LoadingOverlay('hide');
            });
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function gravaDados(data) {
        try {
            const filtros = await retornaFiltros();

            let response = await requisicao("POST", `/Sisplan/recalculoof/V1/gravadados?`, '', `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&DADOS=${encodeURIComponent(JSON.stringify(data))}`);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                let json = await response.json();
                msgErro(json.mensagem);
                return;
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 1500,
                fadeOut: 1000,
                async onHidden() {
                    $.LoadingOverlay('show');
                    await buscaDados();
                    $.LoadingOverlay('hide');
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e}`);
        }
    }

});