<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Recibo</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.255.7.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.255.7.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.255.7.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.255.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.255.7.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.255.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.255.7.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.255.7.1">
  <style>
    .bordaRadio {
      border: 2px solid #e0e4e6;
      border-radius: 4px;
      height: 38px;
      padding-right: 50px;
    }

    .fa-print:before {
      color: white;
    }

    .table.dataTable thead th {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .table.dataTable tbody td {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    #verticalLine {
      border-right: 1px solid white;
    }

    #tabelaEmissao_length {
      display: none;
    }

    #tabelaEmissao_filter {
      display: none;
    }

    #tabelaEmissao_info {
      display: none;
    }

    #tabelaEmissao_paginate {
      display: none;
    }

    #tabelaEmissao_empty {
      display: none;
    }

    .table.dataTable tbody td {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Impressão de Recibo</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
 
            </div>
          </div>
          <div class="row card pt-2">
            <div class="col-12">
              <div class="row pt-2">
                <div class="col-12">
                  <div class="buttons">
                    <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-search"></span>  Filtros</button>
                    <button class="btn btn-primary btn-sisp" id="btnEmissao" type="button"><span class="fas fa-file-invoice"></span>  Emissão</button>
                    <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i>  Imprimir</button>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 table-responsive card-body">
                <table id="tabelaItens" class="table table-responsive-sm table-select table-hover" width="100%">
                  <thead>
                    <tr>
                      <th class="th-sm">NUM. AP</th>
                      <th class="th-sm">VALOR</th>
                      <th class="th-sm">VALOR PAGO</th>
                      <th class="th-sm">NOME</th>
                      <th class="th-sm">OBS</th>
                      <th class="th-sm">DOCTO</th>
                      <th class="th-sm">CNPJ</th>
                      <th class="th-sm">DT_VEN</th>
                      <th class="th-sm">TIPO</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-emissao" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Emissão
            <label style="font-size: 70%" class="container escondeRadio mr-0">
              <input type="radio" checked="checked" id="radioReceber" name="radiopagto">
              <span class="checkmark"></span>
              Receber</label>
            <label style="font-size: 70%;" class="container escondeRadio">
              <input type="radio" id="radioPagar" name="radiopagto">
              <span class="checkmark"></span>
              Pagar</label>
          </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pt-0">
          <div class="row">
            <div class="col-sm-4">
              <div class="row">

                <div class="col-sm-12">
                  <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtNumero">Número:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNumero" name="txtNumero" class="form-control" placeholder="Número">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNumero" name="btnNumero" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaNumero" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-sm-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtLancamento">Lançamento:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtLancamento" name="txtLancamento" class="form-control" placeholder="Lançamento">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnLancamento" name="btnLancamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaLancamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-sm-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtPagoPor">Pago Por:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtPagoPor" name="txtPagoPor" class="form-control" placeholder="Pago Por">
                  </div>
                </div>

                <div class="col-sm-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtPagoPara">Pago Para:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtPagoPara" name="txtPagoPara" class="form-control" placeholder="Pago Para">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnPagoPara" name="btnPagoPara" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaPagoPara" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-sm-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtDocumento">Documento:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtDocumento" name="txtDocumento" class="form-control" placeholder="Documento">
                  </div>
                </div>

                <div class="col-sm-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtValor">Valor:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" value="0.0" id="txtValor" name="txtValor" class="form-control">
                  </div>
                </div>

                <div class="col-sm-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="dtData">Data:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtData" name="dtData" class="form-control">
                  </div>
                </div>

                <div class="col-sm-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="dtContrato">Data Contrato:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtContrato" name="dtContrato" class="form-control">
                  </div>
                </div>

                <div class="col-sm-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtReferencia">Referência:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtReferencia" name="txtReferencia" class="form-control" placeholder="Referência">
                  </div>
                </div>

                <div class="col-13 mt-3 pl-1">
                  <button style="width:30%;" type="button" id="btnAdicionar" class="btn bg-gradient-success btn-sisp">Adicionar</button>
                  <button style="width:30%;" type="button" id="btnLimpaCampos" class="btn btn-primary btn-sisp">Limpar</button>
                  <button style="width:30%;" type="button" id="btnImprimirEmissao" class="btn btn-sisp btn-danger">Imprimir</button>
                </div>

              </div>
            </div>
            <div class="col-sm-8">
              <label>Recibos</label>
              <div class="table-responsive">
                <table width="100%" style="width:100%" id="tabelaEmissao" class="table table-sm table-select table-hover table-condensed">
                  <thead>
                    <tr>
                      <th class="th-sm">Ações</th>
                      <th class="th-sm">NUM_AP</th>
                      <th class="th-sm">VALOR</th>
                      <th class="th-sm">VAL_PAGTO</th>
                      <th class="th-sm">VAL_ABERTO</th>
                      <th class="th-sm">NOME</th>
                      <th class="th-sm">OBS</th>
                      <th class="th-sm">DOCTO</th>
                      <th class="th-sm">CPF/CNPJ</th>
                      <th class="th-sm">EMPRESA</th>
                      <th class="th-sm">DT_VEN</th>
                      <th class="th-sm">DUPLI</th>
                      <th class="th-sm">DT_PAGTO</th>
                      <th class="th-sm">OBS_BAIXA</th>
                      <th class="th-sm">NR_CARTEIRA</th>
                      <th class="th-sm">SERIE</th>
                      <th class="th-sm">DT_CONTR</th>
                      <th class="th-sm">TIPO</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Consulta
            <label style="font-size: 70%;" class="form-check-label ml-4 pl-4" class="container escondeRadio">
              <input class="form-check-input" type="checkbox" id="check_todos" name="check_todos">
              <span class="checkmark"></span>
              Marcar/Desmarcar Todos</label>
          </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="row">
            <div class="group-default form-group col-3">
              <label for="txtDataEmiDe">Emissão De/ Até: </label>
              <div class="input-group">
                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEmiDe" name="DataDe">
                <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEmiAte" name="DataDe">
              </div>
            </div>
            <div class="group-default form-group col-3">
              <label for="txtDataVencimentoDe">Vencimento De/ Até: </label>
              <div class="input-group">
                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataVencimentoDe" name="DataDe">
                <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataVencimentoAte" name="DataDe">
              </div>
            </div>
            <div class="group-default form-group col-3">
              <label for="txtDataPagamentoDe">Pagamento De/ Até: </label>
              <div class="input-group">
                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataPagamentoDe" name="DataDe">
                <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataPagamentoAte" name="DataDe">
              </div>
            </div>
            <div class="group-default form-group col-3">
              <label data-error="wrong" data-success="right" for="bordaRadio">Número AP De/ Até:</label>
              <div class="input-group">
                <input type="text" class="input-default col-12 focus form-control" id="txtNumeroDe" name="txtNumeroDe" class="form-control" placeholder="Número">
                <input type="text" class="input-default col-12 focus form-control" id="txtNumeroAte" name="txtNumeroAte" class="form-control" placeholder="Número">
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-6">
              <label data-error="wrong" data-success="right" for="txtFornecedor">Fornec./Cliente: </label>
              <div class="input-group">
                <input type="text" class="input-default col-12 focus form-control" id="txtFornecedor" name="txtFornecedor" class="form-control" placeholder="Fornec./Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Fornecedor" name="btn-Fornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Fornecedor" name="btn-limpa-Fornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-3">
              <label data-error="wrong" data-success="right" for="txtClasseGer">Classe Gerencial: </label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" class="form-control" placeholder="Classe Gerencial">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-ClasseGer" name="btn-ClasseGer" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-ClasseGer" name="btn-limpa-ClasseGer" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-3">
              <label data-error="wrong" data-success="right" for="txtNotaFiscal">Nota Fiscal: </label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNotaFiscal" name="txtNotaFiscal" class="form-control" placeholder="Nota Fiscal">
              </div>
            </div>
          </div>
          <div class="row d-flex">
            <div class="col-3">
              <label>Situação:</label>
              <div class="relative">
                <select name="" id="txtSituacao" value="" class="form-group input-default">
                  <option value="">Todos</option>
                  <option value="A">Aberto</option>
                  <option value="P">Pagas</option>
                </select>
              </div>
            </div>
            <div class="col-3">
              <label for="">Buscar:</label>
              <div class="relative">
                <select name="" id="txtBuscar" value="" class="form-group input-default">
                  <option value="P">Pagar</option>
                  <option value="R">Receber</option>
                </select>
              </div>
            </div>
            <div class="col-3 mt-4 ml-auto">
              <div class="form-group mt-1 mr-2">
                <div class="row justify-content-end">
                  <button class="btn float-right btn-primary btn-sisp" id="btnConsultarVarios"><span class="fas fa-search"></span>Consultar</button>
                </div>
              </div>
            </div>
          </div>
          <div class="col-sm-12 table-responsive card-body">
            <table id="tabelaItensConsulta" class="table table-responsive-sm table-select table-hover" width="100%">
              <thead>
                <tr>
                  <th class="th-sm">SEL</th>
                  <th class="th-sm">NUM. AP</th>
                  <th class="th-sm">VALOR</th>
                  <th class="th-sm">VALOR PAGO</th>
                  <th class="th-sm">NOME</th>
                  <th class="th-sm">OBS</th>
                  <th class="th-sm">DOCTO</th>
                  <th class="th-sm">CNPJ</th>
                  <th class="th-sm">DT_VEN</th>
                  <th class="th-sm">TIPO</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <button id="btnConfirmar" class='btn btn-danger btn-sisp' type='button'>Confirmar </button>
          </div>
        </div>
      </div>
    </div>
  </div>
  </div>
  <?php
  include_once('../../modais.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.255.7.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.255.7.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.255.7.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.255.7.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.255.7.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.255.7.1"></script>
  <script src="dist/js/sisplan.js?versao=3.255.7.1"></script>
  <script src="utils/funcoes.js?versao=3.255.7.1"></script>
  <script src="utils/cookies.js?versao=3.255.7.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.255.7.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.255.7.1"></script>
  <script src="dist/js/driver.min.js?versao=3.255.7.1"></script>
  <script src="dist/js/jquery.inputmask.js"></script>
  <script src="dist/js/jquery.mask.min.js?versao=3.255.7.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.255.7.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.255.7.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.255.7.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.255.7.1"></script>
  <script type="text/javascript" src="config.js?versao=3.255.7.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.255.7.1"></script>
  <script src="dist/js/jquery.inputmask.js?versao=3.255.7.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RECIBO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/recibo/recibo.js?versao=3.255.7.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>