$(document).ready(async function () {
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  let listaOrdenacao = ['ESTOQUE_ATUAL DESC'];
  let grafico;

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relEstoqueComercial == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueComercial: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueComercial: novasColunas }))

      $('#tabelaRelEstoqueComercial').DataTable().columns().visible(true);
      // $('#tabelaRelEstoqueComercial').DataTable().columns(novasColunas).visible(false);

      $('#tabelaRelEstoqueComercial').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  await preencheOrdenacaoTela('EstoqueComercial');

  componenteFiltro('produto', true);
  componenteFiltro('material', true);
  componenteFiltro('cor', true);
  componenteFiltro('grupo', true);
  componenteFiltro('colecao', true);
  componenteFiltro('etiqueta', true);
  componenteFiltro('linha', true);
  componenteFiltro('deposito', true);
  componenteFiltro('modelo', true);
  componenteFiltro('marca', true);
  limparFiltros(true);

  retornaHintRelatorio('btnImprimir', 'EstoqueComercialResumido')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if (($('#txtDias').val() == '') || ($('#txtDias').val() < 0)) {
          msgAlerta('Tempo de Vida Util vazio ou menor que zero, impossível continuar!');
          return;
        }
        let url = `/sisplan/impressao/v1/estoquecomercial?`;

        const params = await retornaFiltros();

        let arquivo = await GeraRelatorio(`${url + params}&ORDERBY=${listaOrdenacao.toString()}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros() {
    const pesquisaProduto = $("#radioProduto").prop("checked");
    const filtros = {
      dias: $('#txtDias').val(),
      tipo_cons: $('input[name="tipoConsulta"]:checked').val(),
      empresas: $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')],
      produto: pesquisaProduto ? await formataListas($('#txtProduto').val().toString()) : await formataListas($('#txtMaterial').val().toString()),
      cor: await formataListas($('#txtCor').val().toString()),
      grupo: await formataListas($('#txtGrupo').val().toString()),
      colecao: await formataListas($('#txtColecao').val().toString()),
      etiqueta: await formataListas($('#txtEtiqueta').val().toString()),
      linha: await formataListas($('#txtLinha').val().toString()),
      deposito: await formataListas($('#txtDeposito').val().toString()),
      ordemImpressao: $('#txtOrdem').val(),
      modelo: await formataListas($('#txtModelo').val().toString()),
      marca: await formataListas($('#txtMarca').val().toString()),
      tipoItem: pesquisaProduto ? "PRODUTO" : "MATERIAL"
    }

    return `DIAS=${filtros.dias}&GRUPO=${filtros.grupo}&ETIQUETA=${filtros.etiqueta}&LINHA=${filtros.linha}&COLECAO=${filtros.colecao}
            &EMPRESAS_FILTRO=${filtros.empresas}&DEPOSITO=${filtros.deposito}&COR=${filtros.cor}&TIPO_CONS=${filtros.tipo_cons}
            &PRODUTO=${filtros.produto}&ORDEM_IMPRESSAO=${filtros.ordemImpressao}&MODELO=${filtros.modelo}&MARCA=${filtros.marca}
            &TIPO_ITEM=${filtros.tipoItem}`;
  }

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($("#txtOrdem option").toArray().length > 0) {
        retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
      }
      try {
        Graficos.limpaGrafico(['graficosRelEstoqueComercial']);
        if ($.fn.DataTable.isDataTable('#tabelaRelEstoqueComercial')) {
          $('#tabelaRelEstoqueComercial').DataTable().destroy();
          $('#tabelaRelEstoqueComercial').empty();
        };

        let dataSetCols = [];
        listaOrdenacao = ['ESTOQUE_ATUAL DESC'];
        const url = '/sisplan/impressao/v1/estoquecomercial?';
        if (($('#txtDias').val() == '') || ($('#txtDias').val() < 0)) {
          msgAlerta('Tempo de Vida Util vazio ou menor que zero, impossível continuar!');
          return;
        }

        const params = await retornaFiltros();

        const response = await requisicao('GET', url, params, null, 90000);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();

        if (jsonStr.length == 0) {
          if ($.fn.DataTable.isDataTable('#tabelaRelEstoqueComercial')) {
            $('#tabelaRelEstoqueComercial').DataTable().rows().remove().draw(false);
          }
          $("#chart").addClass("d-none");
          msgAlerta('Nenhum registro encontrado!');
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        const keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          if (k == 'DT_CADASTRO') {
            dataSetCols.push({
              'title': 'DT_ENTR_ESTOQUE',
              'data': k,
              'render': function (data) {
                if (data) {
                  return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                } else {
                  return '';
                }
              }
            });
          } else {
            dataSetCols.push({
              'title': k,
              'data': k
            });
          }
        });

        jQuery.extend(jQuery.fn.dataTableExt.oSort, {
          'date-br-pre': function (dateStr) {
            if (!dateStr) {
              return 0;
            }
            var dateParts = dateStr.split('/');
            return (dateParts[2] + dateParts[1] + dateParts[0]) * 1;
          },
          'date-br-asc': function (a, b) {
            return a - b;
          },
          'date-br-desc': function (a, b) {
            return b - a;
          }
        });

        $('#tabelaRelEstoqueComercial').DataTable({
          destroy: true,
          autoWidth: true,
          colReorder: true,
          data: jsonStr,
          columnDefs: [
            {
              targets: 8,
              render: function (data) {
                if (data != '' && data != null && data != undefined) {
                  let dateParts = data.split('-');
                  let day = dateParts[2];
                  let month = dateParts[1].padStart(2, '0');
                  let year = dateParts[0].padStart(2, '0');
                  return day + '/' + month + '/' + year;
                } else {
                  return '';
                }
              },
              type: 'date-br'
            },
            {
              "targets": 7,
              "className": 'pr-4 text-right'
            }
          ],
          order: [[7, 'desc']],
          columns: dataSetCols,
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        // adiciona o botão na tabela e adiciona a função de abrir o modal
        $('#tabelaRelEstoqueComercial_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelEstoqueComercial_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#tabelaRelEstoqueComercial th').on('click', function () {
          listaOrdenacao = adicionaOrdenacao(
            retornaDataSrcColuna($('#tabelaRelEstoqueComercial'), $(this)),
            listaOrdenacao
          );
        });

        $('#buttonExcel').on('click', async function () {
          if (($('#txtDias').val() == '') || ($('#txtDias').val() < 0)) {
            msgAlerta('Tempo de Vida Util vazio ou menor que zero, impossível continuar!');
            return;
          }
          const url = '/sisplan/impressao/v1/estoquecomercial?';
          const params = await retornaFiltros();
          await exportaCSV(url, params + `&ORDERBY=${listaOrdenacao.toString()}&`, false, null, 'Relatório Estoque Comercial', '#tabelaRelEstoqueComercial');
        })

        $('#tabelaRelEstoqueComercial').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relEstoqueComercial).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        criaGrafico(jsonStr, $('input[name="tipoConsulta"]:checked').val());
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  adicionarConteudoModal(
    'Estoque Comercial x Não Comercial', [
    {
      tipo: 'paragrafo',
      valor: 'Neste relatório ao considerar um período de vida útil do produto em dias (consideramos um padrão de 60 dias) ' +
        'é possível identificar referências (produtos) comerciais (válidos) e também não comerciais (vencidos/fora do prazo).'
    },
    {
      tipo: 'paragrafo',
      valor: 'Em resumo, quando comercial, significa que o produto está dentro do prazo de válidade (considerando também o estoque atual). ' +
        'Quando não comercial, significa que não teve movimento (giro) dentro do prazo informado.',
    },
    {
      tipo: 'paragrafo',
      valor:
        'O prazo é formado pela data do dia menos o valor do campo Tempo de Vida Útil. '

    },
    {
      tipo: 'paragrafo',
      valor:
        'O objetivo é determinar ações de giro antes de precisar programar um bazar ou aplicar promoções.'

    }
  ]
  );

  function criaGrafico(data, tipoGrafico) {
    let options;
    let totCom = 0;
    let totNaoCom = 0;
    let dataOptions;
    let categories;
    const pesquisaMaterial = $("#radioMaterial").prop("checked");
    const dados = [];

    data.map(item => {
      if (item.ANALISE == 'NAO COMERCIAL') {
        // totNaoCom += item.ESTOQUE_ATUAL
        dados.push({
          CATEGORIA: 'Estoque não comercial',
          VALOR: item.ESTOQUE_ATUAL
        })
      } else if (item.ANALISE == 'COMERCIAL') {
        // totCom += item.ESTOQUE_ATUAL
        dados.push({
          CATEGORIA: 'Estoque comercial',
          VALOR: item.ESTOQUE_ATUAL
        })
      }
    });

    let formatarValor = (value) => {
      return value;
    };

    if (pesquisaMaterial) {
      formatarValor = (value) => {
        return valor.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
      };
    }

    Graficos.criarGrafico({
      container: 'graficosRelEstoqueComercial',
      tipo: 'column',
      dados: dados,
      nomeSerie: 'Desempenho',
      colunasAgrupamento: ['CATEGORIA'],
      colunasValor: ['VALOR'],
      formatarValor,
      bHorizontal: true
    })

    // if (pesquisaMaterial) {
    //   totNaoCom = totNaoCom.toFixed(2);
    //   totCom = totCom.toFixed(2);
    // }

    // if (totCom == 0 && totNaoCom == 0) {
    //   $("#chart").addClass("d-none");
    //   return;
    // }

    // switch (tipoGrafico) {
    //   case "T": {
    //     dataOptions = [totCom, totNaoCom];
    //     categories = ['Estoque comercial', 'Estoque não comercial'];
    //     break;
    //   }
    //   case "C": {
    //     dataOptions = [totCom];
    //     categories = ['Estoque comercial'];
    //     break;
    //   }
    //   case "N": {
    //     dataOptions = [totNaoCom];
    //     categories = ['Estoque não comercial'];
    //     break;
    //   }
    //   default:
    //     break;
    // }

    // $("#chart").removeClass("d-none");
    // if (!grafico || !grafico.renderizado) {
    //   options = {
    //     series: [{
    //       name: "Quantidade",
    //       data: dataOptions
    //     }],
    //     chart: {
    //       id: "chart",
    //       type: 'bar',
    //       height: 200
    //     },
    //     plotOptions: {
    //       bar: {
    //         borderRadius: 4,
    //         horizontal: true,
    //       }
    //     },
    //     dataLabels: {
    //       enabled: false
    //     },
    //     xaxis: {
    //       categories: categories,
    //     },
    //     yaxis: {
    //       labels: {
    //         style: {
    //           fontSize: '12px',
    //         }
    //       },
    //     }
    //   };
    //   grafico = new ApexCharts(document.querySelector("#chart"), options);
    //   grafico.render().then(() => grafico.renderizado = true);
    // } else {
    //   ApexCharts.exec('chart', 'updateOptions', {
    //     xaxis: {
    //       categories: categories
    //     }
    //   }, false, true);
    //   ApexCharts.exec('chart', 'updateSeries', [{
    //     data: dataOptions
    //   }], true);
    // }

  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaRelEstoqueComercial').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.relEstoqueComercial ?? []);
  });

  $("#radioProduto, #radioMaterial").on("change", function () {
    const pesquisaProduto = $("#radioProduto").prop("checked");
    if (pesquisaProduto) {
      $("#ProdutoInfoTour").removeClass("d-none");
      $("#divMaterial").addClass("d-none");
      $("#ModeloInfoTour").removeClass("d-none");
    } else {
      $("#ProdutoInfoTour").addClass("d-none");
      $("#divMaterial").removeClass("d-none");
      $("#txtModelo").empty().trigger('change');
      $("#ModeloInfoTour").addClass("d-none");
    }

  });

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros padrões da tela.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para Imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaRelEstoqueComercial',
      popover: {
        title: 'Tabela',
        description: 'Aqui estão os dados dos produtos Filtrados.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });

});