$(document).ready(async function () {
    var ultimaColunaOrdenada = {
        nome: '',
        ordenacao: 'ASC'
    };

    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para Imprimir um relatório.',
                    position: 'right'
                }
            }
            ]);
            driver.start();
        });
    });

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relEstoqueMat == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueMat: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueMat: novasColunas }))

            $('#tabelaRelEstoqueMat').DataTable().columns().visible(true);

            $('#tabelaRelEstoqueMat').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    await preencheOrdenacaoTela('RelEstoqueMat');

    $('#txtOrdem').val('3');

    // const filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));

    const filtroDeposito = await buscaDepositoEmpresaUsuario();

    $('#tabRelEstoqueMat').on('click', function () {
        $('#divDepositosRelEstoque').addClass('d-none');
        $('#divRelEstoqueMat').removeClass('d-none');
    });

    $('#tabLotesDepositos').on('click', function () {
        $('#divDepositosRelEstoque').removeClass('d-none');
        $('#divRelEstoqueMat').addClass('d-none');
    });

    componenteFiltro('material', true);
    componenteFiltro('cor', true);
    componenteFiltro('depositoUsuario', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('colecao', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('subGrupo', true);
    componenteFiltro('composicaoMaterial', true);
    componenteFiltro('linha', true);
    componenteFiltro('lote', true);
    componenteFiltro('loteInterno', true);
    componenteFiltro('tabPreco', false)

    $("#cbTodosDepositos").on("change", function () {
        bTodosDepositos = $("#cbTodosDepositos").prop("checked");
        if (bTodosDepositos) {
            componenteFiltro('deposito', true, true, 'DepositoUsuario')
        } else {
            componenteFiltro('depositoUsuario', true, true, 'DepositoUsuario')
        }
    })

    // $('#txtLote').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO"]}`, 'LOTE', 'CODIGO');
    // $('#btnLote').pesquisa_serversideSel('#txtLote', `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO", "COR" ], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO", "COR"]}`, 'Pesquisa de Lote');

    // $('#txtLote').addClass('camposFiltros');
    // $('#btnLimpaLote').on('click', function () {
    //     $('#txtLote').empty().trigger('change')
    //     $('#txtLote').val('');
    //     $('#txtLote').attr('data-chave', '');
    //     $('#txtLote').attr('data-desc', '');
    // });

    // $('#txtLoteInterno').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":["LOTE_INTERNO", "CODIGO"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "CODIGO"]}`, 'LOTE_INTERNO', 'CODIGO');
    // $('#btnLoteInterno').pesquisa_serversideSel('#txtLoteInterno', `{ "tabela":"MAT_ITEN", "camposSelect":["LOTE_INTERNO", "CODIGO", "COR"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "CODIGO", "COR"]}`, 'Pesquisa Lote');

    // $('#txtLoteInterno').addClass('camposFiltros');
    // $('#btnLimpaLoteInterno').on('click', function () {
    //     $('#txtLoteInterno').empty().trigger('change')
    //     $('#txtLoteInterno').val('');
    //     $('#txtLoteInterno').attr('data-chave', '');
    //     $('#txtLoteInterno').attr('data-desc', '');
    // });

    $('#txtTonalidade').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'TONALIDADE', 'ATIVO');
    $('#btnTonalidade').pesquisa_serversideSel('#txtTonalidade', `{ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'Pesquisa de Tonalidade');

    $('#txtTonalidade').addClass('camposFiltros');
    $('#btnLimpaTonalidade').on('click', function () {
        $('#txtTonalidade').empty().trigger('change')
        $('#txtTonalidade').val('');
        $('#txtTonalidade').attr('data-chave', '');
        $('#txtTonalidade').attr('data-desc', '');
    });

    await carregaValoresPadroes();

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    async function carregaValoresPadroes() {
        const jsonStr = await buscaValoresPadroes('ESTOQUE')

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'DEPOSITO': {
                    if (item.VALOR != '') {
                        let descricao = await buscaValor('DEPOSITO', 'DESCRICAO', 'CODIGO', item.VALOR);
                        descricao = descricao != undefined ? descricao.DESCRICAO : 'VALOR INVÁLIDO';
                        adicionaValorPadraoVarios('depositoUsuario', item.VALOR, descricao);
                    }
                    break;
                }
                case 'QUALIDADE': {
                    if (item.VALOR != '') {
                        let descricao = await buscaValor('TABQUL', 'DESCRICAO', 'CODIGO', item.VALOR);
                        descricao = descricao != undefined ? descricao.DESCRICAO : 'VALOR INVÁLIDO';
                        adicionaValorPadraoVarios('qualidade', item.VALOR, descricao);
                    }
                    break;
                }
            }
        });
    };

    limparFiltros(true);

    retornaHintRelatorio('btnImprimir', 'estoque_material')

    $('#txtOrdem').on('change', function () {
        retornaHintRelatorio('btnImprimir', $("#txtOrdem option")
            .toArray()
            .map(map => {
                return [map.selected, $(map)
                    .attr('nome_prt')]
            })
            .filter(filter => filter[0] == true)[0][1])
    })

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/estoque?`;

                const item = 'M';

                const filtros = await retornaFiltros();
                const params = `CODIGO=${filtros.codigo}` +
                    `&DEPOSITO=${filtros.deposito}` +
                    `&LOTE=${filtros.lote}` +
                    `&LOTE_INTERNO=${filtros.loteInterno}` +
                    `&TONALIDADE=${filtros.tonalidade}` +
                    `&LINHA=${filtros.linha}` +
                    `&FABRICACAODE=${filtros.fabricacaoDe}` +
                    `&FABRICACAOATE=${filtros.fabricacaoAte}` +
                    `&COR=${filtros.cor}` +
                    `&COLECAO=${filtros.colecao}` +
                    `&GRUPO=${filtros.grupo}` +
                    `&QUALIDADE=${filtros.qualidade}` +
                    `&TIPOITEM=${item}` +
                    `&CONTEMESTOQUE=${$('#cbContemEstoque').prop('checked')}` +
                    `&DIFERENCA_QUANTIDADE=${$('#cbDiferencaQuantidade').prop('checked')}` +
                    `&SUBGRUPO=${filtros.subGrupo}` +
                    `&TABPRECO=${filtros.tabelaPreco}`
                const ordem = `&TELA_ORDENACAO=RelEstoqueMat&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstoqueMat');
                let arquivo = await GeraRelatorio(`${url}${params}${ordem}`, 'GET', 1000000, false, 'RelEstoqueMat');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function retornaFiltros() {

        let dep = await formataListas($('#txtDepositoUsuario').val().toString());

        if (dep == '' && !$("#cbTodosDepositos").prop("checked")) {
            dep = filtroDeposito;
        }

        const filtros = {
            tipoItem: 'MATERIAL',
            tabelaEstoque: 'MAT_ITEN',
            campoQualidade: 'QUALIDADE',
            codigo: await formataListas($('#txtMaterial').val().toString()),
            cor: await formataListas($('#txtCor').val().toString()),
            colecao: await formataListas($('#txtColecao').val().toString()),
            grupo: await formataListas($('#txtGrupoMA').val().toString()),
            subGrupo: await formataListas($('#txtSubGrupo').val().toString()),
            qualidade: await formataListas($('#txtQualidade').val().toString()),
            lote: await formataListas($('#txtLote').val().toString()),
            composicao: await formataListas($('#txtComposicaoMaterial').val().toString()),
            loteInterno: await formataListas($('#txtLoteInterno').val().toString()),
            tonalidade: await formataListas($('#txtTonalidade').val().toString()),
            linha: await formataListas($('#txtLinha').val().toString()),
            fabricacaoDe: $('#dtFabricacaoDe').val(),
            fabricacaoAte: $('#dtFabricacaoAte').val(),
            deposito: dep,
            tabelaPreco: pegaChave('#txtTabPreco'),
        }

        return filtros;
    }

    async function montaPesquisa(colunaOrdenacao = '') {
        try {
            const tipoBanco = await retornaDatabase();
            let fFabricacaoDe = ''
            let fFabricacaoAte = ''

            const filtros = await retornaFiltros();
            const fCodigo = filtros.codigo != '' ? ` AND ${filtros.tabelaEstoque}.CODIGO IN (${filtros.codigo})` : '';
            const fCor = filtros.cor != '' ? ` AND ${filtros.tabelaEstoque}.COR IN (${filtros.cor})` : '';
            const fColecao = filtros.colecao != '' ? ` AND COLECAO.CODIGO IN (${filtros.colecao})` : '';
            const fGrupo = filtros.grupo != '' ? ` AND ${filtros.tipoItem}.GRUPO IN (${filtros.grupo})` : '';
            const fSubGrupo = filtros.subGrupo != '' ? ` AND ${filtros.tipoItem}.SUB_GRUPO IN (${filtros.subGrupo})` : '';
            const fQualidade = filtros.qualidade != '' ? ` AND ${filtros.tabelaEstoque}.QUALIDADE IN (${filtros.qualidade})` : '';
            const fDeposito = filtros.deposito != '' ? ` AND ${filtros.tabelaEstoque}.DEPOSITO IN (${filtros.deposito})` : '';
            const fComposicao = filtros.composicao != '' ? ` AND MATERIAL.COMPOSICAO IN (${filtros.composicao})` : '';
            const fLote = filtros.lote != '' ? ` AND MAT_ITEN.LOTE IN (${filtros.lote})` : '';
            const fLoteInterno = filtros.loteInterno != '' ? ` AND MAT_ITEN.LOTE_INTERNO IN (${filtros.loteInterno})` : '';
            const fTonalidade = filtros.tonalidade != '' ? ` AND MAT_ITEN.TONALIDADE IN (${filtros.tonalidade})` : '';
            const fLinha = filtros.linha != '' ? ` AND MATERIAL.LINHA IN (${filtros.linha})` : '';
            if (tipoBanco == 'ORACLE') {
                fFabricacaoDe = filtros.fabricacaoDe != '' ? ` AND MAT_ITEN.DT_FAB >= TO_TIMESTAMP('${filtros.fabricacaoDe} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` : '';
                fFabricacaoAte = filtros.fabricacaoAte != '' ? ` AND MAT_ITEN.DT_FAB <= TO_TIMESTAMP('${filtros.fabricacaoAte} 23:59:59', 'YYYY-MM-DD HH24:MI:SS')` : '';
            } else {
                fFabricacaoDe = filtros.fabricacaoDe != '' ? ` AND MAT_ITEN.DT_FAB >= '${filtros.fabricacaoDe}'` : '';
                fFabricacaoAte = filtros.fabricacaoAte != '' ? ` AND MAT_ITEN.DT_FAB <= '${filtros.fabricacaoAte}'` : '';
            }

            const ordemOrdenacao = $('#txtOrdem').val();
            let orderBy = colunaOrdenacao == '' ? await retornaOrderBy(ordemOrdenacao) : colunaOrdenacao;
            let somenteEstoque = '';

            somenteEstoque = $('#cbContemEstoque').prop('checked') == true ? ` AND ${filtros.tabelaEstoque}.QTDE > 0 ` : '';
            diferencaQuantidade = $('#cbDiferencaQuantidade').prop('checked') == true ? ` AND ${filtros.tabelaEstoque}.QTDE <> ${filtros.tabelaEstoque}.QTDE_ORIG ` : '';

            let camposSelect = '';
            let cols = [];

            camposSelect = [
                "MAT_ITEN.ID",
                "MAT_ITEN.CODIGO",
                "MATERIAL.CODIGO2",
                "MATERIAL.DESCRICAO AS DESCRICAO",
                "MAT_ITEN.COR",
                "CADCOR.DESCRICAO DESCCOR",
                "COLECAO.CODIGO CODCOLECAO",
                "COLECAO.DESCRICAO DESCCOLECAO",
                "MAT_ITEN.DEPOSITO",
                "DEPOSITO.DESCRICAO DESCDEPOSITO",
                "MAT_ITEN.LOTE",
                "MAT_ITEN.LOTE_ORIG",
                "MAT_ITEN.QTDE AS QUANTIDADE",
                "MAT_ITEN.QTDE_ORIG",
                "MAT_ITEN.BARRA",
                "0 AS TAM",
                "MATERIAL.UNIDADE",
                "MATERIAL.SUB_GRUPO",
                "MATERIAL.UNI_AUX",
                "MATERIAL.RENDIMENTO",
                "MAT_ITEN.QUALIDADE",
                "TABQUL.DESCRICAO DESCQUALIDADE",
                "MAT_ITEN.TONALIDADE",
                "MAT_ITEN.DT_FAB",
                "TABPRECO.PRECO_00",
                "TABPRECO.REGIAO",
                "MAT_ITEN.PRECO_MED"
            ];
            cols = [
                "ID",
                "CODIGO",
                "CODIGO2",
                "DESCRICAO",
                "COR",
                "DESCCOR",
                "CODCOLECAO",
                "DESCCOLECAO",
                "DEPOSITO",
                "DESCDEPOSITO",
                "LOTE",
                "LOTE_ORIG",
                "QUANTIDADE",
                "QTDE_ORIG",
                "BARRA",
                "TAM",
                "UNIDADE",
                "SUB_GRUPO",
                "UNI_AUX",
                "RENDIMENTO",
                "QUALIDADE",
                "DESCQUALIDADE",
                "TONALIDADE",
                "DT_FABRICACAO",
                "PRECO_00",
                "REGIAO",
                "PRECO_MED"
            ];

            const ligacaoTabelaCor = { "tabela": "CADCOR", "condicao": `CADCOR.COR = ${filtros.tabelaEstoque}.COR` };

            const ligacaoProdutoMaterial = { "tabela": `${filtros.tipoItem}`, "condicao": `${filtros.tipoItem}.CODIGO = ${filtros.tabelaEstoque}.CODIGO` };

            const ligacaoColecao = { "tabela": "COLECAO", "condicao": `COLECAO.CODIGO = ${filtros.tipoItem}.COLECAO` };

            const ligacaoQualidade = { "tabela": "TABQUL", "condicao": `TABQUL.CODIGO = ${filtros.tabelaEstoque}.${filtros.campoQualidade}` };

            const ligacaoDeposito = { "tabela": "DEPOSITO", "condicao": `DEPOSITO.CODIGO = ${filtros.tabelaEstoque}.DEPOSITO` };

            const ligacaoTabelaPreco = { tabela: "TABPRECO", condicao: `'${filtros.tabelaPreco}' = TABPRECO.REGIAO AND ${filtros.tabelaEstoque}.CODIGO = TABPRECO.CODIGO` }

            const pesquisa = {
                tabela: filtros.tabelaEstoque,
                camposSelect: camposSelect,
                leftjoin: [ligacaoTabelaCor, ligacaoProdutoMaterial, ligacaoColecao, ligacaoQualidade, ligacaoDeposito, ligacaoTabelaPreco],
                where: [`1=1 ${fCodigo} ${fDeposito} ${fCor} ${fColecao} ${fGrupo} ${fQualidade} ${fComposicao} ${somenteEstoque} ${fSubGrupo} ${fLote} ${fLoteInterno} ${fTonalidade} ${fLinha} ${fFabricacaoDe} ${fFabricacaoAte} ${diferencaQuantidade}`],
                orderby: [orderBy]
            }

            return {
                pesquisa: pesquisa,
                colunas: cols
            }
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    async function buscaDados(colunaOrdenacao = '') {
        if ($.fn.DataTable.isDataTable('#tabelaRelEstoqueMat')) {
            $("#tabelaRelEstoqueMat").DataTable().destroy();
            $("#tabelaRelEstoqueMat").empty();
        }

        ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
        ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

        $.LoadingOverlay("show");

        try {
            try {
                await buscaDepositos();

                const pesquisa = await montaPesquisa(colunaOrdenacao);
                let dataSetCols = [];

                const campoDireita = [];
                for (let i = 0; i < pesquisa.colunas.length; i++) {
                    dataSetCols.push({
                        'title': pesquisa.colunas[i],
                        'data': pesquisa.colunas[i]
                    });
                    if (['QUANTIDADE', 'QTDE_ORIG', 'RENDIMENTO', 'PRECO_MED'].includes(pesquisa.colunas[i])) {
                        campoDireita.push(i);
                    }
                }

                // const ajaxData = {
                //     "EMPRESA": getCookie('empresa'),
                //     "JSON": `{"tabela":"${tabelaEstoque}", 
                //       "camposSelect": ${camposSelect}, 
                //       "leftJoin": [${ligacaoTabelaCor},${ligacaoProdutoMaterial},${ligacaoColecao},${ligacaoQualidade}], 
                //       "where": ["1=1 ${sCodigo} ${sDeposito} ${sCor} ${sColecao} ${sGrupo} ${sQualidade} ${somenteEstoque} ${sSubGrupo}"],
                //       "orderby": ["${orderBy}"]  
                //     }`,
                //     "CLIENTE": 'N',
                // };

                $('#tabelaRelEstoqueMat').DataTable({
                    paging: true,
                    colReorder: true,
                    lengthChange: true, // habilita o select para mudar a quantidade de itens por página
                    lengthMenu: [10, 25, 50, 100], // opções disponíveis no select
                    pageLength: 10,
                    filter: false,
                    info: true,
                    order: true,
                    autoWidth: true,
                    destroy: true,
                    serverSide: true,
                    processing: true,
                    ajax: {
                        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                        type: "POST",
                        headers: {
                            'Authorization': BASIC_AUTH
                        },
                        data: {
                            EMPRESA: getCookie('empresa'),
                            JSON: JSON.stringify(pesquisa.pesquisa),
                            CLIENTE: 'N',
                        },
                        dataSrc: function (data) {
                            const cols = pesquisa.colunas;
                            const array = data.data;
                            return array.map(row => {
                                return row.reduce((obj, value, index) => {
                                    obj[cols[index]] = value;
                                    return obj;
                                }, {});
                            });
                        }
                    },
                    columns: dataSetCols,
                    columnDefs: [
                        {
                            "targets": campoDireita,
                            "className": 'pr-4 text-right'
                        }
                    ]
                });

                const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

                $('#tabelaRelEstoqueMat_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaRelEstoqueMat_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const url = '/Sisplan/Funcoes/v1/pesquisa?';
                    const pesquisa = await montaPesquisa();
                    const dados = $("#tabelaRelEstoqueMat").DataTable().data().toArray();
                    dados.forEach(obj => {
                        obj.ID_1 = obj.ID;
                        delete obj.ID;
                    });

                    await exportaCSV(
                        url,
                        `JSON=${encodeURIComponent(JSON.stringify(pesquisa.pesquisa))}`,
                        false,
                        null,
                        'Relatório de Estoque de Material',
                        '',
                        '',
                        999,
                        false,
                        false,
                        dados
                    );
                })


                $('#tabelaRelEstoqueMat').DataTable().columns().every(
                    function () {
                        if ((colunasInvisiveis.relEstoqueMat).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })

                $('#tabelaRelEstoqueMat th').on('click', async function () {
                    const nomeColuna = $(this).html();
                    const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
                    const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
                    await buscaDados(nomeColuna + ' ' + ordenacao);
                });

            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados dos itens.');
            }
        } finally {
            $.LoadingOverlay("hide");
            $('#modal-filtros').modal('hide');
        }
    };

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaRelEstoqueMat').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relEstoqueMat ?? [])
    })

    $('#btnConsultar').on('click', async function () {
        await buscaDados();
    });

    async function retornaOrderBy(ordem) {
        let resultado;
        const pesquisa = {
            tabela: "ORDEM_TELA",
            camposSelect: ["NOME_ORD_SIST"],
            where: [`NOME_TELA = 'RelEstoqueMat' AND ORDEM = ${ordem}`]
        };
        const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        resultado = json[0].NOME_ORD_SIST;
        return resultado.replaceAll(';', ',')
    }

    async function buscaDepositos() {
        if ($.fn.DataTable.isDataTable('#tabelaLotesDepositos')) {
            $('#tabelaLotesDepositos').DataTable().destroy();
            $('#tabelaLotesDepositos').empty();
        };

        try {
            const where = await montaWherePesquisaDeposito();
            const campos = await montaCamposSelectDeposito();

            let dataSetCols = [];

            $.LoadingOverlay("show");

            for (let i = 0; i < campos.colunas.length; i++) {
                dataSetCols.push({
                    'title': campos.colunas[i],
                    'data': i
                });
            }

            const ajaxData = {
                EMPRESA: getCookie('empresa'),
                JSON: encodeURIComponent(`{
                "tabela":"MAT_ITEN", "camposSelect": ${campos.camposSelect},
                "leftJoin": [
                    {"tabela": "MATERIAL", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"},
                    {"tabela": "DEPOSITO", "condicao": "MAT_ITEN.DEPOSITO = DEPOSITO.CODIGO"}
                ],
                "where": ["1=1 ${where}"],
                "groupBy": ["MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO"]
            }`),
                CLIENTE: 'N',
            };

            dataSetCols[0].render = function (data, type, row, meta) {
                return '<div style="text-align:start;"> ' +
                    '    <button class="btn btn-info btn-sm btnVerificaOpcoes btnMostrarLotes" type="button" >Mostrar Lotes</button> ' +
                    '</div>'
            };

            $('#tabelaLotesDepositos').DataTable({
                paging: true,
                lengthChange: true, // habilita o select para mudar a quantidade de itens por página
                lengthMenu: [10, 25, 50, 100], // opções disponíveis no select
                pageLength: 10,
                filter: false,
                info: true,
                order: false,
                autoWidth: true,
                destroy: true,
                serverSide: true,
                processing: true,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "POST",
                    headers: {
                        'Authorization': BASIC_AUTH
                    },
                    data: ajaxData,
                },
                columns: dataSetCols,
                // columnDefs: [
                //     {
                //         render(data) {
                //             return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 4, maximumFractionDigits: 2 });
                //         },
                //         targets: [3],
                //     }
                // ]
            });


            $('#tabelaLotesDepositos').on('draw.dt', function () {
                const element = $('#tabelaLotesDepositos_length').parent().parent().children()[1];
                if (!$('#txtTotQtde').val()) {
                    $(element).prepend('<div class="row justify-content-end div-input"><label class="font-bold mt-2 mr-2">Total Quantidade: </label><input id="txtTotQtde" disabled class="form-control col-2 input-quantidade text-right" value="0"></input></div>');
                }
                const data = $('#tabelaLotesDepositos').DataTable().data().toArray();
                let totQtde = 0;
                for (r in data) {
                    totQtde += parseFloat($('#tabelaLotesDepositos').DataTable().data().toArray()[r][3].replace('.', '').replace(',', '.'));
                }
                $('#txtTotQtde').val(parseFloat(totQtde).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            })

        } catch (error) {
            console.log(error)
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function buscaLotesDepositos(dep = '') {
        if ($.fn.DataTable.isDataTable('#tabelaLotesDepositosModal')) {
            $('#tabelaLotesDepositosModal').DataTable().destroy();
            $('#tabelaLotesDepositosModal').empty();
        };

        try {
            let camposSelect = [];
            let colunas = [];
            camposSelect = `["MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "MATERIAL.CODIGO2", "MATERIAL.CODIGO", "MATERIAL.DESCRICAO DESC_MATERIAL", "MAT_ITEN.LOTE", "MAT_ITEN.LOTE_INTERNO", "SUM(MAT_ITEN.QTDE) QUANTIDADE", "MAT_ITEN.QUALIDADE", "MAT_ITEN.TONALIDADE", "MAT_ITEN.DT_FAB"]`;
            colunas = ["DEPOSITO", "DESC_DEPOSITO", "CODIGO2", "CODIGO", "DESC_MATERIAL", "LOTE", "LOTE_INTERNO", "QUANTIDADE", "QUALIDADE", "TONALIDADE", "DT_FAB"];

            let campos = {
                camposSelect: camposSelect,
                colunas: colunas
            };

            const where = await montaWherePesquisaDeposito(dep);

            let dataSetCols = [];

            $.LoadingOverlay("show");

            for (let i = 0; i < campos.colunas.length; i++) {
                dataSetCols.push({
                    'title': campos.colunas[i],
                    'data': i
                });
            }

            const ajaxData = {
                EMPRESA: getCookie('empresa'),
                JSON: encodeURIComponent(`{
                "tabela":"MAT_ITEN", "camposSelect": ${campos.camposSelect},
                "leftJoin": [
                    {"tabela": "MATERIAL", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"},
                    {"tabela": "DEPOSITO", "condicao": "MAT_ITEN.DEPOSITO = DEPOSITO.CODIGO"}
                ],
                "where": ["1=1 ${where}"],
                "groupBy": ["MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO", "MATERIAL.CODIGO2", "MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MAT_ITEN.LOTE", "MAT_ITEN.QUALIDADE", "MAT_ITEN.LOTE_INTERNO", "MAT_ITEN.TONALIDADE", "MAT_ITEN.DT_FAB"]
            }`),
                CLIENTE: 'N',
            };

            $('#tabelaLotesDepositosModal').DataTable({
                paging: true,
                lengthChange: false,
                filter: false,
                info: true,
                order: false,
                autoWidth: true,
                destroy: true,
                serverSide: true,
                processing: true,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "POST",
                    headers: {
                        'Authorization': BASIC_AUTH
                    },
                    data: ajaxData,
                },
                columns: dataSetCols,
                // columnDefs: [
                //     {
                //         render(data) {
                //             return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 4, maximumFractionDigits: 2 });
                //         },
                //         targets: [7],
                //     }
                // ]
            });

        } catch (error) {
            console.log(error)
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function montaWherePesquisaDeposito(deposito = '') {
        let where = ''
        let filtroDeposito = await buscaDepositoEmpresaUsuario();

        if (!$('#cbTodosDepositos').is(':checked')) {
            if (deposito == '') {
                if (filtroDeposito != '') {
                    where += $('#txtDepositoUsuario').val() != '' ? `AND MAT_ITEN.DEPOSITO IN (${await formataListas($('#txtDepositoUsuario').val().toString())})` : `AND MAT_ITEN.DEPOSITO IN (${filtroDeposito})`;
                } else {
                    where += $('#txtDepositoUsuario').val() != '' ? `AND MAT_ITEN.DEPOSITO IN (${await formataListas($('#txtDepositoUsuario').val().toString())})` : '';
                }
            } else {
                where += deposito != '' ? ` AND MAT_ITEN.DEPOSITO IN (${deposito})` : '';
            }
        } else {
            if (deposito == '') {
                where += $('#txtDepositoUsuario').val() != '' ? `AND MAT_ITEN.DEPOSITO IN (${await formataListas($('#txtDepositoUsuario').val().toString())})` : '';
            } else {
                where += deposito != '' ? ` AND MAT_ITEN.DEPOSITO IN (${deposito})` : '';
            }
        }

        where += $('#txtMaterial').val() != '' ? ` AND MATERIAL.CODIGO IN (${await formataListas($('#txtMaterial').val().toString())})` : '';
        where += $('#txtGrupoMA').val() != '' ? ` AND MATERIAL.GRUPO IN (${await formataListas($('#txtGrupoMA').val().toString())})` : '';
        where += $('#txtSubGrupo').val() != '' ? ` AND MATERIAL.SUB_GRUPO IN (${await formataListas($('#txtSubGrupo').val().toString())})` : '';
        where += $('#txtLinha').val() != '' ? ` AND MATERIAL.LINHA IN (${await formataListas($('#txtLinha').val().toString())})` : '';
        where += $('#txtQualidade').val() != '' ? ` AND MAT_ITEN.QUALIDADE IN (${await formataListas($('#txtQualidade').val().toString())})` : '';
        where += $('#txtLoteInterno').val() != '' ? ` AND MAT_ITEN.LOTE_INTERNO IN (${await formataListas($('#txtLoteInterno').val().toString())})` : '';
        where += $('#txtTonalidade').val() != '' ? ` AND MAT_ITEN.TONALIDADE IN (${await formataListas(('#txtTonalidade').val().toString())})` : '';
        where += $('#txtCor').val() != '' ? ` AND MAT_ITEN.COR IN (${await formataListas(('#txtCor').val().toString())})` : '';
        where += $('#txtColecao').val() != '' ? ` AND MAT_ITEN.COLECAO IN (${await formataListas(('#txtColecao').val().toString())})` : '';
        where += $('#txtComposicaoMaterial').val() != '' ? ` AND MAT_ITEN.COMPOSICAO IN (${await formataListas(('#txtComposicaoMaterial').val().toString())})` : '';
        where += $('#txtLote').val() != '' ? ` AND MAT_ITEN.LOTE IN (${await formataListas(('#txtLote').val().toString())})` : '';
        if ($('#cbContemEstoque').is(':checked')) {
            where += ` AND MAT_ITEN.QTDE > 0`
        }

        return where;
    }

    async function montaCamposSelectDeposito() {
        let camposSelect = [];
        let colunas = [];

        camposSelect = `["'' ACOES", "MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "SUM(MAT_ITEN.QTDE) QUANTIDADE"]`;
        colunas = ["ACOES", "DEPOSITO", "DESC_DEPOSITO", "QUANTIDADE"];

        return objeto = {
            camposSelect: camposSelect,
            colunas: colunas
        };
    }

    let depositoRow = '';

    $('#tabelaLotesDepositos').on('click', '.btnMostrarLotes', async function () {
        if ($('#tabelaLotesDepositos').DataTable().rows().count() > 0) {
            depositoRow = $('#tabelaLotesDepositos').DataTable().row($(this).closest('tr')).data()[1];
        }
        $('#modalLotesDeposito').modal('show')
    });

    $('#modalLotesDeposito').on('shown.bs.modal', async function () {
        await buscaLotesDepositos(depositoRow);
    })

});
